/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.AbstractDataSetManagement;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelledMarkerRenderer
extends AbstractDataSetManagement<LabelledMarkerRenderer>
implements Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelledMarkerRenderer.class);
    private static final String STYLE_CLASS_LABELLED_MARKER = "chart-labelled-marker";
    private static final String DEFAULT_FONT = "Helvetica";
    private static final int DEFAULT_FONT_SIZE = 18;
    private static final Color DEFAULT_GRID_LINE_COLOR = Color.GREEN;
    private static final double DEFAULT_GRID_LINE_WIDTH = 1.0;
    private static final double[] DEFAULT_GRID_DASH_PATTERM = new double[]{3.0, 3.0};
    protected final StringProperty style = new SimpleStringProperty((Object)this, "style", null);
    protected final BooleanProperty verticalMarker = new SimpleBooleanProperty((Object)this, "verticalMarker", true);
    protected final BooleanProperty horizontalMarker = new SimpleBooleanProperty((Object)this, "horizontalMarker", false);
    protected Paint strokeColorMarker = DEFAULT_GRID_LINE_COLOR;
    protected double strokeLineWidthMarker = 1.0;
    protected double[] strokeDashPattern = DEFAULT_GRID_DASH_PATTERM;

    public LabelledMarkerRenderer() {
        this.updateCSS();
        this.setShowInLegend(false);
    }

    protected void drawHorizontalLabelledMarker(GraphicsContext gc, XYChart chart, DataSet dataSet, int indexMin, int indexMax) {
        Axis yAxis = this.getFirstAxis(Orientation.VERTICAL, chart);
        gc.save();
        this.setGraphicsContextAttributes(gc, dataSet.getStyle());
        gc.setTextAlign(TextAlignment.RIGHT);
        double width = chart.getCanvas().getWidth();
        double lastLabel = -1.7976931348623157E308;
        double lastFontSize = 0.0;
        for (int i = indexMin; i < indexMax; ++i) {
            double screenY = (int)yAxis.getDisplayPosition(dataSet.get(1, i));
            String label = dataSet.getDataLabel(i);
            if (label == null) continue;
            String pointStyle = dataSet.getStyle(i);
            if (pointStyle != null) {
                gc.save();
                this.setGraphicsContextAttributes(gc, pointStyle);
            }
            gc.strokeLine(0.0, screenY, width, screenY);
            if (Math.abs(screenY - lastLabel) > lastFontSize && !label.isEmpty()) {
                gc.save();
                gc.setLineWidth(0.8);
                gc.setLineDashes(new double[]{1.0});
                gc.translate(Math.ceil(screenY + 3.0), Math.ceil(0.99 * width));
                gc.fillText(label, 0.0, 0.0);
                gc.restore();
                lastLabel = screenY;
                lastFontSize = gc.getFont().getSize();
            }
            if (pointStyle == null) continue;
            gc.restore();
        }
        gc.restore();
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        return null;
    }

    protected void drawVerticalLabelledMarker(GraphicsContext gc, XYChart chart, DataSet dataSet, int indexMin, int indexMax) {
        Axis xAxis = this.getFirstAxis(Orientation.HORIZONTAL);
        if (xAxis == null) {
            xAxis = chart.getFirstAxis(Orientation.HORIZONTAL);
        }
        if (xAxis == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.atWarn().addArgument((Object)LabelledMarkerRenderer.class.getSimpleName()).log("{}::drawVerticalLabelledMarker(...) getFirstAxis(HORIZONTAL) returned null skip plotting");
            }
            return;
        }
        gc.save();
        this.setGraphicsContextAttributes(gc, dataSet.getStyle());
        gc.setTextAlign(TextAlignment.LEFT);
        double height = chart.getCanvas().getHeight();
        double lastLabel = -1.7976931348623157E308;
        double lastFontSize = 0.0;
        for (int i = indexMin; i < indexMax; ++i) {
            double screenX = (int)xAxis.getDisplayPosition(dataSet.get(0, i));
            String label = dataSet.getDataLabel(i);
            if (label == null) continue;
            String pointStyle = dataSet.getStyle(i);
            if (pointStyle != null) {
                gc.save();
                this.setGraphicsContextAttributes(gc, pointStyle);
            }
            gc.strokeLine(screenX, 0.0, screenX, height);
            if (Math.abs(screenX - lastLabel) > lastFontSize && !label.isEmpty()) {
                gc.save();
                gc.setLineWidth(0.8);
                gc.setLineDashes(new double[]{1.0});
                gc.translate(Math.ceil(screenX + 3.0), Math.ceil(0.01 * height));
                gc.rotate(90.0);
                gc.fillText(label, 0.0, 0.0);
                gc.restore();
                lastLabel = screenX;
                lastFontSize = gc.getFont().getSize();
            }
            if (pointStyle == null) continue;
            gc.restore();
        }
        gc.restore();
    }

    public LabelledMarkerRenderer enableHorizontalMarker(boolean state) {
        this.horizontalMarkerProperty().set(state);
        return this.getThis();
    }

    public LabelledMarkerRenderer enableVerticalMarker(boolean state) {
        this.verticalMarkerProperty().set(state);
        return this.getThis();
    }

    public String getStyle() {
        return (String)this.styleProperty().get();
    }

    @Override
    protected LabelledMarkerRenderer getThis() {
        return this;
    }

    public BooleanProperty horizontalMarkerProperty() {
        return this.horizontalMarker;
    }

    public boolean isHorizontalMarker() {
        return this.horizontalMarkerProperty().get();
    }

    public boolean isVerticalMarker() {
        return this.verticalMarkerProperty().get();
    }

    @Override
    public List<DataSet> render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        long start = ProcessingProfiler.getTimeStamp();
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)this.getDatasets());
        if (localDataSetList.isEmpty()) {
            return Collections.emptyList();
        }
        Axis xAxis = this.getFirstAxis(Orientation.HORIZONTAL);
        if (xAxis == null) {
            xAxis = xyChart.getFirstAxis(Orientation.HORIZONTAL);
        }
        if (xAxis == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.atWarn().addArgument((Object)LabelledMarkerRenderer.class.getSimpleName()).log("{}::render(...) getFirstAxis(HORIZONTAL) returned null skip plotting");
            }
            return Collections.emptyList();
        }
        double xAxisWidth = xAxis.getWidth();
        double xMin = xAxis.getValueForDisplay(0.0);
        double xMax = xAxis.getValueForDisplay(xAxisWidth);
        ArrayList<DataSet> drawnDataSet = new ArrayList<DataSet>(localDataSetList.size());
        for (int dataSetIndex = localDataSetList.size() - 1; dataSetIndex >= 0; --dataSetIndex) {
            DataSet dataSet = (DataSet)localDataSetList.get(dataSetIndex);
            if (!dataSet.isVisible()) continue;
            dataSet.lock().readLockGuard(() -> {
                int indexMin = Math.max(0, dataSet.getIndex(0, new double[]{xMin}));
                int indexMax = Math.min(dataSet.getIndex(0, new double[]{xMax}) + 1, dataSet.getDataCount());
                if (indexMax - indexMin <= 0) {
                    return;
                }
                drawnDataSet.add(dataSet);
                if (this.isHorizontalMarker()) {
                    this.drawHorizontalLabelledMarker(gc, xyChart, dataSet, indexMin, indexMax);
                }
                if (this.isVerticalMarker()) {
                    this.drawVerticalLabelledMarker(gc, xyChart, dataSet, indexMin, indexMax);
                }
            });
        }
        ProcessingProfiler.getTimeDiff((long)start);
        return drawnDataSet;
    }

    protected void setGraphicsContextAttributes(GraphicsContext gc, String style) {
        Color strokeColor = StyleParser.getColorPropertyValue(style, "strokeColor");
        if (strokeColor == null) {
            gc.setStroke(this.strokeColorMarker);
        } else {
            gc.setStroke((Paint)strokeColor);
        }
        Color fillColor = StyleParser.getColorPropertyValue(style, "fillColor");
        if (fillColor == null) {
            gc.setFill(this.strokeColorMarker);
        } else {
            gc.setFill((Paint)fillColor);
        }
        Double strokeWidth = StyleParser.getFloatingDecimalPropertyValue(style, "strokeWidth");
        gc.setLineWidth(Objects.requireNonNullElseGet(strokeWidth, () -> this.strokeLineWidthMarker).doubleValue());
        Font font = StyleParser.getFontPropertyValue(style);
        if (font == null) {
            gc.setFont(Font.font((String)DEFAULT_FONT, (double)18.0));
        } else {
            gc.setFont(font);
        }
        double[] dashPattern = StyleParser.getFloatingDecimalArrayPropertyValue(style, "strokeDashPattern");
        if (dashPattern == null) {
            gc.setLineDashes(this.strokeDashPattern);
        } else {
            gc.setLineDashes(dashPattern);
        }
    }

    public LabelledMarkerRenderer setStyle(String newStyle) {
        this.styleProperty().set((Object)newStyle);
        return this.getThis();
    }

    public StringProperty styleProperty() {
        return this.style;
    }

    public final LabelledMarkerRenderer updateCSS() {
        this.strokeColorMarker = DEFAULT_GRID_LINE_COLOR;
        this.strokeLineWidthMarker = 1.0;
        this.strokeDashPattern = DEFAULT_GRID_DASH_PATTERM;
        return this.getThis();
    }

    public BooleanProperty verticalMarkerProperty() {
        return this.verticalMarker;
    }
}

