/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.GridDataSet;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.locks.DataSetLock;
import de.gsi.dataset.locks.DefaultDataSetLock;
import de.gsi.dataset.spi.DefaultAxisDescription;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.canvas.GraphicsContext;

public class MountainRangeRenderer
extends ErrorDataSetRenderer
implements Renderer {
    private static final int MIN_DIM = 3;
    protected DoubleProperty mountainRangeOffset = new SimpleDoubleProperty((Object)this, "mountainRangeOffset", 0.5);
    private final ObservableList<ErrorDataSetRenderer> renderers = FXCollections.observableArrayList();
    private final ObservableList<DataSet> empty = FXCollections.observableArrayList();
    private final WeakHashMap<Double, Integer> xWeakIndexMap = new WeakHashMap();
    private final WeakHashMap<Double, Integer> yWeakIndexMap = new WeakHashMap();
    private double mountainRangeExtra;

    public MountainRangeRenderer() {
        this.setDrawMarker(false);
        this.setDrawBars(false);
        this.setErrorType(ErrorStyle.NONE);
        this.xWeakIndexMap.clear();
        this.yWeakIndexMap.clear();
    }

    public MountainRangeRenderer(double mountainRangeOffset) {
        this();
        this.setMountainRangeOffset(mountainRangeOffset);
    }

    public final double getMountainRangeOffset() {
        return this.mountainRangeOffset.get();
    }

    public final DoubleProperty mountainRangeOffsetProperty() {
        return this.mountainRangeOffset;
    }

    @Override
    public List<DataSet> render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        long start = ProcessingProfiler.getTimeStamp();
        XYChart xyChart = (XYChart)chart;
        Axis yAxis = xyChart.getYAxis();
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)this.getDatasets());
        double zRangeMin = localDataSetList.stream().mapToDouble(ds -> ds.getAxisDescription(2).getMin()).min().orElse(-1.0);
        double zRangeMax = localDataSetList.stream().mapToDouble(ds -> ds.getAxisDescription(2).getMax()).max().orElse(1.0);
        for (int dataSetIndex = localDataSetList.size() - 1; dataSetIndex >= 0; --dataSetIndex) {
            DataSet dataSet = (DataSet)localDataSetList.get(dataSetIndex);
            if (!dataSet.isVisible() || !(dataSet instanceof GridDataSet)) continue;
            dataSet.lock().readLockGuardOptimistic(() -> {
                this.xWeakIndexMap.clear();
                this.yWeakIndexMap.clear();
                this.mountainRangeExtra = this.getMountainRangeOffset();
                double max = zRangeMax * (1.0 + this.mountainRangeExtra);
                boolean autoRange = yAxis.isAutoRanging();
                if (autoRange && (zRangeMin != yAxis.getMin() || max != yAxis.getMax())) {
                    yAxis.setAutoRanging(false);
                    yAxis.setMin(zRangeMin);
                    yAxis.setMax(max);
                    yAxis.setTickUnit(Math.abs(max - zRangeMin) / 10.0);
                    yAxis.forceRedraw();
                }
                yAxis.setAutoRanging(autoRange);
                int yCountMax = ((GridDataSet)dataSet).getShape(1);
                this.checkAndRecreateRenderer(yCountMax);
                for (int index = yCountMax - 1; index >= 0; --index) {
                    ((ErrorDataSetRenderer)this.renderers.get(index)).getDatasets().setAll((Object[])new DataSet[]{new Demux3dTo2dDataSet((GridDataSet)dataSet, index, zRangeMin, max)});
                    ((ErrorDataSetRenderer)this.renderers.get(index)).render(gc, chart, 0, this.empty);
                }
            });
        }
        ProcessingProfiler.getTimeDiff((long)start);
        return localDataSetList;
    }

    public MountainRangeRenderer setMountainRangeOffset(double mountainRangeOffset) {
        AssertUtils.gtEqThanZero((String)"mountainRangeOffset", (double)mountainRangeOffset);
        this.mountainRangeOffset.setValue((Number)mountainRangeOffset);
        return this;
    }

    private void checkAndRecreateRenderer(int nRenderer) {
        if (this.renderers.size() == nRenderer) {
            return;
        }
        if (nRenderer > this.renderers.size()) {
            for (int i = this.renderers.size(); i < nRenderer; ++i) {
                ErrorDataSetRenderer newRenderer = new ErrorDataSetRenderer();
                newRenderer.bind(this);
                newRenderer.showInLegendProperty().unbind();
                newRenderer.setShowInLegend(false);
                this.renderers.add((Object)newRenderer);
            }
            return;
        }
        while (nRenderer < this.renderers.size()) {
            this.renderers.remove(0);
        }
    }

    private class Demux3dTo2dDataSet
    implements DataSet {
        private static final long serialVersionUID = 3914728138839091421L;
        private final transient DataSetLock<DataSet> localLock = new DefaultDataSetLock((DataSet)this);
        private final transient AtomicBoolean autoNotify = new AtomicBoolean(true);
        private final GridDataSet dataSet;
        private final int yIndex;
        private final double zMin;
        private final double zMax;
        private final double yShift;
        private final transient List<EventListener> updateListener = new ArrayList<EventListener>();
        private final transient List<AxisDescription> axesDescriptions = new ArrayList<DefaultAxisDescription>(Arrays.asList(new DefaultAxisDescription(0, "x-Axis", new String[]{"a.u."}), new DefaultAxisDescription(1, "y-Axis", new String[]{"a.u."})));

        public Demux3dTo2dDataSet(GridDataSet sourceDataSet, int selectedYIndex, double zMin, double zMax) {
            this.dataSet = sourceDataSet;
            this.yIndex = selectedYIndex;
            this.zMin = zMin;
            this.zMax = zMax;
            this.yShift = this.dataSet.getShape(1) > 0 ? MountainRangeRenderer.this.mountainRangeExtra * this.dataSet.getAxisDescription(2).getMax() * (double)this.yIndex / (double)this.dataSet.getShape(1) : 0.0;
        }

        public AtomicBoolean autoNotification() {
            return this.autoNotify;
        }

        public double get(int dimIndex, int i) {
            switch (dimIndex) {
                case 0: {
                    return this.dataSet.getGrid(dimIndex, i);
                }
                case 1: {
                    return this.dataSet.get(2, new int[]{i, this.yIndex}) + this.yShift;
                }
            }
            throw new IllegalArgumentException("dinIndex " + dimIndex + " not defined");
        }

        public List<AxisDescription> getAxisDescriptions() {
            return this.axesDescriptions;
        }

        public int getDataCount() {
            return this.dataSet.getShape(0);
        }

        public String getDataLabel(int index) {
            return this.dataSet.getDataLabel(index);
        }

        public int getDimension() {
            return 2;
        }

        public int getIndex(int dimIndex, double ... value) {
            AssertUtils.checkArrayDimension((String)"value", (double[])value, (int)1);
            switch (dimIndex) {
                case 0: {
                    return MountainRangeRenderer.this.xWeakIndexMap.computeIfAbsent(value[0], key -> this.dataSet.getGridIndex(0, key.doubleValue()));
                }
                case 1: {
                    return MountainRangeRenderer.this.yWeakIndexMap.computeIfAbsent(value[0], key -> this.dataSet.getGridIndex(1, key.doubleValue()));
                }
            }
            throw new IndexOutOfBoundsException("dimIndex=" + dimIndex + " out of range");
        }

        public String getName() {
            return this.dataSet.getName() + ":slice#" + this.yIndex;
        }

        public String getStyle() {
            return this.dataSet.getStyle();
        }

        public String getStyle(int index) {
            return null;
        }

        public double[] getValues(int dimIndex) {
            switch (dimIndex) {
                case 0: {
                    return this.dataSet.getGridValues(dimIndex);
                }
                case 1: {
                    double[] result = new double[this.dataSet.getShape(0)];
                    for (int i = 0; i < result.length; ++i) {
                        result[i] = this.dataSet.getValue(2, new double[]{i, this.yIndex}) + this.yShift;
                    }
                    return result;
                }
            }
            throw new IllegalArgumentException("dinIndex " + dimIndex + " not defined");
        }

        public boolean isAutoNotification() {
            return this.autoNotify.get();
        }

        public DataSetLock<DataSet> lock() {
            return this.localLock;
        }

        public DataSet recomputeLimits(int dimension) {
            this.getAxisDescription(0).set(this.dataSet.getAxisDescription(0));
            this.getAxisDescription(1).set(this.zMin, this.zMax);
            return this;
        }

        public DataSet setStyle(String style) {
            return this.dataSet.setStyle(style);
        }

        public double getValue(int dimIndex, double ... x) {
            return 0.0;
        }

        public DataSet set(DataSet other, boolean copy) {
            throw new UnsupportedOperationException("copy setter not implemented for Demux3dTo2dDataSet");
        }

        public boolean isVisible() {
            return this.dataSet.isVisible();
        }

        public DataSet setVisible(boolean visible) {
            return this.dataSet.setVisible(visible);
        }

        public List<EventListener> updateEventListener() {
            return this.updateListener;
        }
    }
}

