/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.financial;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.financial.AbstractFinancialRenderer;
import de.gsi.chart.renderer.spi.financial.service.OhlcvRendererEpData;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEP;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEPAware;
import de.gsi.chart.renderer.spi.utils.DefaultRenderColorScheme;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.financial.api.attrs.AttributeModelAware;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItemAware;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class CandleStickRenderer
extends AbstractFinancialRenderer<CandleStickRenderer>
implements Renderer,
RendererPaintAfterEPAware {
    private final boolean paintVolume;
    private final AbstractFinancialRenderer.FindAreaDistances findAreaDistances;
    protected final List<RendererPaintAfterEP> paintAfterEPS = new ArrayList<RendererPaintAfterEP>();

    public CandleStickRenderer(boolean paintVolume) {
        this.paintVolume = paintVolume;
        this.findAreaDistances = paintVolume ? new AbstractFinancialRenderer.XMinVolumeMaxAreaDistances() : new AbstractFinancialRenderer.XMinAreaDistances();
    }

    public CandleStickRenderer() {
        this(false);
    }

    public boolean isPaintVolume() {
        return this.paintVolume;
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        Canvas canvas = new Canvas((double)width, (double)height);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        String style = dataSet.getStyle();
        gc.save();
        Color candleLongColor = StyleParser.getColorPropertyValue(style, "candleLongColor", Color.GREEN);
        Color candleShortColor = StyleParser.getColorPropertyValue(style, "candleShortColor", Color.RED);
        gc.setFill((Paint)candleLongColor);
        gc.setStroke((Paint)candleLongColor);
        gc.fillRect(1.0, 3.0, (double)width / 2.0 - 2.0, (double)height - 8.0);
        double x = (double)width / 4.0;
        gc.strokeLine(x, 1.0, x, (double)height - 2.0);
        gc.setFill((Paint)candleShortColor);
        gc.setStroke((Paint)candleShortColor);
        gc.fillRect((double)width / 2.0 + 2.0, 4.0, (double)width - 2.0, (double)height - 12.0);
        x = 3.0 * (double)width / 4.0 + 1.5;
        gc.strokeLine(x, 1.0, x, (double)height - 3.0);
        gc.restore();
        return canvas;
    }

    @Override
    protected CandleStickRenderer getThis() {
        return this;
    }

    @Override
    public List<DataSet> render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)super.getDatasets());
        long start = 0L;
        if (ProcessingProfiler.getDebugState()) {
            start = ProcessingProfiler.getTimeStamp();
        }
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        double xAxisWidth = xAxis.getWidth();
        double xmin = xAxis.getValueForDisplay(0.0);
        double xmax = xAxis.getValueForDisplay(xAxisWidth);
        int index = 0;
        for (DataSet ds : localDataSetList) {
            if (!ds.isVisible() || ds.getDimension() < 7) continue;
            int lindex = index;
            ds.lock().readLockGuardOptimistic(() -> {
                if (lindex == 0 && xyChart.getXAxis() instanceof CategoryAxis) {
                    CategoryAxis axis = (CategoryAxis)xyChart.getXAxis();
                    axis.updateCategories(ds);
                }
                AttributeModelAware attrs = null;
                if (ds instanceof AttributeModelAware) {
                    attrs = (AttributeModelAware)ds;
                }
                IOhlcvItemAware itemAware = null;
                if (ds instanceof IOhlcvItemAware) {
                    itemAware = (IOhlcvItemAware)ds;
                }
                boolean isEpAvailable = !this.paintAfterEPS.isEmpty() || this.paintBarMarker != null;
                gc.save();
                String style = ds.getStyle();
                DefaultRenderColorScheme.setLineScheme(gc, style, lindex);
                DefaultRenderColorScheme.setGraphicsContextAttributes(gc, style);
                Color candleLongColor = StyleParser.getColorPropertyValue(style, "candleLongColor", Color.GREEN);
                Color candleShortColor = StyleParser.getColorPropertyValue(style, "candleShortColor", Color.RED);
                Color candleLongWickColor = StyleParser.getColorPropertyValue(style, "candleLongWickColor", Color.BLACK);
                Color candleShortWickColor = StyleParser.getColorPropertyValue(style, "candleShortWickColor", Color.BLACK);
                Color candleShadowColor = StyleParser.getColorPropertyValue(style, "candleShadowColor", null);
                Color candleVolumeLongColor = StyleParser.getColorPropertyValue(style, "candleVolumeLongColor", Color.rgb((int)139, (int)199, (int)194, (double)0.2));
                Color candleVolumeShortColor = StyleParser.getColorPropertyValue(style, "candleVolumeShortColor", Color.rgb((int)235, (int)160, (int)159, (double)0.2));
                double barWidthPercent = StyleParser.getFloatingDecimalPropertyValue(style, "barWidthPercent", 0.5);
                double shadowLineWidth = StyleParser.getFloatingDecimalPropertyValue(style, "shadowLineWidth", 2.5);
                double shadowTransPercent = StyleParser.getFloatingDecimalPropertyValue(style, "shadowTransPercent", 0.5);
                if (ds.getDataCount() > 0) {
                    int iMin = ds.getIndex(0, new double[]{xmin});
                    if (iMin < 0) {
                        iMin = 0;
                    }
                    int iMax = Math.min(ds.getIndex(0, new double[]{xmax}) + 1, ds.getDataCount());
                    double[] distances = null;
                    double minRequiredWidth = 0.0;
                    if (lindex == 0) {
                        distances = this.findAreaDistances(this.findAreaDistances, ds, xAxis, yAxis, xmin, xmax);
                        minRequiredWidth = distances[0];
                    }
                    double localBarWidth = minRequiredWidth * barWidthPercent;
                    double barWidthHalf = localBarWidth / 2.0;
                    for (int i = iMin; i < iMax; ++i) {
                        Paint barPaint;
                        double x0 = xAxis.getDisplayPosition(ds.get(0, i));
                        double yOpen = yAxis.getDisplayPosition(ds.get(1, i));
                        double yHigh = yAxis.getDisplayPosition(ds.get(2, i));
                        double yLow = yAxis.getDisplayPosition(ds.get(3, i));
                        double yClose = yAxis.getDisplayPosition(ds.get(4, i));
                        double yDiff = yOpen - yClose;
                        double yMin = yDiff > 0.0 ? yClose : yOpen;
                        OhlcvRendererEpData data = null;
                        if (isEpAvailable) {
                            data = new OhlcvRendererEpData();
                            data.gc = gc;
                            data.ds = ds;
                            data.attrs = attrs;
                            data.ohlcvItemAware = itemAware;
                            data.ohlcvItem = itemAware != null ? itemAware.getItem(i) : null;
                            data.index = i;
                            data.minIndex = iMin;
                            data.maxIndex = iMax;
                            data.barWidth = localBarWidth;
                            data.barWidthHalf = barWidthHalf;
                            data.xCenter = x0;
                            data.yOpen = yOpen;
                            data.yHigh = yHigh;
                            data.yLow = yLow;
                            data.yClose = yClose;
                            data.yDiff = yDiff;
                            data.yMin = yMin;
                        }
                        if (this.paintVolume) {
                            assert (distances != null);
                            this.paintVolume(gc, ds, i, candleVolumeLongColor, candleVolumeShortColor, yAxis, distances, localBarWidth, barWidthHalf, x0);
                        }
                        if (candleShadowColor != null) {
                            double lineWidth = gc.getLineWidth();
                            this.paintCandleShadow(gc, candleShadowColor, shadowLineWidth, shadowTransPercent, localBarWidth, barWidthHalf, x0, yOpen, yClose, yLow, yHigh, yDiff, yMin);
                            gc.setLineWidth(lineWidth);
                        }
                        Paint paint = barPaint = data == null ? null : this.getPaintBarColor(data);
                        if (yDiff > 0.0) {
                            gc.setFill((Paint)Objects.requireNonNullElse(barPaint, candleLongColor));
                            gc.setStroke((Paint)Objects.requireNonNullElse(barPaint, candleLongWickColor));
                        } else {
                            yDiff = Math.abs(yDiff);
                            gc.setFill((Paint)Objects.requireNonNullElse(barPaint, candleShortColor));
                            gc.setStroke((Paint)Objects.requireNonNullElse(barPaint, candleShortWickColor));
                        }
                        gc.strokeLine(x0, yLow, x0, yDiff > 0.0 ? yOpen : yClose);
                        gc.strokeLine(x0, yHigh, x0, yDiff > 0.0 ? yClose : yOpen);
                        gc.fillRect(x0 - barWidthHalf, yMin, localBarWidth, yDiff);
                        gc.strokeRect(x0 - barWidthHalf, yMin, localBarWidth, yDiff);
                        if (this.paintAfterEPS.isEmpty()) continue;
                        this.paintAfter(data);
                    }
                }
                gc.restore();
            });
            if (this.computeLocalRange()) {
                this.applyLocalYRange(ds, yAxis, xmin, xmax);
            }
            ++index;
        }
        if (ProcessingProfiler.getDebugState()) {
            ProcessingProfiler.getTimeDiff((long)start);
        }
        return localDataSetList;
    }

    protected void paintAfter(OhlcvRendererEpData data) {
        for (RendererPaintAfterEP paintAfterEP : this.paintAfterEPS) {
            paintAfterEP.paintAfter(data);
        }
    }

    protected void paintCandleShadow(GraphicsContext gc, Color shadowColor, double shadowLineWidth, double shadowTransPercent, double localBarWidth, double barWidthHalf, double x0, double yOpen, double yClose, double yLow, double yHigh, double yDiff, double yMin) {
        double trans = shadowTransPercent * barWidthHalf;
        gc.setLineWidth(shadowLineWidth);
        gc.setFill((Paint)shadowColor);
        gc.setStroke((Paint)shadowColor);
        gc.strokeLine(x0 + trans, yLow + trans, x0 + trans, yDiff > 0.0 ? yOpen + trans : yClose + trans);
        gc.strokeLine(x0 + trans, yHigh + trans, x0 + trans, yDiff > 0.0 ? yClose + trans : yOpen + trans);
        gc.fillRect(x0 - barWidthHalf + trans, yMin + trans, localBarWidth, Math.abs(yDiff));
    }

    @Override
    public void addPaintAfterEp(RendererPaintAfterEP paintAfterEP) {
        this.paintAfterEPS.add(paintAfterEP);
    }

    @Override
    public List<RendererPaintAfterEP> getPaintAfterEps() {
        return this.paintAfterEPS;
    }
}

