/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.financial;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.financial.AbstractFinancialRenderer;
import de.gsi.chart.renderer.spi.financial.service.OhlcvRendererEpData;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEP;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEPAware;
import de.gsi.chart.renderer.spi.utils.DefaultRenderColorScheme;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.financial.api.attrs.AttributeModelAware;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItemAware;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class HighLowRenderer
extends AbstractFinancialRenderer<HighLowRenderer>
implements Renderer,
RendererPaintAfterEPAware {
    private final boolean paintVolume;
    private final AbstractFinancialRenderer.FindAreaDistances findAreaDistances;
    protected List<RendererPaintAfterEP> paintAfterEPS = new ArrayList<RendererPaintAfterEP>();

    public HighLowRenderer(boolean paintVolume) {
        this.paintVolume = paintVolume;
        this.findAreaDistances = paintVolume ? new AbstractFinancialRenderer.XMinVolumeMaxAreaDistances() : new AbstractFinancialRenderer.XMinAreaDistances();
    }

    public HighLowRenderer() {
        this(false);
    }

    public boolean isPaintVolume() {
        return this.paintVolume;
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        Canvas canvas = new Canvas((double)width, (double)height);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        String style = dataSet.getStyle();
        gc.save();
        Color longBodyColor = StyleParser.getColorPropertyValue(style, "highLowLongColor", Color.GREEN);
        Color shortBodyColor = StyleParser.getColorPropertyValue(style, "highLowShortColor", Color.RED);
        gc.setStroke((Paint)shortBodyColor);
        double x = (double)width / 4.0;
        gc.strokeLine(2.0, 3.0, x, 3.0);
        gc.strokeLine(x, (double)height - 4.0, (double)width / 2.0 - 2.0, (double)height - 4.0);
        gc.strokeLine(x, 1.0, x, (double)height - 2.0);
        gc.setStroke((Paint)longBodyColor);
        x = 3.0 * (double)width / 4.0;
        gc.strokeLine(x - 3.0, (double)height - 8.0, x, (double)height - 8.0);
        gc.strokeLine(x, 5.0, x + 3.0, 5.0);
        gc.strokeLine(x, 2.0, x, (double)height - 2.0);
        gc.restore();
        return canvas;
    }

    @Override
    protected HighLowRenderer getThis() {
        return this;
    }

    @Override
    public List<DataSet> render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)super.getDatasets());
        long start = 0L;
        if (ProcessingProfiler.getDebugState()) {
            start = ProcessingProfiler.getTimeStamp();
        }
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        double xAxisWidth = xAxis.getWidth();
        double xmin = xAxis.getValueForDisplay(0.0);
        double xmax = xAxis.getValueForDisplay(xAxisWidth);
        int index = 0;
        for (DataSet ds : localDataSetList) {
            if (!ds.isVisible() || ds.getDimension() < 7) continue;
            int lindex = index;
            ds.lock().readLockGuardOptimistic(() -> {
                if (lindex == 0 && xyChart.getXAxis() instanceof CategoryAxis) {
                    CategoryAxis axis = (CategoryAxis)xyChart.getXAxis();
                    axis.updateCategories(ds);
                }
                AttributeModelAware attrs = null;
                if (ds instanceof AttributeModelAware) {
                    attrs = (AttributeModelAware)ds;
                }
                IOhlcvItemAware itemAware = null;
                if (ds instanceof IOhlcvItemAware) {
                    itemAware = (IOhlcvItemAware)ds;
                }
                boolean isEpAvailable = !this.paintAfterEPS.isEmpty() || this.paintBarMarker != null;
                gc.save();
                String style = ds.getStyle();
                DefaultRenderColorScheme.setLineScheme(gc, style, lindex);
                DefaultRenderColorScheme.setGraphicsContextAttributes(gc, style);
                Color longBodyColor = StyleParser.getColorPropertyValue(style, "highLowLongColor", Color.GREEN);
                Color shortBodyColor = StyleParser.getColorPropertyValue(style, "highLowShortColor", Color.RED);
                Color longTickColor = StyleParser.getColorPropertyValue(style, "highLowLongTickColor", Color.GREEN);
                Color shortTickColor = StyleParser.getColorPropertyValue(style, "highLowShortTickColor", Color.RED);
                Color hiLowShadowColor = StyleParser.getColorPropertyValue(style, "hiLowShadowColor", null);
                Color candleVolumeLongColor = StyleParser.getColorPropertyValue(style, "candleVolumeLongColor", Color.rgb((int)139, (int)199, (int)194, (double)0.2));
                Color candleVolumeShortColor = StyleParser.getColorPropertyValue(style, "candleVolumeShortColor", Color.rgb((int)235, (int)160, (int)159, (double)0.2));
                double bodyLineWidth = StyleParser.getFloatingDecimalPropertyValue(style, "highLowBodyLineWidth", 1.2);
                double tickLineWidth = StyleParser.getFloatingDecimalPropertyValue(style, "highLowTickLineWidth", 1.2);
                double barWidthPercent = StyleParser.getFloatingDecimalPropertyValue(style, "hiLowBarWidthPercent", 0.6);
                double shadowLineWidth = StyleParser.getFloatingDecimalPropertyValue(style, "shadowLineWidth", 2.5);
                double shadowTransPercent = StyleParser.getFloatingDecimalPropertyValue(style, "shadowTransPercent", 0.5);
                if (ds.getDataCount() > 0) {
                    int iMin = ds.getIndex(0, new double[]{xmin});
                    if (iMin < 0) {
                        iMin = 0;
                    }
                    int iMax = Math.min(ds.getIndex(0, new double[]{xmax}) + 1, ds.getDataCount());
                    double[] distances = null;
                    double minRequiredWidth = 0.0;
                    if (lindex == 0) {
                        distances = this.findAreaDistances(this.findAreaDistances, ds, xAxis, yAxis, xmin, xmax);
                        minRequiredWidth = distances[0];
                    }
                    double localBarWidth = minRequiredWidth * barWidthPercent;
                    double barWidthHalf = localBarWidth / 2.0;
                    for (int i = iMin; i < iMax; ++i) {
                        double x0 = xAxis.getDisplayPosition(ds.get(0, i));
                        double yOpen = yAxis.getDisplayPosition(ds.get(1, i));
                        double yHigh = yAxis.getDisplayPosition(ds.get(2, i));
                        double yLow = yAxis.getDisplayPosition(ds.get(3, i));
                        double yClose = yAxis.getDisplayPosition(ds.get(4, i));
                        OhlcvRendererEpData data = null;
                        if (isEpAvailable) {
                            data = new OhlcvRendererEpData();
                            data.gc = gc;
                            data.ds = ds;
                            data.attrs = attrs;
                            data.ohlcvItemAware = itemAware;
                            data.ohlcvItem = itemAware != null ? itemAware.getItem(i) : null;
                            data.index = i;
                            data.minIndex = iMin;
                            data.maxIndex = iMax;
                            data.barWidth = localBarWidth;
                            data.barWidthHalf = barWidthHalf;
                            data.xCenter = x0;
                            data.yOpen = yOpen;
                            data.yHigh = yHigh;
                            data.yLow = yLow;
                            data.yClose = yClose;
                        }
                        if (this.paintVolume) {
                            assert (distances != null);
                            this.paintVolume(gc, ds, i, candleVolumeLongColor, candleVolumeShortColor, yAxis, distances, localBarWidth, barWidthHalf, x0);
                        }
                        if (hiLowShadowColor != null) {
                            double lineWidth = gc.getLineWidth();
                            this.paintHiLowShadow(gc, hiLowShadowColor, shadowLineWidth, shadowTransPercent, barWidthHalf, x0, yOpen, yClose, yLow, yHigh);
                            gc.setLineWidth(lineWidth);
                        }
                        Paint barPaint = data == null ? null : this.getPaintBarColor(data);
                        gc.setStroke((Paint)Objects.requireNonNullElse(barPaint, yOpen > yClose ? longBodyColor : shortBodyColor));
                        gc.setLineWidth(bodyLineWidth);
                        gc.strokeLine(x0, yLow, x0, yHigh);
                        gc.setStroke((Paint)Objects.requireNonNullElse(barPaint, yOpen > yClose ? longTickColor : shortTickColor));
                        gc.setLineWidth(tickLineWidth);
                        gc.strokeLine(x0 - barWidthHalf, yOpen, x0, yOpen);
                        gc.strokeLine(x0, yClose, x0 + barWidthHalf, yClose);
                        if (this.paintAfterEPS.isEmpty()) continue;
                        this.paintAfter(data);
                    }
                }
                gc.restore();
            });
            if (this.computeLocalRange()) {
                this.applyLocalYRange(ds, yAxis, xmin, xmax);
            }
            ++index;
        }
        if (ProcessingProfiler.getDebugState()) {
            ProcessingProfiler.getTimeDiff((long)start);
        }
        return localDataSetList;
    }

    protected void paintAfter(OhlcvRendererEpData data) {
        for (RendererPaintAfterEP paintAfterEP : this.paintAfterEPS) {
            paintAfterEP.paintAfter(data);
        }
    }

    protected void paintHiLowShadow(GraphicsContext gc, Color shadowColor, double shadowLineWidth, double shadowTransPercent, double barWidthHalf, double x0, double yOpen, double yClose, double yLow, double yHigh) {
        double trans = shadowTransPercent * barWidthHalf;
        gc.setLineWidth(shadowLineWidth);
        gc.setStroke((Paint)shadowColor);
        gc.strokeLine(x0 + trans, yLow + trans, x0 + trans, yHigh + trans);
        gc.strokeLine(x0 - barWidthHalf + trans, yOpen + trans, x0 + trans, yOpen + trans);
        gc.strokeLine(x0 + trans, yClose + trans, x0 + barWidthHalf + trans, yClose + trans);
    }

    @Override
    public void addPaintAfterEp(RendererPaintAfterEP paintAfterEP) {
        this.paintAfterEPS.add(paintAfterEP);
    }

    @Override
    public List<RendererPaintAfterEP> getPaintAfterEps() {
        return this.paintAfterEPS;
    }
}

