/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.financial.css;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.spi.AbstractAxisParameter;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.financial.CandleStickRenderer;
import de.gsi.chart.renderer.spi.financial.FootprintRenderer;
import de.gsi.chart.renderer.spi.financial.HighLowRenderer;
import de.gsi.chart.renderer.spi.financial.PositionFinancialRendererPaintAfterEP;
import de.gsi.chart.renderer.spi.financial.css.FinancialColorSchemeAware;
import de.gsi.chart.renderer.spi.financial.service.DataSetAware;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEP;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEPAware;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.utils.StreamUtils;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class FinancialColorSchemeConfig
implements FinancialColorSchemeAware {
    protected static final String CSS_STYLESHEET = "de/gsi/chart/financial/%s.css";
    protected static final String CSS_STYLESHEET_CHART = "chart";

    public void applySchemeToDataset(String theme, String customColorScheme, DataSet dataSet, Renderer renderer) {
        if (customColorScheme != null) {
            dataSet.setStyle(customColorScheme);
            return;
        }
        if (renderer instanceof CandleStickRenderer) {
            this.styleDataSetForCandleStickRenderer(theme, dataSet);
        } else if (renderer instanceof HighLowRenderer) {
            this.styleDataSetForHighLowRenderer(theme, dataSet);
        } else if (renderer instanceof FootprintRenderer) {
            this.styleDataSetForFootprintRenderer(theme, dataSet);
        }
        if (renderer instanceof RendererPaintAfterEPAware) {
            for (RendererPaintAfterEP paintAfterEp : ((RendererPaintAfterEPAware)((Object)renderer)).getPaintAfterEps()) {
                if (!(paintAfterEp instanceof DataSetAware)) continue;
                DataSet dataSetEp = ((DataSetAware)((Object)paintAfterEp)).getDataSet();
                if (!(paintAfterEp instanceof PositionFinancialRendererPaintAfterEP)) continue;
                this.styleDataSetForPositionFinancialRenderer(theme, dataSetEp);
            }
        }
    }

    private void styleDataSetForPositionFinancialRenderer(String theme, DataSet dataSetEp) {
        switch (theme) {
            case "CLASSIC": {
                dataSetEp.setStyle("positionTriangleLongColor=blue; positionTriangleShortColor=#a10000; positionTriangleExitColor=black; positionArrowLongColor=blue; positionArrowShortColor=red; positionArrowExitColor=black; positionLabelTradeDescriptionColor=black; positionOrderLinkageProfitColor=blue; positionOrderLinkageLossColor=#a10000");
                break;
            }
            case "CLEARLOOK": {
                dataSetEp.setStyle("positionTriangleLongColor=green; positionTriangleShortColor=red; positionTriangleExitColor=black; positionArrowLongColor=green; positionArrowShortColor=red; positionArrowExitColor=black; positionLabelTradeDescriptionColor=black; positionOrderLinkageProfitColor=green; positionOrderLinkageLossColor=red");
                break;
            }
            case "SAND": {
                dataSetEp.setStyle("positionTriangleLongColor=green; positionTriangleShortColor=red; positionTriangleExitColor=black; positionArrowLongColor=green; positionArrowShortColor=red; positionArrowExitColor=black; positionLabelTradeDescriptionColor=black; positionOrderLinkageProfitColor=green; positionOrderLinkageLossColor=red");
                break;
            }
            case "BLACKBERRY": {
                dataSetEp.setStyle("positionTriangleLongColor=green; positionTriangleShortColor=red; positionTriangleExitColor=white; positionArrowLongColor=green; positionArrowShortColor=red; positionArrowExitColor=white; positionLabelTradeDescriptionColor=white; positionOrderLinkageProfitColor=green; positionOrderLinkageLossColor=red");
                break;
            }
            case "DARK": {
                dataSetEp.setStyle("positionTriangleLongColor=green; positionTriangleShortColor=red; positionTriangleExitColor=white; positionArrowLongColor=green; positionArrowShortColor=red; positionArrowExitColor=white; positionLabelTradeDescriptionColor=white; positionOrderLinkageProfitColor=green; positionOrderLinkageLossColor=red");
                break;
            }
            default: {
                throw new IllegalArgumentException("PositionFinancialRendererPaintAfterEP: Not implemented yet. ColorScheme=" + theme);
            }
        }
    }

    private void styleDataSetForFootprintRenderer(String theme, DataSet dataSet) {
        switch (theme) {
            case "CLASSIC": {
                dataSet.setStyle("footprintLongColor=green; footprintShortColor=red; footprintCrossLineColor=grey; footprintDefaultFontColor=rgba(255,255,255,0.58); footprintPocColor=#d1d100; footprintVolumeLongColor=rgba(139,199,194,0.4); footprintVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "CLEARLOOK": {
                dataSet.setStyle("footprintLongColor=#4c4c4c; footprintShortColor=red; footprintCrossLineColor=grey; footprintDefaultFontColor=rgba(255,255,255,0.58); footprintPocColor=#d1d100; footprintVolumeLongColor=rgba(139,199,194,0.4); footprintVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "SAND": {
                dataSet.setStyle("footprintLongColor=#00aa00; footprintShortColor=red; footprintCrossLineColor=black; footprintDefaultFontColor=rgba(255,255,255,0.58); footprintPocColor=#d1d100; candleShadowColor=rgba(72,72,72,0.2); footprintVolumeLongColor=rgba(139,199,194,0.4); footprintVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "BLACKBERRY": {
                dataSet.setStyle("footprintLongColor=#00022e; footprintShortColor=#780000; footprintCrossLineColor=grey; footprintDefaultFontColor=rgba(255,255,255,0.58); footprintPocColor=yellow; candleLongWickColor=white; candleShortWickColor=red; footprintVolumeLongColor=rgba(139,199,194,0.4); footprintVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "DARK": {
                dataSet.setStyle("footprintLongColor=#298988; footprintShortColor=#963838; footprintCrossLineColor=grey; footprintDefaultFontColor=rgba(255,255,255,0.58); footprintPocColor=yellow; footprintVolumeLongColor=rgba(139,199,194,0.4); footprintVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            default: {
                throw new IllegalArgumentException("FootprintRenderer: Not implemented yet. ColorScheme=" + theme);
            }
        }
    }

    private void styleDataSetForHighLowRenderer(String theme, DataSet dataSet) {
        switch (theme) {
            case "CLASSIC": {
                dataSet.setStyle("highLowBodyLineWidth=1.6; highLowTickLineWidth=2.0; highLowLongColor=green; highLowLongTickColor=green; highLowShortColor=red; highLowShortTickColor=red; highLowVolumeLongColor=rgba(139,199,194,0.4); highLowVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "CLEARLOOK": {
                dataSet.setStyle("highLowBodyLineWidth=1.6; highLowTickLineWidth=2.0; highLowLongColor=black; highLowLongTickColor=black; highLowShortColor=red; highLowShortTickColor=red; highLowVolumeLongColor=rgba(139,199,194,0.4); highLowVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "SAND": {
                dataSet.setStyle("highLowBodyLineWidth=1.2; highLowTickLineWidth=1.2; highLowLongColor=black; highLowLongTickColor=black; highLowShortColor=red; highLowShortTickColor=red; hiLowShadowColor=rgba(72,72,72,0.2); highLowVolumeLongColor=rgba(139,199,194,0.4); highLowVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "BLACKBERRY": {
                dataSet.setStyle("highLowBodyLineWidth=2.0; highLowTickLineWidth=2.5; highLowLongColor=white; highLowLongTickColor=white; highLowShortColor=red; highLowShortTickColor=red; highLowVolumeLongColor=rgba(139,199,194,0.4); highLowVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "DARK": {
                dataSet.setStyle("highLowBodyLineWidth=2.0; highLowTickLineWidth=2.5; highLowLongColor=#89e278; highLowLongTickColor=#89e278; highLowShortColor=#e85656; highLowShortTickColor=#e85656; highLowVolumeLongColor=rgba(139,199,194,0.4); highLowVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            default: {
                throw new IllegalArgumentException("HighLowRenderer: Not implemented yet. ColorScheme=" + theme);
            }
        }
    }

    private void styleDataSetForCandleStickRenderer(String theme, DataSet dataSet) {
        switch (theme) {
            case "CLASSIC": {
                dataSet.setStyle("strokeWidth=1.6; candleLongColor=green; candleShortColor=red; candleLongWickColor=green; candleShortWickColor=red; candleVolumeLongColor=rgba(139,199,194,0.4); candleVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "CLEARLOOK": {
                dataSet.setStyle("strokeWidth=0.9; strokeColor=black; candleLongColor=white; candleShortColor=red; candleVolumeLongColor=rgba(139,199,194,0.4); candleVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "SAND": {
                dataSet.setStyle("strokeWidth=0.9; strokeColor=black; candleLongColor=white; candleShortColor=red; candleShadowColor=rgba(72,72,72,0.2); candleVolumeLongColor=rgba(139,199,194,0.4); candleVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "BLACKBERRY": {
                dataSet.setStyle("strokeWidth=1.5; strokeColor=black; candleLongColor=#00022e; candleShortColor=#780000; candleLongWickColor=white; candleShortWickColor=red; candleVolumeLongColor=rgba(139,199,194,0.4); candleVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            case "DARK": {
                dataSet.setStyle("strokeWidth=1.5; strokeColor=black; candleLongColor=#298988; candleShortColor=#963838; candleLongWickColor=#89e278; candleShortWickColor=#e85656; candleVolumeLongColor=rgba(139,199,194,0.4); candleVolumeShortColor=rgba(235,160,159,0.4)");
                break;
            }
            default: {
                throw new IllegalArgumentException("CandleStickRenderer: Not implemented yet. ColorScheme=" + theme);
            }
        }
    }

    @Override
    public void applyTo(String theme, String customColorScheme, XYChart chart) throws Exception {
        for (DataSet dataset : chart.getDatasets()) {
            for (Renderer renderer : chart.getRenderers()) {
                this.applySchemeToDataset(theme, customColorScheme, dataset, renderer);
            }
        }
        for (Renderer renderer : chart.getRenderers()) {
            for (DataSet dataset : renderer.getDatasets()) {
                this.applySchemeToDataset(theme, customColorScheme, dataset, renderer);
            }
        }
        String cssStyleSheet = String.format(CSS_STYLESHEET, "chart-" + theme.toLowerCase(Locale.ROOT));
        if (this.getClass().getClassLoader().getResource(cssStyleSheet) == null) {
            cssStyleSheet = String.format(CSS_STYLESHEET, CSS_STYLESHEET_CHART);
        }
        chart.getStylesheets().add((Object)cssStyleSheet);
        switch (theme) {
            case "CLEARLOOK": 
            case "CLASSIC": {
                break;
            }
            case "SAND": {
                chart.getPlotBackground().setBackground(new Background(new BackgroundImage[]{new BackgroundImage(new Image(StreamUtils.getInputStream((String)"classpath:de/gsi/chart/images/sand.png")), BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT, BackgroundPosition.DEFAULT, BackgroundSize.DEFAULT)}));
                chart.getGridRenderer().getVerticalMinorGrid().setVisible(true);
                chart.getGridRenderer().getVerticalMajorGrid().setVisible(true);
                chart.getGridRenderer().getHorizontalMajorGrid().setVisible(true);
                chart.getGridRenderer().getHorizontalMajorGrid().setVisible(true);
                chart.getGridRenderer().getHorizontalMajorGrid().setStroke((Paint)Color.DARKGREY);
                chart.getGridRenderer().getVerticalMajorGrid().setStroke((Paint)Color.DARKGREY);
                if (chart.getXAxis() instanceof AbstractAxisParameter) {
                    ((AbstractAxisParameter)chart.getXAxis()).setTickLabelFill((Paint)Color.BLACK);
                }
                if (!(chart.getYAxis() instanceof AbstractAxisParameter)) break;
                ((AbstractAxisParameter)chart.getYAxis()).setTickLabelFill((Paint)Color.BLACK);
                break;
            }
            case "BLACKBERRY": {
                chart.getPlotBackground().setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)0, (int)2, (int)46), CornerRadii.EMPTY, Insets.EMPTY)}));
                chart.getGridRenderer().getVerticalMinorGrid().setVisible(false);
                chart.getGridRenderer().getVerticalMajorGrid().setVisible(false);
                chart.getGridRenderer().getHorizontalMajorGrid().setVisible(false);
                chart.getGridRenderer().getHorizontalMajorGrid().setVisible(false);
                chart.setTitlePaint((Paint)Color.WHITE);
                if (chart.getXAxis() instanceof AbstractAxisParameter) {
                    ((AbstractAxisParameter)chart.getXAxis()).setTickLabelFill((Paint)Color.WHITESMOKE);
                }
                if (!(chart.getYAxis() instanceof AbstractAxisParameter)) break;
                ((AbstractAxisParameter)chart.getYAxis()).setTickLabelFill((Paint)Color.WHITESMOKE);
                break;
            }
            case "DARK": {
                chart.getPlotBackground().setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)47, (int)47, (int)47), CornerRadii.EMPTY, Insets.EMPTY)}));
                chart.getGridRenderer().getVerticalMinorGrid().setVisible(false);
                chart.getGridRenderer().getVerticalMajorGrid().setVisible(false);
                chart.getGridRenderer().getHorizontalMajorGrid().setVisible(true);
                chart.getGridRenderer().getHorizontalMinorGrid().setVisible(false);
                chart.getGridRenderer().getHorizontalMajorGrid().setStroke((Paint)Color.rgb((int)106, (int)106, (int)106));
                chart.setTitlePaint((Paint)Color.WHITE);
                if (chart.getXAxis() instanceof AbstractAxisParameter) {
                    ((AbstractAxisParameter)chart.getXAxis()).setTickLabelFill((Paint)Color.rgb((int)194, (int)194, (int)194));
                }
                if (!(chart.getYAxis() instanceof AbstractAxisParameter)) break;
                ((AbstractAxisParameter)chart.getYAxis()).setTickLabelFill((Paint)Color.rgb((int)194, (int)194, (int)194));
            }
        }
    }

    @Override
    public void applyTo(String theme, XYChart chart) throws Exception {
        this.applyTo(theme, null, chart);
    }

    public void applySchemeToDataset(String theme, DataSet dataSet, Renderer renderer) {
        this.applySchemeToDataset(theme, null, dataSet, renderer);
    }
}

