/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.hexagon;

import de.gsi.chart.renderer.spi.hexagon.Hexagon;
import de.gsi.chart.renderer.spi.hexagon.HexagonMap;
import de.gsi.chart.renderer.spi.hexagon.IHexagonCreator;
import java.util.Optional;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.paint.Color;

class MapGenerator {
    private final HexagonMap map;
    private final Image image;
    private final int mapWidth;
    private Double verticalRelation;
    private Double horizontalRelation;

    public MapGenerator(HexagonMap map, Image image, int mapWidthInHexes) {
        this.map = map;
        this.image = image;
        this.mapWidth = mapWidthInHexes;
    }

    public void generate(IHexagonCreator creator) {
        PixelReader pr = this.image.getPixelReader();
        if (pr == null) {
            return;
        }
        double imageWidth = this.image.getWidth();
        double imageHeight = this.image.getHeight();
        double hexagonMapWidthInPixels = this.map.getGraphicsHorizontalDistanceBetweenHexagons() * (double)this.mapWidth;
        this.horizontalRelation = imageWidth / hexagonMapWidthInPixels;
        double estimatedHexagonMapHeightInPixels = imageHeight / this.horizontalRelation;
        int mapHeight = (int)(estimatedHexagonMapHeightInPixels / this.map.getGraphicsverticalDistanceBetweenHexagons());
        this.verticalRelation = imageHeight / (this.map.getGraphicsverticalDistanceBetweenHexagons() * (double)mapHeight + (double)(this.map.getGraphicsHexagonHeight() / 2));
        for (int x = 0; x < this.mapWidth; ++x) {
            int y = 0;
            while (y < mapHeight) {
                int axialQ = x - (y - (y & 1)) / 2;
                int axialR = y++;
                Hexagon h = new Hexagon(axialQ, axialR);
                h.setMap(this.map);
                int xOnImage = (int)((double)(h.getGraphicsXoffset() - this.map.graphicsXpadding) * this.horizontalRelation);
                int yOnImage = (int)((double)(h.getGraphicsYoffset() - this.map.graphicsYpadding) * this.verticalRelation);
                Color pixelColor = pr.getColor(xOnImage, yOnImage);
                creator.createHexagon(axialQ, axialR, pixelColor, this.map);
            }
        }
    }

    public Optional<Double> getHorizontalRelation() {
        return this.horizontalRelation == null ? Optional.empty() : Optional.of(this.horizontalRelation);
    }

    public Optional<Double> getVerticalRelation() {
        return this.verticalRelation == null ? Optional.empty() : Optional.of(this.verticalRelation);
    }
}

