/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.marchingsquares;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.canvas.GraphicsContext;

public class GeneralPath {
    private final List<Segment> drawList = new ArrayList<Segment>();

    GeneralPath() {
        this.beginPath();
    }

    public final void beginPath() {
        this.drawList.add(new Segment(PathType.GC_BEGINPATH, 0.0, 0.0));
    }

    public void closePath() {
        this.drawList.add(new Segment(PathType.GC_CLOSEPATH, 0.0, 0.0));
    }

    public int draw(GraphicsContext gc) {
        int count = 0;
        for (Segment segment : this.drawList) {
            switch (segment.type) {
                case GC_LINETO: {
                    gc.lineTo(segment.x, segment.y);
                    ++count;
                    break;
                }
                case GC_MOVETO: {
                    gc.moveTo(segment.x, segment.y);
                    ++count;
                    break;
                }
                case GC_BEGINPATH: {
                    gc.beginPath();
                    break;
                }
                case GC_CLOSEPATH: {
                    gc.closePath();
                    gc.stroke();
                    break;
                }
            }
        }
        return count;
    }

    public void lineTo(float x, float y) {
        this.drawList.add(new Segment(PathType.GC_LINETO, x, y));
    }

    public void moveTo(float x, float y) {
        this.drawList.add(new Segment(PathType.GC_MOVETO, x, y));
    }

    public int size() {
        return this.drawList.size();
    }

    private static class Segment {
        public double x;
        public double y;
        public PathType type;

        Segment(PathType type, double x, double y) {
            this.type = type;
            this.x = x;
            this.y = y;
        }
    }

    static enum PathType {
        GC_LINETO,
        GC_MOVETO,
        GC_BEGINPATH,
        GC_CLOSEPATH;

    }
}

