/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;

public final class DashPatternStyle {
    private static final WeakHashMap<Integer, ImagePattern> dashHashMap = new WeakHashMap();

    private DashPatternStyle() {
    }

    private static Integer computeHash(Paint color, double strokeWidth, boolean isHorizontal, double[] pattern) {
        int hash = 7;
        hash = 31 * hash + color.hashCode();
        hash = 31 * hash + Double.hashCode(strokeWidth);
        hash = 31 * hash + Boolean.hashCode(isHorizontal);
        hash = pattern == null ? 31 * hash + 3141 : 31 * hash + Arrays.hashCode(pattern);
        return hash;
    }

    private static ImagePattern createDefaultHatch(Paint color, double strokeWidth, boolean isHorizontal, double[] pattern) {
        Integer hash = DashPatternStyle.computeHash(color, strokeWidth, isHorizontal, pattern);
        return dashHashMap.computeIfAbsent(hash, t -> {
            double dashPatternLength = DashPatternStyle.getPatternLength(pattern);
            double width = isHorizontal ? dashPatternLength : strokeWidth;
            double height = isHorizontal ? strokeWidth : dashPatternLength;
            double middle = (int)(strokeWidth / 2.0);
            Pane pane = new Pane();
            pane.setPrefSize(width, height);
            Line fw = isHorizontal ? new Line(0.0, middle, dashPatternLength, middle) : new Line(middle, 0.0, middle, dashPatternLength);
            fw.setSmooth(false);
            fw.setStroke(color);
            if (pattern == null) {
                fw.getStrokeDashArray().setAll((Object[])new Double[]{dashPatternLength});
            } else {
                fw.getStrokeDashArray().setAll((Collection)DoubleStream.of(pattern).boxed().collect(Collectors.toList()));
            }
            fw.setStrokeWidth(strokeWidth);
            pane.getChildren().addAll((Object[])new Node[]{fw});
            pane.setStyle("-fx-background-color: rgba(0, 0, 0, 0.0)");
            Scene scene = new Scene((Parent)pane);
            scene.setFill((Paint)Color.TRANSPARENT);
            WritableImage hatch = pane.snapshot(null, null);
            return new ImagePattern((Image)hatch, width, 0.0, width, height, false);
        });
    }

    private static double getPatternLength(double[] pattern) {
        if (pattern == null || pattern.length <= 1) {
            return 1.0;
        }
        double ret = 0.0;
        for (int i = 0; i < pattern.length; ++i) {
            ret += pattern[i];
        }
        return ret;
    }

    public static void strokeDashedLine(GraphicsContext gc, double x0, double y0, double x1, double y1) {
        double height;
        Paint color = gc.getStroke();
        double strokeWidth = Math.max(gc.getLineWidth(), 1.0);
        double strokeWidthHalf = strokeWidth / 2.0;
        double[] pattern = gc.getLineDashes();
        double width = Math.abs(x1 - x0);
        boolean isHorizontal = width > (height = Math.abs(y1 - y0));
        gc.setFill((Paint)DashPatternStyle.createDefaultHatch(color, strokeWidth, isHorizontal, pattern));
        if (isHorizontal) {
            gc.fillRect(x0, y0 - strokeWidthHalf, width, strokeWidth);
        } else {
            gc.fillRect(x0 - strokeWidthHalf, y0, strokeWidth, height);
        }
    }
}

