/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.ui;

import de.gsi.chart.ui.HiddenSidesPane;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class HiddenSidesPaneSkin
extends SkinBase<HiddenSidesPane> {
    private final StackPane stackPane;
    private final EventHandler<MouseEvent> exitedHandler;
    private boolean mousePressed;
    private final DoubleProperty[] visibility = new SimpleDoubleProperty[Side.values().length];
    private Timeline showTimeline;
    private Timeline hideTimeline;
    private Node lastHideBlockingNode = null;
    private long blockedSince = 0L;

    public HiddenSidesPaneSkin(HiddenSidesPane pane) {
        super((Control)pane);
        this.exitedHandler = event -> {
            if (this.isMouseEnabled() && ((HiddenSidesPane)this.getSkinnable()).getPinnedSide() == null && !this.mousePressed) {
                this.hide();
            }
        };
        this.stackPane = new StackPane();
        this.stackPane.setId("HiddenSidesPaneSkin::StackPane");
        this.getChildren().add((Object)this.stackPane);
        this.updateStackPane();
        InvalidationListener rebuildListener = observable -> this.updateStackPane();
        pane.contentProperty().addListener(rebuildListener);
        pane.topProperty().addListener(rebuildListener);
        pane.rightProperty().addListener(rebuildListener);
        pane.bottomProperty().addListener(rebuildListener);
        pane.leftProperty().addListener(rebuildListener);
        pane.addEventFilter(MouseEvent.MOUSE_MOVED, event -> {
            if (this.isMouseEnabled() && ((HiddenSidesPane)this.getSkinnable()).getPinnedSide() == null) {
                Side side = this.getSide((MouseEvent)event);
                if (side == null) {
                    if (this.isMouseMovedOutsideSides((MouseEvent)event)) {
                        this.hide();
                    }
                } else {
                    this.show(side);
                }
            }
        });
        pane.addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        pane.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            this.mousePressed = true;
        });
        pane.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
            this.mousePressed = false;
            if (this.isMouseEnabled() && ((HiddenSidesPane)this.getSkinnable()).getPinnedSide() == null) {
                Side side = this.getSide((MouseEvent)event);
                if (side == null) {
                    this.hide();
                } else {
                    this.show(side);
                }
            }
        });
        for (Side side : Side.values()) {
            this.visibility[side.ordinal()] = new SimpleDoubleProperty(0.0);
            this.visibility[side.ordinal()].addListener(observable -> ((HiddenSidesPane)this.getSkinnable()).requestLayout());
        }
        Side pinnedSide = ((HiddenSidesPane)this.getSkinnable()).getPinnedSide();
        if (pinnedSide != null) {
            this.show(pinnedSide);
        }
        pane.pinnedSideProperty().addListener(observable -> this.show(((HiddenSidesPane)this.getSkinnable()).getPinnedSide()));
        Rectangle clip = new Rectangle();
        clip.setX(0.0);
        clip.setY(0.0);
        clip.widthProperty().bind((ObservableValue)((HiddenSidesPane)this.getSkinnable()).widthProperty());
        clip.heightProperty().bind((ObservableValue)((HiddenSidesPane)this.getSkinnable()).heightProperty());
        ((HiddenSidesPane)this.getSkinnable()).setClip((Node)clip);
    }

    private double getPrefAlignmentH(Node node, double contentWidth) {
        Pos alignment = StackPane.getAlignment((Node)node);
        if (alignment == null) {
            return 0.0;
        }
        switch (alignment.getHpos()) {
            case RIGHT: {
                return contentWidth - node.getLayoutBounds().getWidth();
            }
            case CENTER: {
                return 0.5 * (contentWidth - node.getLayoutBounds().getWidth());
            }
        }
        return 0.0;
    }

    private double getPrefAlignmentV(Node node, double contentHeight) {
        Pos alignment = StackPane.getAlignment((Node)node);
        if (alignment == null) {
            return 0.0;
        }
        switch (alignment.getVpos()) {
            case BOTTOM: {
                return contentHeight - node.getLayoutBounds().getHeight();
            }
            case CENTER: {
                return 0.5 * (contentHeight - node.getLayoutBounds().getHeight());
            }
        }
        return 0.0;
    }

    private Side getSide(MouseEvent evt) {
        if (this.stackPane.getBoundsInLocal().contains(evt.getX(), evt.getY())) {
            double trigger = ((HiddenSidesPane)this.getSkinnable()).getTriggerDistance();
            if (evt.getX() <= trigger && ((HiddenSidesPane)this.getSkinnable()).getLeft() != null) {
                return Side.LEFT;
            }
            if (evt.getX() > ((HiddenSidesPane)this.getSkinnable()).getWidth() - trigger && ((HiddenSidesPane)this.getSkinnable()).getRight() != null) {
                return Side.RIGHT;
            }
            if (evt.getY() <= trigger && ((HiddenSidesPane)this.getSkinnable()).getTop() != null) {
                return Side.TOP;
            }
            if (evt.getY() > ((HiddenSidesPane)this.getSkinnable()).getHeight() - trigger && ((HiddenSidesPane)this.getSkinnable()).getBottom() != null) {
                return Side.BOTTOM;
            }
        }
        return null;
    }

    private boolean hasShowingChild(Node n) {
        if (n == null) {
            return false;
        }
        if (n.isHover()) {
            this.lastHideBlockingNode = n;
            return true;
        }
        try {
            Method showingMethod = HiddenSidesPaneSkin.getMethod(n.getClass(), "isShowing");
            if (showingMethod != null && ((Boolean)showingMethod.invoke((Object)n, new Object[0])).booleanValue()) {
                this.lastHideBlockingNode = n;
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        if (n instanceof Parent) {
            return ((Parent)n).getChildrenUnmodifiable().stream().anyMatch(this::hasShowingChild);
        }
        return false;
    }

    private void hide() {
        Method closeMethod;
        if (this.showTimeline != null) {
            this.showTimeline.stop();
        }
        if (this.hideTimeline != null && this.hideTimeline.getStatus() == Animation.Status.RUNNING) {
            return;
        }
        Side visibleSide = null;
        for (Side side : Side.values()) {
            if (!(this.visibility[side.ordinal()].get() > 0.0)) continue;
            visibleSide = side;
            break;
        }
        if (visibleSide == null) {
            return;
        }
        if (this.hasShowingChild(this.lastHideBlockingNode) || this.hasShowingChild(this.getSidePane(visibleSide))) {
            long now = System.currentTimeMillis();
            if (this.blockedSince == 0L) {
                this.blockedSince = now;
            }
            if ((double)(now - this.blockedSince) < ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay().toMillis()) {
                return;
            }
        }
        this.blockedSince = 0L;
        if (this.hasShowingChild(this.lastHideBlockingNode) && (closeMethod = HiddenSidesPaneSkin.getMethod(this.lastHideBlockingNode.getClass(), "hide")) != null) {
            try {
                closeMethod.invoke((Object)this.lastHideBlockingNode, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        KeyValue[] keyValues = new KeyValue[Side.values().length];
        for (Side side : Side.values()) {
            keyValues[side.ordinal()] = new KeyValue((WritableValue)this.visibility[side.ordinal()], (Object)0);
        }
        Duration delay = ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay() == null ? Duration.millis((double)300.0) : ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay();
        Duration duration = ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration() == null ? Duration.millis((double)300.0) : ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration();
        KeyFrame keyFrame = new KeyFrame(duration, keyValues);
        this.hideTimeline = new Timeline(new KeyFrame[]{keyFrame});
        this.hideTimeline.setDelay(delay);
        this.hideTimeline.play();
    }

    private boolean isMouseEnabled() {
        return ((HiddenSidesPane)this.getSkinnable()).getTriggerDistance() > 0.0;
    }

    private boolean isMouseMovedOutsideSides(MouseEvent event) {
        return !(((HiddenSidesPane)this.getSkinnable()).getLeft() != null && ((HiddenSidesPane)this.getSkinnable()).getLeft().getBoundsInParent().contains(event.getX(), event.getY()) || ((HiddenSidesPane)this.getSkinnable()).getTop() != null && ((HiddenSidesPane)this.getSkinnable()).getTop().getBoundsInParent().contains(event.getX(), event.getY()) || ((HiddenSidesPane)this.getSkinnable()).getRight() != null && ((HiddenSidesPane)this.getSkinnable()).getRight().getBoundsInParent().contains(event.getX(), event.getY()) || ((HiddenSidesPane)this.getSkinnable()).getBottom() != null && ((HiddenSidesPane)this.getSkinnable()).getBottom().getBoundsInParent().contains(event.getX(), event.getY()));
    }

    private void show(Side side) {
        if (this.hideTimeline != null) {
            this.hideTimeline.stop();
        }
        if (this.showTimeline != null && this.showTimeline.getStatus() == Animation.Status.RUNNING) {
            return;
        }
        KeyValue[] keyValues = new KeyValue[Side.values().length];
        for (Side s : Side.values()) {
            keyValues[s.ordinal()] = new KeyValue((WritableValue)this.visibility[s.ordinal()], (Object)(s.equals((Object)side) ? 1 : 0));
        }
        Duration delay = ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay() == null ? Duration.millis((double)300.0) : ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay();
        Duration duration = ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration() == null ? Duration.millis((double)200.0) : ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration();
        KeyFrame keyFrame = new KeyFrame(duration, keyValues);
        this.showTimeline = new Timeline(new KeyFrame[]{keyFrame});
        this.showTimeline.setDelay(delay);
        this.showTimeline.play();
    }

    private void updateStackPane() {
        this.stackPane.getChildren().clear();
        if (((HiddenSidesPane)this.getSkinnable()).getContent() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getContent());
        }
        if (((HiddenSidesPane)this.getSkinnable()).getTop() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getTop());
            ((HiddenSidesPane)this.getSkinnable()).getTop().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getTop().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getTop().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((HiddenSidesPane)this.getSkinnable()).getRight() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getRight());
            ((HiddenSidesPane)this.getSkinnable()).getRight().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getRight().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getRight().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((HiddenSidesPane)this.getSkinnable()).getBottom() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getBottom());
            ((HiddenSidesPane)this.getSkinnable()).getBottom().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getBottom().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getBottom().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((HiddenSidesPane)this.getSkinnable()).getLeft() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getLeft());
            ((HiddenSidesPane)this.getSkinnable()).getLeft().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getLeft().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getLeft().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
    }

    protected Node getSidePane(Side side) {
        if (this.getSkinnable() == null) {
            return null;
        }
        switch (side) {
            case BOTTOM: {
                return ((HiddenSidesPane)this.getSkinnable()).getBottom();
            }
            case LEFT: {
                return ((HiddenSidesPane)this.getSkinnable()).getLeft();
            }
            case RIGHT: {
                return ((HiddenSidesPane)this.getSkinnable()).getRight();
            }
            case TOP: {
                return ((HiddenSidesPane)this.getSkinnable()).getTop();
            }
        }
        return null;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        Node top;
        Node right;
        Node left;
        Node bottom;
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        if (((HiddenSidesPane)this.getSkinnable()).getContent() != null) {
            ((HiddenSidesPane)this.getSkinnable()).getContent().resizeRelocate(contentX, contentY, contentWidth, contentHeight);
        }
        if ((bottom = ((HiddenSidesPane)this.getSkinnable()).getBottom()) != null) {
            double prefHeight = bottom.prefHeight(-1.0);
            double offset = prefHeight * this.visibility[Side.BOTTOM.ordinal()].get();
            double offsetX = this.getPrefAlignmentH(bottom, contentWidth);
            bottom.resizeRelocate(contentX + offsetX, contentY + contentHeight - offset, contentWidth, prefHeight);
            bottom.setVisible(this.visibility[Side.BOTTOM.ordinal()].get() > 0.0);
        }
        if ((left = ((HiddenSidesPane)this.getSkinnable()).getLeft()) != null) {
            double prefWidth = left.prefWidth(-1.0);
            double offset = prefWidth * this.visibility[Side.LEFT.ordinal()].get();
            double offsetY = this.getPrefAlignmentV(left, contentHeight);
            left.resizeRelocate(contentX - (prefWidth - offset), contentY + offsetY, prefWidth, contentHeight);
            left.setVisible(this.visibility[Side.LEFT.ordinal()].get() > 0.0);
        }
        if ((right = ((HiddenSidesPane)this.getSkinnable()).getRight()) != null) {
            double prefWidth = right.prefWidth(-1.0);
            double offset = prefWidth * this.visibility[Side.RIGHT.ordinal()].get();
            double offsetY = this.getPrefAlignmentV(right, contentHeight);
            right.resizeRelocate(contentX + contentWidth - offset, contentY + offsetY, prefWidth, contentHeight);
            right.setVisible(this.visibility[Side.RIGHT.ordinal()].get() > 0.0);
        }
        if ((top = ((HiddenSidesPane)this.getSkinnable()).getTop()) != null) {
            double prefHeight = top.prefHeight(-1.0);
            double offset = prefHeight * this.visibility[Side.TOP.ordinal()].get();
            double offsetX = this.getPrefAlignmentH(top, contentWidth);
            top.resizeRelocate(contentX + offsetX, contentY - (prefHeight - offset), contentWidth, prefHeight);
            top.setVisible(this.visibility[Side.TOP.ordinal()].get() > 0.0);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        try {
            return clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }
}

