/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.ui;

import de.gsi.chart.utils.SimplePerformanceMeter;
import impl.org.controlsfx.skin.BreadCrumbBarSkin;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.controlsfx.control.BreadCrumbBar;
import org.kordamp.ikonli.javafx.FontIcon;

public class ProfilerInfoBox
extends BreadCrumbBar<VBox> {
    private static final int DEFAULT_DEBUG_UPDATE_RATE = 100;
    private static final double LEVEL_WARNING = 50.0;
    private static final double LEVEL_ERROR = 30.0;
    private static final String FONT_MONO_SPACE = "Monospaced";
    private static final String FONT_AWESOME = "FontAwesome";
    private static final int FONT_SIZE = 9;
    private final FontIcon chevronIcon = new FontIcon("fa-thermometer-quarter:18");
    private final ObjectProperty<DebugLevel> debugLevel = new SimpleObjectProperty((Object)this, "debugLevel", (Object)DebugLevel.NONE);
    private final TreeItem<VBox> treeRoot;
    private SimplePerformanceMeter meter;

    public ProfilerInfoBox() {
        this(null, 100);
    }

    public ProfilerInfoBox(int updateRateMillis) {
        this(null, updateRateMillis);
    }

    public ProfilerInfoBox(Scene scene) {
        this(scene, 100);
    }

    public ProfilerInfoBox(Scene scene, int updateRateMillis) {
        this.setCrumbFactory(param -> new CustomBreadCrumbButton((Node)param.getValue()));
        this.setAutoNavigationEnabled(false);
        Label chevron = new Label(null, (Node)this.chevronIcon);
        chevron.setPadding(new Insets(3.0, 0.0, 4.0, 0.0));
        VBox.setVgrow((Node)chevron, (Priority)Priority.ALWAYS);
        CustomLabel fxFPS = new CustomLabel();
        fxFPS.setTooltip(new Tooltip("internal JavaFX tick frame-rate (aka. pulse, usually around 60 FPS)"));
        CustomLabel chartFPS = new CustomLabel();
        chartFPS.setTooltip(new Tooltip("(visible) frame update (usually <= 25 FPS"));
        CustomLabel cpuLoadProcess = new CustomLabel();
        cpuLoadProcess.setTooltip(new Tooltip("CPU load of this process"));
        CustomLabel cpuLoadSystem = new CustomLabel();
        cpuLoadProcess.setTooltip(new Tooltip("CPU system load (100% <-> 1 core fully loaded)"));
        ChangeListener updateLabelListener = (ch, o, n) -> {
            String fxRate = String.format("%4.1f", this.meter.getFxFrameRate());
            String actualRate = String.format("%4.1f", this.meter.getActualFrameRate());
            String cpuProcess = String.format("%5.1f", this.meter.getProcessCpuLoad());
            String cpuSystem = String.format("%5.1f", this.meter.getSystemCpuLoad());
            if (this.meter.getFxFrameRate() < 30.0) {
                this.chevronIcon.setFill((Paint)Color.RED);
            } else if (this.meter.getFxFrameRate() < 50.0) {
                this.chevronIcon.setFill((Paint)Color.DARKORANGE);
            } else {
                this.chevronIcon.setFill((Paint)Color.BLACK);
            }
            fxFPS.setTextFiltered(String.format("%6s: %4s %s", "FX", fxRate, "FPS"));
            chartFPS.setTextFiltered(String.format("%6s: %4s %s", "actual", actualRate, "FPS"));
            cpuLoadProcess.setTextFiltered(String.format("%7s: %4s %s", "Process", cpuProcess, "%"));
            cpuLoadSystem.setTextFiltered(String.format("%7s: %4s %s", "System", cpuSystem, "%"));
        };
        CustomLabel javaVersion = new CustomLabel(System.getProperty("java.vm.name") + " " + System.getProperty("java.version"));
        CustomLabel javafxVersion = new CustomLabel("JavaFX: " + System.getProperty("javafx.runtime.version"));
        if (scene == null) {
            this.sceneProperty().addListener((ch, oldScene, newScene) -> {
                if (oldScene != null) {
                    this.meter.fxFrameRateProperty().removeListener(updateLabelListener);
                }
                if (newScene != null) {
                    this.meter = new SimplePerformanceMeter((Scene)newScene, updateRateMillis);
                    this.meter.fxFrameRateProperty().addListener(updateLabelListener);
                }
            });
        } else {
            this.meter = new SimplePerformanceMeter(scene, updateRateMillis);
            this.meter.fxFrameRateProperty().addListener(updateLabelListener);
        }
        this.treeRoot = new TreeItem((Object)new VBox(new Node[]{chevron}));
        ((VBox)this.treeRoot.getValue()).setId("ProfilerInfoBox-treeRoot");
        TreeItem fpsItem = new TreeItem((Object)new VBox(new Node[]{fxFPS, chartFPS}));
        ((VBox)fpsItem.getValue()).setId("ProfilerInfoBox-fpsItem");
        TreeItem cpuItem = new TreeItem((Object)new VBox(new Node[]{cpuLoadProcess, cpuLoadSystem}));
        ((VBox)cpuItem.getValue()).setId("ProfilerInfoBox-cpuItem");
        TreeItem versionItem = new TreeItem((Object)new VBox(new Node[]{javaVersion, javafxVersion}));
        ((VBox)versionItem.getValue()).setId("ProfilerInfoBox-versionItem");
        this.treeRoot.getChildren().add((Object)fpsItem);
        fpsItem.getChildren().add((Object)cpuItem);
        cpuItem.getChildren().add((Object)versionItem);
        this.setOnCrumbAction(this.updateSelectedCrumbActionListener());
        this.debugLevelProperty().addListener(this.updateSelectedCrumbLevelListener((TreeItem<VBox>)fpsItem, (TreeItem<VBox>)cpuItem, (TreeItem<VBox>)versionItem));
        this.setSelectedCrumb(this.treeRoot);
    }

    public ObjectProperty<DebugLevel> debugLevelProperty() {
        return this.debugLevel;
    }

    public DebugLevel getDebugLevel() {
        return (DebugLevel)((Object)this.debugLevelProperty().get());
    }

    public TreeItem<VBox> getTreeRoot() {
        return this.treeRoot;
    }

    public ProfilerInfoBox setDebugLevel(DebugLevel level) {
        this.debugLevelProperty().set((Object)level);
        return this;
    }

    private EventHandler<BreadCrumbBar.BreadCrumbActionEvent<VBox>> updateSelectedCrumbActionListener() {
        return bae -> {
            if (bae.getSelectedCrumb().equals(this.getSelectedCrumb()) && !bae.getSelectedCrumb().getChildren().isEmpty()) {
                this.setSelectedCrumb((TreeItem)bae.getSelectedCrumb().getChildren().get(0));
            } else {
                this.setSelectedCrumb(bae.getSelectedCrumb());
            }
        };
    }

    private ChangeListener<? super DebugLevel> updateSelectedCrumbLevelListener(TreeItem<VBox> fpsItem, TreeItem<VBox> cpuItem, TreeItem<VBox> versionItem) {
        return (ch, o, n) -> {
            switch (this.getDebugLevel()) {
                case FRAMES_PER_SECOND: {
                    this.setSelectedCrumb(fpsItem);
                    break;
                }
                case CPU_LOAD: {
                    this.setSelectedCrumb(cpuItem);
                    break;
                }
                case VERSION: {
                    this.setSelectedCrumb(versionItem);
                    break;
                }
                default: {
                    this.setSelectedCrumb(this.treeRoot);
                }
            }
        };
    }

    protected static class CustomLabel
    extends Label {
        public CustomLabel() {
            this(null);
        }

        public CustomLabel(String text) {
            super(text);
            this.setPadding(Insets.EMPTY);
            this.setFont(Font.font((String)ProfilerInfoBox.FONT_MONO_SPACE, (double)9.0));
        }

        public void setTextFiltered(String text) {
            if (this.getText() != null && this.getText().equals(text)) {
                return;
            }
            super.setText(text);
        }
    }

    protected static class CustomBreadCrumbButton
    extends BreadCrumbBarSkin.BreadCrumbButton {
        public CustomBreadCrumbButton(Node gfx) {
            super(null, gfx);
            this.setId(gfx.getId());
            this.setPadding(new Insets(0.0, this.getArrowWidth(), 0.0, this.getArrowWidth()));
        }
    }

    public static enum DebugLevel {
        NONE,
        FRAMES_PER_SECOND,
        CPU_LOAD,
        VERSION;

    }
}

