/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.ui.css;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.BinaryOperator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import javafx.beans.property.Property;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableFloatProperty;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.SimpleStyleableLongProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.SimpleStyleableStringProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableFloatProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableLongProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.scene.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssPropertyFactory<S extends Styleable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CssPropertyFactory.class);
    protected final List<CssMetaData<? extends Styleable, ?>> metaData;
    protected final List<CssMetaData<? extends Styleable, ?>> unmodifiableList;
    protected final Map<String, CssMetaData<S, ?>> metaDataSet = new HashMap();
    protected final Map<String, PseudoClass> pseudoClasses = new HashMap<String, PseudoClass>();
    protected final Map<Styleable, List<String>> propertyNames = new WeakHashMap<Styleable, List<String>>();

    public CssPropertyFactory() {
        this(null);
    }

    public CssPropertyFactory(List<CssMetaData<? extends Styleable, ?>> parentCss) {
        this.metaData = parentCss != null ? new ArrayList(parentCss) : new ArrayList();
        this.unmodifiableList = Collections.unmodifiableList(this.metaData);
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> clazz) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            CssPropertyFactory.getAllFields(fields, clazz.getSuperclass());
        }
        return fields;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        List<Field> fields = CssPropertyFactory.getAllFields(new LinkedList<Field>(), clazz);
        Optional<Field> field = fields.stream().filter(f -> f.getName().equals(fieldName)).findFirst();
        field.ifPresent(f -> f.setAccessible(true));
        return field.orElse(null);
    }

    public final List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return this.unmodifiableList;
    }

    public final List<CssMetaData<? extends Styleable, ?>> getCssMetaDataModifyable() {
        return this.metaData;
    }

    public final StyleableDoubleProperty createDoubleProperty(S styleableBean, String propertyName, double initialValue, boolean inherits, DoubleBinaryOperator filter, Runnable ... invalidateActions) {
        return new StylishDoubleProperty((Styleable)styleableBean, propertyName, initialValue, inherits, filter, invalidateActions);
    }

    public final StyleableDoubleProperty createDoubleProperty(S styleableBean, String propertyName, double initialValue, Runnable ... invalidateActions) {
        return this.createDoubleProperty(styleableBean, propertyName, initialValue, true, null, invalidateActions);
    }

    public final StyleableIntegerProperty createIntegerProperty(S styleableBean, String propertyName, int initialValue, boolean inherits, IntBinaryOperator filter, Runnable ... invalidateActions) {
        return new StylishIntegerProperty((Styleable)styleableBean, propertyName, initialValue, inherits, filter, invalidateActions);
    }

    public final StyleableIntegerProperty createIntegerProperty(S styleableBean, String propertyName, int initialValue, Runnable ... invalidateActions) {
        return this.createIntegerProperty(styleableBean, propertyName, initialValue, true, null, invalidateActions);
    }

    public final StyleableLongProperty createLongProperty(S styleableBean, String propertyName, long initialValue, boolean inherits, LongBinaryOperator filter, Runnable ... invalidateActions) {
        return new StylishLongProperty((Styleable)styleableBean, propertyName, initialValue, inherits, filter, invalidateActions);
    }

    public final StyleableLongProperty createLongProperty(S styleableBean, String propertyName, long initialValue, Runnable ... invalidateActions) {
        return this.createLongProperty(styleableBean, propertyName, initialValue, true, null, invalidateActions);
    }

    public final StyleableFloatProperty createFloatProperty(S styleableBean, String propertyName, float initialValue, boolean inherits, BinaryOperator<Float> filter, Runnable ... invalidateActions) {
        return new StylishFloatProperty((Styleable)styleableBean, propertyName, initialValue, inherits, filter, invalidateActions);
    }

    public final StyleableFloatProperty createFloatProperty(S styleableBean, String propertyName, float initialValue, Runnable ... invalidateActions) {
        return this.createFloatProperty(styleableBean, propertyName, initialValue, true, null, invalidateActions);
    }

    public final StyleableBooleanProperty createBooleanProperty(S styleableBean, String propertyName, boolean initialValue, boolean inherits, BinaryOperator<Boolean> filter, Runnable ... invalidateActions) {
        return new StylishBooleanProperty((Styleable)styleableBean, propertyName, initialValue, inherits, filter, invalidateActions);
    }

    public final StyleableBooleanProperty createBooleanProperty(S styleableBean, String propertyName, boolean initialValue, Runnable ... invalidateActions) {
        return this.createBooleanProperty(styleableBean, propertyName, initialValue, true, null, invalidateActions);
    }

    public final <T> StyleableObjectProperty<T> createObjectProperty(S styleableBean, String propertyName, T initialValue, boolean inherits, StyleConverter<?, T> converter, BinaryOperator<T> filter, Runnable ... invalidateActions) {
        return new StylishObjectProperty<T>((Styleable)styleableBean, propertyName, initialValue, inherits, converter, filter, invalidateActions);
    }

    public final <T> StyleableObjectProperty<T> createObjectProperty(S styleableBean, String propertyName, T initialValue, StyleConverter<?, T> converter, Runnable ... invalidateActions) {
        return this.createObjectProperty(styleableBean, propertyName, initialValue, true, converter, null, invalidateActions);
    }

    public final StyleableStringProperty createStringProperty(S styleableBean, String propertyName, String initialValue, boolean inherits, BinaryOperator<String> filter, Runnable ... invalidateActions) {
        return new StylishStringProperty((Styleable)styleableBean, propertyName, initialValue, inherits, filter, invalidateActions);
    }

    public final StyleableStringProperty createStringProperty(S styleableBean, String propertyName, String initialValue, Runnable ... invalidateActions) {
        return this.createStringProperty(styleableBean, propertyName, initialValue, true, null, invalidateActions);
    }

    public <T extends Enum<T>> StyleableObjectProperty<T> createEnumPropertyWithPseudoclasses(Styleable styleableBean, String propertyName, T initialValue, boolean inherits, Class<T> enumClass, BinaryOperator<T> filter, Runnable ... invalidateActions) {
        BinaryOperator pseudoClassUpdatingFilter = (oldVal, newVal) -> {
            if (oldVal != null) {
                ((Node)styleableBean).pseudoClassStateChanged(this.pseudoClasses.get(oldVal.toString().toLowerCase().replace('_', '-')), false);
            }
            if (newVal != null) {
                ((Node)styleableBean).pseudoClassStateChanged(this.pseudoClasses.get(newVal.toString().toLowerCase().replace('_', '-')), true);
            }
            if (filter != null) {
                return (Enum)filter.apply(oldVal, newVal);
            }
            return newVal;
        };
        StylishEnumProperty newProperty = new StylishEnumProperty(this, styleableBean, propertyName, initialValue, inherits, enumClass, pseudoClassUpdatingFilter, invalidateActions);
        ((Node)styleableBean).pseudoClassStateChanged(this.pseudoClasses.get(initialValue.toString().toLowerCase().replace('_', '-')), true);
        return newProperty;
    }

    public <T extends Enum<T>> StyleableObjectProperty<T> createEnumPropertyWithPseudoclasses(Styleable styleableBean, String propertyName, T initialValue, Class<T> enumClass, Runnable ... invalidateActions) {
        return this.createEnumPropertyWithPseudoclasses(styleableBean, propertyName, initialValue, true, enumClass, null, invalidateActions);
    }

    private void checkPropertyConsistency(Styleable styleableBean, String propertyName, Runnable ... invalidateActions) {
        if (styleableBean == null) {
            throw new IllegalArgumentException("styleableBean is null");
        }
        Class<?> clazz = styleableBean.getClass();
        List<String> propertyList = this.propertyNames.get(styleableBean);
        if (propertyList != null && propertyList.contains(propertyName)) {
            throw new IllegalArgumentException("class " + clazz.getName() + " contains duplicate CSS property '" + propertyName + "'");
        }
        this.propertyNames.computeIfAbsent(styleableBean, bean -> new ArrayList()).add(propertyName);
        Field field = CssPropertyFactory.getField(clazz, propertyName);
        if (field == null) {
            throw new IllegalArgumentException("class " + clazz.getName() + " does not assign CSS property '" + propertyName + "' to class field with the same name");
        }
        if (invalidateActions.length > 2) {
            throw new IllegalArgumentException("config error in class " + clazz.getName() + " for CSS property '" + propertyName + "' : only 2 (post- and pre invalidation) actions allowed, but " + invalidateActions.length + " actions are supplied");
        }
    }

    protected String getCssPropertyName(String propertyName) {
        return "-fx-" + propertyName.replaceAll("([A-Z])", "-$1").toLowerCase();
    }

    public class StylishStringProperty
    extends SimpleStyleableStringProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final BinaryOperator<String> filter;

        public StylishStringProperty(Styleable styleableBean, String propertyName, String initialValue, boolean inherits, BinaryOperator<String> filter, Runnable ... invalidateActions) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(propertyName), cssProp -> {
                CssPropertyFactory cssPropertyFactory = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory);
                return cssPropertyFactory.new SimpleCssMetaData<String>(styleableBean, propertyName, (String)cssProp, (StyleConverter<?, String>)StyleConverter.getStringConverter(), initialValue, inherits, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleableBean, propertyName, initialValue);
            CssPropertyFactory.this.checkPropertyConsistency(styleableBean, propertyName, invalidateActions);
            this.filter = filter;
            this.postInvalidateAction = invalidateActions.length > 0 ? invalidateActions[0] : null;
            this.preInvalidateAction = invalidateActions.length > 1 ? invalidateActions[1] : null;
        }

        public void set(String v) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(v);
            } else {
                super.set((String)this.filter.apply(this.get(), v));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishObjectProperty<T>
    extends SimpleStyleableObjectProperty<T> {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final BinaryOperator<T> filter;

        public StylishObjectProperty(Styleable styleableBean, String propertyName, T initialValue, boolean inherits, StyleConverter<?, T> converter, BinaryOperator<T> filter, Runnable ... invalidateActions) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(propertyName), cssProp -> {
                CssPropertyFactory cssPropertyFactory = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory);
                return cssPropertyFactory.new SimpleCssMetaData<Object>(styleableBean, propertyName, (String)cssProp, (StyleConverter<?, Object>)converter, initialValue, inherits, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleableBean, propertyName, initialValue);
            CssPropertyFactory.this.checkPropertyConsistency(styleableBean, propertyName, invalidateActions);
            this.filter = filter;
            this.postInvalidateAction = invalidateActions.length > 0 ? invalidateActions[0] : null;
            this.preInvalidateAction = invalidateActions.length > 1 ? invalidateActions[1] : null;
        }

        public void set(T v) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(v);
            } else {
                super.set(this.filter.apply(this.get(), v));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public static class StylishEnumProperty<T extends Enum<T>>
    extends SimpleStyleableObjectProperty<T> {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final BinaryOperator<T> filter;
        final /* synthetic */ CssPropertyFactory this$0;

        public StylishEnumProperty(Styleable styleableBean, String propertyName, T initialValue, boolean inherits, Class<T> enumClass, BinaryOperator<T> filter, Runnable ... invalidateActions) {
            this.this$0 = this$0;
            super(this$0.metaDataSet.computeIfAbsent(this$0.getCssPropertyName(propertyName), cssProp -> {
                CssPropertyFactory cssPropertyFactory = this$0;
                Objects.requireNonNull(cssPropertyFactory);
                SimpleCssMetaData<Enum> newMetaData = cssPropertyFactory.new SimpleCssMetaData<Enum>(styleableBean, propertyName, (String)cssProp, (StyleConverter<?, Enum>)StyleConverter.getEnumConverter((Class)enumClass), (Enum)initialValue, inherits, (List<CssMetaData<Styleable, ?>>)null);
                for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                    String name = e.toString().toLowerCase().replace('_', '-');
                    de$gsi$chart$ui$css$CssPropertyFactory$this.pseudoClasses.computeIfAbsent(name, PseudoClass::getPseudoClass);
                }
                return newMetaData;
            }), (Object)styleableBean, propertyName, initialValue);
            this$0.checkPropertyConsistency(styleableBean, propertyName, invalidateActions);
            this.filter = filter;
            this.postInvalidateAction = invalidateActions.length > 0 ? invalidateActions[0] : null;
            this.preInvalidateAction = invalidateActions.length > 1 ? invalidateActions[1] : null;
        }

        public void set(T v) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(v);
            } else {
                super.set((Object)((Enum)this.filter.apply((Enum)this.get(), v)));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishDoubleProperty
    extends SimpleStyleableDoubleProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final DoubleBinaryOperator filter;

        public StylishDoubleProperty(Styleable styleableBean, String propertyName, double initialValue, boolean inherits, DoubleBinaryOperator filter, Runnable ... invalidateActions) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(propertyName), cssProp -> {
                CssPropertyFactory cssPropertyFactory = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory);
                return cssPropertyFactory.new SimpleCssMetaData<Double>(styleableBean, propertyName, (String)cssProp, (StyleConverter<?, Double>)StyleConverter.getSizeConverter(), initialValue, inherits, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleableBean, propertyName, Double.valueOf(initialValue));
            CssPropertyFactory.this.checkPropertyConsistency(styleableBean, propertyName, invalidateActions);
            this.filter = filter;
            this.postInvalidateAction = invalidateActions.length > 0 ? invalidateActions[0] : null;
            this.preInvalidateAction = invalidateActions.length > 1 ? invalidateActions[1] : null;
        }

        public void set(double v) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(v);
            } else {
                super.set(this.filter.applyAsDouble(this.get(), v));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishFloatProperty
    extends SimpleStyleableFloatProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final BinaryOperator<Float> filter;

        public StylishFloatProperty(Styleable styleableBean, String propertyName, float initialValue, boolean inherits, BinaryOperator<Float> filter, Runnable ... invalidateActions) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(propertyName), cssProp -> {
                CssPropertyFactory cssPropertyFactory = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory);
                return cssPropertyFactory.new SimpleCssMetaData<Float>(styleableBean, propertyName, (String)cssProp, (StyleConverter<?, Float>)StyleConverter.getSizeConverter(), Float.valueOf(initialValue), inherits, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleableBean, propertyName, Float.valueOf(initialValue));
            CssPropertyFactory.this.checkPropertyConsistency(styleableBean, propertyName, invalidateActions);
            this.filter = filter;
            this.postInvalidateAction = invalidateActions.length > 0 ? invalidateActions[0] : null;
            this.preInvalidateAction = invalidateActions.length > 1 ? invalidateActions[1] : null;
        }

        public void set(float v) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(v);
            } else {
                super.set(((Float)this.filter.apply(Float.valueOf(this.get()), Float.valueOf(v))).floatValue());
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishLongProperty
    extends SimpleStyleableLongProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final LongBinaryOperator filter;

        public StylishLongProperty(Styleable styleableBean, String propertyName, long initialValue, boolean inherits, LongBinaryOperator filter, Runnable ... invalidateActions) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(propertyName), cssProp -> {
                CssPropertyFactory cssPropertyFactory = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory);
                return cssPropertyFactory.new SimpleCssMetaData<Long>(styleableBean, propertyName, (String)cssProp, (StyleConverter<?, Long>)StyleConverter.getSizeConverter(), initialValue, inherits, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleableBean, propertyName, Long.valueOf(initialValue));
            CssPropertyFactory.this.checkPropertyConsistency(styleableBean, propertyName, invalidateActions);
            this.filter = filter;
            this.postInvalidateAction = invalidateActions.length > 0 ? invalidateActions[0] : null;
            this.preInvalidateAction = invalidateActions.length > 1 ? invalidateActions[1] : null;
        }

        public void set(long v) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(v);
            } else {
                super.set(this.filter.applyAsLong(this.get(), v));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishIntegerProperty
    extends SimpleStyleableIntegerProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final IntBinaryOperator filter;

        public StylishIntegerProperty(Styleable styleableBean, String propertyName, int initialValue, boolean inherits, IntBinaryOperator filter, Runnable ... invalidateActions) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(propertyName), cssProp -> {
                CssPropertyFactory cssPropertyFactory = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory);
                return cssPropertyFactory.new SimpleCssMetaData<Integer>(styleableBean, propertyName, (String)cssProp, (StyleConverter<?, Integer>)StyleConverter.getSizeConverter(), initialValue, inherits, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleableBean, propertyName, Integer.valueOf(initialValue));
            CssPropertyFactory.this.checkPropertyConsistency(styleableBean, propertyName, invalidateActions);
            this.filter = filter;
            this.postInvalidateAction = invalidateActions.length > 0 ? invalidateActions[0] : null;
            this.preInvalidateAction = invalidateActions.length > 1 ? invalidateActions[1] : null;
        }

        public void set(int v) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(v);
            } else {
                super.set(this.filter.applyAsInt(this.get(), v));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishBooleanProperty
    extends SimpleStyleableBooleanProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final BinaryOperator<Boolean> filter;

        public StylishBooleanProperty(Styleable styleableBean, String propertyName, boolean initialValue, boolean inherits, BinaryOperator<Boolean> filter, Runnable ... invalidateActions) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(propertyName), cssProp -> {
                CssPropertyFactory cssPropertyFactory = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory);
                return cssPropertyFactory.new SimpleCssMetaData<Boolean>(styleableBean, propertyName, (String)cssProp, (StyleConverter<?, Boolean>)StyleConverter.getBooleanConverter(), initialValue, inherits, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleableBean, propertyName, initialValue);
            this.filter = filter;
            this.postInvalidateAction = invalidateActions.length > 0 ? invalidateActions[0] : null;
            this.preInvalidateAction = invalidateActions.length > 1 ? invalidateActions[1] : null;
        }

        public void set(boolean v) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(v);
            } else {
                super.set(((Boolean)this.filter.apply(this.get(), v)).booleanValue());
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class SimpleCssMetaData<T>
    extends CssMetaData<S, T> {
        private final Function<S, StyleableProperty<T>> function;

        protected SimpleCssMetaData(Styleable styleableBean, String propertyName, String cssPropertyName, StyleConverter<?, T> converter, T initialValue, boolean inherits, List<CssMetaData<? extends Styleable, ?>> subProperties) {
            super(cssPropertyName, converter, initialValue, inherits, subProperties);
            if (styleableBean == null) {
                throw new IllegalArgumentException("styleableBean for property '" + propertyName + "' is null");
            }
            Field field = CssPropertyFactory.getField(styleableBean.getClass(), propertyName);
            if (field == null) {
                throw new IllegalArgumentException("styleableBean = " + styleableBean.getClass().getName() + " FX propertyName = '" + propertyName + "' - field is null");
            }
            this.function = s -> {
                try {
                    return (StyleableProperty)field.get(s);
                }
                catch (IllegalAccessException e) {
                    LOGGER.atError().setCause((Throwable)e).addArgument((Object)s.getClass().getName()).addArgument((Object)field).addArgument((Object)propertyName).log("class {} field {} propertyName {}");
                    throw new IllegalStateException("styleableBean FX propertyName = '" + propertyName + "'  - could not get field object");
                }
            };
            CssPropertyFactory.this.metaData.add(this);
        }

        public boolean isSettable(S styleBean) {
            StyleableProperty<T> prop = this.getStyleableProperty(styleBean);
            if (prop instanceof Property) {
                return !((Property)prop).isBound();
            }
            return prop != null;
        }

        public StyleableProperty<T> getStyleableProperty(S styleBean) {
            return this.function.apply(styleBean);
        }
    }
}

