/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class DragResizerUtil {
    private static final int MARGIN = 8;
    private static final double MIN_HEIGHT = 20.0;
    private static final double MIN_WIDTH = 30.0;
    private final Node node;
    protected static final OnDragResizeEventListener DEFAULT_LISTENER = new DefaultListener();
    private final OnDragResizeEventListener listener;
    private double clickX;
    private double clickY;
    private double nodeHeight;
    private double nodeWidth;
    private double nodePositionX;
    private double nodePositionY;
    private DragDirection state = DragDirection.DEFAULT;

    protected DragResizerUtil() {
        this.node = new Region();
        this.listener = DEFAULT_LISTENER;
    }

    protected DragResizerUtil(Node node, OnDragResizeEventListener listener) {
        this.node = node;
        OnDragResizeEventListener onDragResizeEventListener = this.listener = listener != null ? listener : DEFAULT_LISTENER;
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        node.setOnMousePressed(this::mousePressed);
        node.setOnMouseDragged(this::mouseDragged);
        node.setOnMouseMoved(this::mouseOver);
        node.setOnMouseReleased(this::mouseReleased);
        node.setOnMouseClicked(this::resetNodeSize);
    }

    protected DragDirection currentMouseState(MouseEvent event) {
        boolean west = DragResizerUtil.isLeftResizeZone(event);
        boolean east = this.isRightResizeZone(event);
        boolean north = DragResizerUtil.isTopResizeZone(event);
        boolean south = this.isBottomResizeZone(event);
        if (west && north) {
            return DragDirection.NW_RESIZE;
        }
        if (west && south) {
            return DragDirection.SW_RESIZE;
        }
        if (east && north) {
            return DragDirection.NE_RESIZE;
        }
        if (east && south) {
            return DragDirection.SE_RESIZE;
        }
        if (east) {
            return DragDirection.E_RESIZE;
        }
        if (west) {
            return DragDirection.W_RESIZE;
        }
        if (north) {
            return DragDirection.N_RESIZE;
        }
        if (south) {
            return DragDirection.S_RESIZE;
        }
        if (this.isInDragZone(event)) {
            return DragDirection.DRAG;
        }
        return DragDirection.DEFAULT;
    }

    protected static boolean intersect(double side, double point) {
        return side + 8.0 > point && side - 8.0 < point;
    }

    protected boolean isBottomResizeZone(MouseEvent event) {
        return DragResizerUtil.intersect(this.node.getBoundsInParent().getHeight(), event.getY());
    }

    protected boolean isInDragZone(MouseEvent event) {
        Bounds bounds = this.node.getBoundsInParent();
        double xPos = bounds.getMinX() + event.getX();
        double yPos = bounds.getMinY() + event.getY();
        double nodeX = bounds.getMinX() + 8.0;
        double nodeY = bounds.getMinY() + 8.0;
        double nodeX0 = bounds.getMinX() + bounds.getWidth() - 8.0;
        double nodeY0 = bounds.getMinY() + bounds.getHeight() - 8.0;
        return xPos > nodeX && xPos < nodeX0 && yPos > nodeY && yPos < nodeY0;
    }

    protected boolean isInResizeZone(MouseEvent event) {
        return DragResizerUtil.isLeftResizeZone(event) || this.isRightResizeZone(event) || this.isBottomResizeZone(event) || DragResizerUtil.isTopResizeZone(event);
    }

    protected static boolean isLeftResizeZone(MouseEvent event) {
        return DragResizerUtil.intersect(0.0, event.getX());
    }

    protected boolean isRightResizeZone(MouseEvent event) {
        Bounds bounds = this.node.getBoundsInParent();
        return DragResizerUtil.intersect(bounds.getWidth(), event.getX());
    }

    protected static boolean isTopResizeZone(MouseEvent event) {
        return DragResizerUtil.intersect(0.0, event.getY());
    }

    protected void resetNodeSize(MouseEvent evt) {
        if (!evt.isPrimaryButtonDown() || evt.getClickCount() < 2) {
            return;
        }
        if (!(this.node instanceof Region)) {
            return;
        }
        ((Region)this.node).setPrefWidth(-1.0);
        ((Region)this.node).setPrefHeight(-1.0);
    }

    protected void setNewInitialEventCoordinates(MouseEvent event) {
        Bounds bounds = this.node.getBoundsInParent();
        this.nodePositionX = bounds.getMinX();
        this.nodePositionY = bounds.getMinY();
        this.nodeHeight = bounds.getHeight();
        this.nodeWidth = bounds.getWidth();
        this.clickX = event.getX();
        this.clickY = event.getY();
    }

    protected void mouseDragged(MouseEvent event) {
        Bounds bounds = this.node.getBoundsInParent();
        double mouseX = bounds.getMinX() + event.getX();
        double mouseY = bounds.getMinY() + event.getY();
        if (this.state == DragDirection.DRAG) {
            this.listener.onDrag(this.node, mouseX - this.clickX, mouseY - this.clickY, this.nodeWidth, this.nodeHeight);
            return;
        }
        if (this.state == DragDirection.DEFAULT) {
            return;
        }
        double newX = this.nodePositionX;
        double newY = this.nodePositionY;
        double newHeight = this.nodeHeight;
        double newWidth = this.nodeWidth;
        if (this.state.isEast()) {
            newWidth = mouseX - this.nodePositionX;
        }
        if (this.state.isWest()) {
            newX = mouseX;
            newWidth = this.nodeWidth + this.nodePositionX - newX;
        }
        if (this.state.isSouth()) {
            newHeight = mouseY - this.nodePositionY;
        }
        if (this.state.isNorth()) {
            newY = mouseY;
            newHeight = this.nodeHeight + this.nodePositionY - newY;
        }
        if (newWidth < 30.0) {
            if (this.state == DragDirection.W_RESIZE || this.state == DragDirection.NW_RESIZE || this.state == DragDirection.SW_RESIZE) {
                newX = newX - 30.0 + newWidth;
            }
            newWidth = 30.0;
        }
        if (newHeight < 20.0) {
            if (this.state == DragDirection.N_RESIZE || this.state == DragDirection.NW_RESIZE || this.state == DragDirection.NE_RESIZE) {
                newY = newY + newHeight - 20.0;
            }
            newHeight = 20.0;
        }
        this.listener.onResize(this.node, newX, newY, newWidth, newHeight);
    }

    protected void mouseOver(MouseEvent event) {
        DragDirection retState = this.currentMouseState(event);
        Cursor cursor = DragResizerUtil.getCursorForState(retState);
        this.node.setCursor(cursor);
    }

    protected void mousePressed(MouseEvent event) {
        if (this.isInResizeZone(event)) {
            this.setNewInitialEventCoordinates(event);
            this.state = this.currentMouseState(event);
            this.resetNodeSize(event);
        } else if (this.isInDragZone(event)) {
            this.setNewInitialEventCoordinates(event);
            this.state = DragDirection.DRAG;
        } else {
            this.state = DragDirection.DEFAULT;
        }
    }

    protected void mouseReleased(MouseEvent event) {
        this.node.setCursor(Cursor.DEFAULT);
        this.state = DragDirection.DEFAULT;
    }

    public static void makeResizable(Node node) {
        DragResizerUtil.makeResizable(node, null);
    }

    public static void makeResizable(Node node, OnDragResizeEventListener listener) {
        new DragResizerUtil(node, listener);
    }

    protected static Cursor getCursorForState(DragDirection state) {
        switch (state) {
            case NW_RESIZE: {
                return Cursor.NW_RESIZE;
            }
            case SW_RESIZE: {
                return Cursor.SW_RESIZE;
            }
            case NE_RESIZE: {
                return Cursor.NE_RESIZE;
            }
            case SE_RESIZE: {
                return Cursor.SE_RESIZE;
            }
            case E_RESIZE: {
                return Cursor.E_RESIZE;
            }
            case W_RESIZE: {
                return Cursor.W_RESIZE;
            }
            case N_RESIZE: {
                return Cursor.N_RESIZE;
            }
            case S_RESIZE: {
                return Cursor.S_RESIZE;
            }
        }
        return Cursor.DEFAULT;
    }

    private static class DefaultListener
    implements OnDragResizeEventListener {
        private DefaultListener() {
        }

        @Override
        public void onDrag(Node node, double x, double y, double width, double height) {
            this.setNodeSize(node, x, y, width, height);
        }

        @Override
        public void onResize(Node node, double x, double y, double width, double height) {
            this.setNodeSize(node, x, y, width, height);
        }

        protected void setNodeSize(Node node, double x, double y, double width, double height) {
            node.setLayoutX(x);
            node.setLayoutY(y);
            if (node instanceof Canvas) {
                ((Canvas)node).setWidth(width);
                ((Canvas)node).setHeight(height);
            } else if (node instanceof Rectangle) {
                ((Rectangle)node).setWidth(width);
                ((Rectangle)node).setHeight(height);
            } else if (node instanceof Region) {
                ((Region)node).setPrefWidth(width);
                ((Region)node).setPrefHeight(height);
            }
        }
    }

    public static interface OnDragResizeEventListener {
        public void onDrag(Node var1, double var2, double var4, double var6, double var8);

        public void onResize(Node var1, double var2, double var4, double var6, double var8);
    }

    public static enum DragDirection {
        DEFAULT,
        DRAG,
        E_RESIZE,
        N_RESIZE,
        NE_RESIZE,
        NW_RESIZE,
        S_RESIZE,
        SE_RESIZE,
        SW_RESIZE,
        W_RESIZE;


        public boolean isEast() {
            switch (this) {
                case NE_RESIZE: 
                case SE_RESIZE: 
                case E_RESIZE: {
                    return true;
                }
            }
            return false;
        }

        public boolean isWest() {
            switch (this) {
                case NW_RESIZE: 
                case SW_RESIZE: 
                case W_RESIZE: {
                    return true;
                }
            }
            return false;
        }

        public boolean isNorth() {
            switch (this) {
                case NW_RESIZE: 
                case NE_RESIZE: 
                case N_RESIZE: {
                    return true;
                }
            }
            return false;
        }

        public boolean isSouth() {
            switch (this) {
                case NW_RESIZE: 
                case NE_RESIZE: 
                case N_RESIZE: {
                    return true;
                }
            }
            return false;
        }
    }
}

