/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineHelper;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngWriter;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import ar.com.hjg.pngj.chunks.PngChunkTRNS;
import de.gsi.chart.utils.PaletteQuantizer;
import de.gsi.chart.utils.PaletteQuantizerNeuQuant;
import de.gsi.chart.utils.WritableImageCache;
import de.gsi.dataset.utils.ArrayCache;
import de.gsi.dataset.utils.ByteBufferOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriteFxImage {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteFxImage.class);
    private static final int DEFAULT_PALETTE_COLOR_COUNT = 256;
    private static final String IMAGE_PIXEL_READER_NOT_AVAILABLE = "image PixelReader not available";
    private static final String IMAGE_MUST_NOT_BE_NULL = "image must not be null";
    private static final int HEADER_SIZE = 57;
    private static final String INTERNAL_ARRAY_CACHE_NAME = "WriteFxImage-internalArray";
    private static final String INTERNAL_LINE_ARRAY_CACHE_NAME = "WriteFxImage-internalLineArray";

    private WriteFxImage() {
    }

    public static WritableImage clone(Image image) {
        int height = (int)image.getHeight();
        int width = (int)image.getWidth();
        WritableImage writableImage = WritableImageCache.getInstance().getImage(width, height);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        if (pixelWriter == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        PixelReader pixelReader = image.getPixelReader();
        if (pixelReader == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color color = pixelReader.getColor(x, y);
                pixelWriter.setColor(x, y, color);
            }
        }
        return writableImage;
    }

    public static void copyImageDataToPixelBuffer(Image image, int[] uncompressedImageData) {
        int h;
        if (image == null) {
            throw new IllegalArgumentException("image is null");
        }
        PixelReader pr = image.getPixelReader();
        if (pr == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        if (uncompressedImageData == null) {
            throw new IllegalArgumentException("uncompressedImageData is null");
        }
        int w = (int)image.getWidth();
        int requiredSize = w * (h = (int)image.getHeight());
        if (uncompressedImageData.length < requiredSize) {
            throw new IllegalArgumentException("uncompressedImageData.length = " + uncompressedImageData.length + " too small, should be at least" + requiredSize);
        }
        int i = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                uncompressedImageData[i++] = pr.getArgb(x, y);
            }
        }
    }

    public static ByteBuffer encode(Image image) {
        return WriteFxImage.encode(image, null, true, 1, null);
    }

    public static ByteBuffer encode(Image image, ByteBuffer byteBuffer, boolean alpha, int compressionLevel, FilterType filterType) {
        ByteBuffer byteBuffer2;
        if (image == null) {
            throw new IllegalArgumentException(IMAGE_MUST_NOT_BE_NULL);
        }
        PixelReader pr = image.getPixelReader();
        if (pr == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        int w = (int)image.getWidth();
        int h = (int)image.getHeight();
        ByteBuffer outputByteBuffer = byteBuffer == null ? ByteBuffer.allocate(WriteFxImage.getCompressedSizeBound(w, h, alpha)) : byteBuffer;
        ByteBufferOutputStream os = new ByteBufferOutputStream(outputByteBuffer, new boolean[]{false});
        try {
            int y;
            PngWriter png = new PngWriter((OutputStream)os, new ImageInfo(w, h, 8, alpha, false, false));
            png.getPixelsWriter().setFilterType(filterType == null ? FilterType.FILTER_NONE : filterType);
            png.setIdatMaxSize(65536);
            png.setCompLevel(compressionLevel);
            ImageLineInt line = new ImageLineInt(png.imgInfo);
            if (alpha) {
                for (y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        int pixel = pr.getArgb(x, y);
                        ImageLineHelper.setPixelRGBA8((ImageLineInt)line, (int)x, (int)pixel);
                    }
                    png.writeRow((IImageLine)line, y);
                }
            } else {
                for (y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        int pixel = pr.getArgb(x, y);
                        ImageLineHelper.setPixelRGB8((ImageLineInt)line, (int)x, (int)pixel);
                    }
                    png.writeRow((IImageLine)line, y);
                }
            }
            png.end();
            byteBuffer2 = os.buffer().flip();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.atError().setCause((Throwable)e).log("buffer couldn't be closes");
                return null;
            }
        }
        os.close();
        return byteBuffer2;
    }

    public static ByteBuffer encodeAlt(Image image, ByteBuffer byteBuffer, boolean alpha, int compressionLevel, Map<String, Object> metaInfo) {
        if (image == null) {
            throw new IllegalArgumentException(IMAGE_MUST_NOT_BE_NULL);
        }
        PixelReader pr = image.getPixelReader();
        if (pr == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        int w = (int)image.getWidth();
        int h = (int)image.getHeight();
        ByteBuffer outputByteBuffer = byteBuffer == null ? ByteBuffer.allocate(WriteFxImage.getCompressedSizeBound(w, h, alpha)) : byteBuffer;
        CRC32 crc = new CRC32();
        Deflater compressor = new Deflater(compressionLevel);
        WriteFxImage.writeImageHeader(w, h, alpha, outputByteBuffer, crc);
        WriteFxImage.writeImageData(pr, w, h, alpha, compressor, outputByteBuffer, crc);
        WriteFxImage.writeImageFooter(outputByteBuffer, crc);
        outputByteBuffer.flip();
        if (metaInfo != null) {
            int bytesPerPixel = alpha ? 4 : 3;
            metaInfo.put("bufferSize", outputByteBuffer.capacity());
            metaInfo.put("outputSizeBound", WriteFxImage.getCompressedSizeBound(w, h, alpha));
            metaInfo.put("compression", (double)compressor.getBytesWritten() / (double)(w * h * bytesPerPixel));
            metaInfo.put("width", w);
            metaInfo.put("height", h);
            metaInfo.put("colorMode", alpha ? "rgba" : "rgb");
            metaInfo.put("compressionLevel", compressionLevel);
            metaInfo.put("outputSize", outputByteBuffer.limit() - outputByteBuffer.position());
        }
        return outputByteBuffer;
    }

    public static ByteBuffer encodePalette(Image image, ByteBuffer byteBuffer, boolean alpha, int compressionLevel, FilterType filterType, PaletteQuantizer ... userPalette) {
        ByteBuffer byteBuffer2;
        if (image == null) {
            throw new IllegalArgumentException(IMAGE_MUST_NOT_BE_NULL);
        }
        int w = (int)image.getWidth();
        int h = (int)image.getHeight();
        int nPixel = w * h;
        int[] uncompressedImageData = ArrayCache.getCachedIntArray((String)INTERNAL_ARRAY_CACHE_NAME, (int)nPixel);
        WriteFxImage.copyImageDataToPixelBuffer(image, uncompressedImageData);
        PaletteQuantizer palette = userPalette.length > 0 && userPalette[0] != null ? userPalette[0] : WriteFxImage.estimatePalette(uncompressedImageData, w, h, alpha, 256);
        int bytesPerPixel = 3;
        int bytesPerPalette = 3 * palette.getColorCount();
        int requiredSize = WriteFxImage.getCompressedSizeBound(w, h, alpha) + bytesPerPalette;
        ByteBuffer outputByteBuffer = byteBuffer == null ? ByteBuffer.allocate(requiredSize) : byteBuffer;
        ByteBufferOutputStream os = new ByteBufferOutputStream(outputByteBuffer, new boolean[]{false});
        try {
            ImageInfo imageInfo = new ImageInfo(w, h, 8, false, false, true);
            PngWriter pngWriter = new PngWriter((OutputStream)os, imageInfo);
            pngWriter.getPixelsWriter().setFilterType(filterType);
            pngWriter.setIdatMaxSize(requiredSize > 131072 ? 65536 : 32000);
            pngWriter.setCompLevel(compressionLevel);
            WriteFxImage.preparePaletteHeader(pngWriter, palette);
            int[] lineArray = ArrayCache.getCachedIntArray((String)INTERNAL_LINE_ARRAY_CACHE_NAME, (int)w);
            ImageLineInt line = new ImageLineInt(pngWriter.imgInfo, lineArray);
            if (alpha) {
                int row = 0;
                for (int i = 0; i < nPixel; ++i) {
                    int lineIndex = i % w;
                    int pixel = uncompressedImageData[i];
                    lineArray[lineIndex] = palette.lookup(pixel >> 16 & 0xFF, pixel >> 8 & 0xFF, pixel & 0xFF, pixel >> 24 & 0xFF);
                    if (lineIndex != w - 1) continue;
                    pngWriter.writeRow((IImageLine)line, row++);
                }
            } else {
                for (int i = 0; i < nPixel; ++i) {
                    int lineIndex = i % w;
                    int pixel = uncompressedImageData[i];
                    lineArray[lineIndex] = palette.lookup(pixel >> 16 & 0xFF, pixel >> 8 & 0xFF, pixel & 0xFF);
                    if (lineIndex != w - 1) continue;
                    pngWriter.writeRow((IImageLine)line);
                }
            }
            pngWriter.end();
            ArrayCache.release((String)INTERNAL_ARRAY_CACHE_NAME, (int[])uncompressedImageData);
            ArrayCache.release((String)INTERNAL_LINE_ARRAY_CACHE_NAME, (int[])lineArray);
            byteBuffer2 = os.buffer().flip();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.atError().setCause((Throwable)e).log("buffer couldn't be closed");
                return null;
            }
        }
        os.close();
        return byteBuffer2;
    }

    public static PaletteQuantizer estimatePalette(Image image, boolean alpha, int nColors) {
        if (image == null) {
            throw new IllegalArgumentException(IMAGE_MUST_NOT_BE_NULL);
        }
        PixelReader pr = image.getPixelReader();
        if (pr == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        int w = (int)image.getWidth();
        int h = (int)image.getHeight();
        PaletteQuantizerNeuQuant cuant = new PaletteQuantizerNeuQuant(w, h, (x, y) -> pr.getArgb(y, x));
        cuant.setParReserveAlphaColor(alpha);
        cuant.setParNcolors(nColors);
        cuant.run();
        return cuant;
    }

    public static PaletteQuantizer estimatePalette(int[] pixelArray, int width, int heigth, boolean alpha, int nColors) {
        if (pixelArray == null) {
            throw new IllegalArgumentException("pixelArray must not be null");
        }
        if (pixelArray.length < width * heigth) {
            throw new IllegalArgumentException("pixelArray.length(" + pixelArray.length + " must be >= " + width * heigth + " = " + width + " (width) x" + heigth + " (height)");
        }
        PaletteQuantizerNeuQuant cuant = new PaletteQuantizerNeuQuant(width, heigth, (x, y) -> pixelArray[x * width + y]);
        cuant.setParReserveAlphaColor(alpha);
        cuant.setParNcolors(nColors);
        cuant.run();
        return cuant;
    }

    public static int getCompressedSizeBound(int width, int height, boolean alpha) {
        int bytesPerPixel = alpha ? 4 : 3;
        int uncompressedSize = width * height * bytesPerPixel + height + 57;
        int compressedSize = uncompressedSize + (uncompressedSize + 7 >> 3) + (uncompressedSize + 63 >> 6) + 5;
        return compressedSize + 57;
    }

    public static void savePng(Image image, File file) throws IOException {
        try (OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ByteBuffer buffer = WriteFxImage.encode(image);
            os.write(buffer.array(), 0, buffer.limit());
        }
    }

    private static void preparePaletteHeader(PngWriter pngWriter, PaletteQuantizer cuant) {
        PngChunkPLTE palette = pngWriter.getMetadata().createPLTEChunk();
        int ncolors = cuant.getColorCount();
        palette.setNentries(ncolors);
        for (int i = 0; i < ncolors; ++i) {
            int[] col = cuant.getColor(i);
            palette.setEntry(i, col[0], col[1], col[2]);
        }
        int transparentIndex = cuant.getTransparentIndex();
        if (transparentIndex >= 0) {
            PngChunkTRNS transparent = new PngChunkTRNS(pngWriter.imgInfo);
            transparent.setIndexEntryAsTransparent(transparentIndex);
            pngWriter.getChunksList().queue((PngChunk)transparent);
        }
    }

    private static void write(byte[] b, ByteBuffer buffer, CRC32 crc) {
        buffer.put(b);
        crc.update(b);
    }

    private static void write(int i, ByteBuffer buffer, CRC32 crc) {
        byte[] b = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        WriteFxImage.write(b, buffer, crc);
    }

    private static void writeImageData(PixelReader pr, int w, int h, boolean alpha, Deflater compressor, ByteBuffer outputByteBuffer, CRC32 crc) {
        int bytesPerPixel = alpha ? 4 : 3;
        int rawDataSize = w * h * bytesPerPixel + h;
        byte[] uncompressedImageData = ArrayCache.getCachedByteArray((String)INTERNAL_ARRAY_CACHE_NAME, (int)rawDataSize);
        int i = 0;
        if (alpha) {
            for (int y = 0; y < h; ++y) {
                uncompressedImageData[i++] = 0;
                for (int x = 0; x < w; ++x) {
                    int pixel = pr.getArgb(x, y);
                    uncompressedImageData[i++] = (byte)(pixel >> 16 & 0xFF);
                    uncompressedImageData[i++] = (byte)(pixel >> 8 & 0xFF);
                    uncompressedImageData[i++] = (byte)(pixel & 0xFF);
                    uncompressedImageData[i++] = (byte)(pixel >> 24 & 0xFF);
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                uncompressedImageData[i++] = 0;
                for (int x = 0; x < w; ++x) {
                    int pixel = pr.getArgb(x, y);
                    uncompressedImageData[i++] = (byte)(pixel >> 16 & 0xFF);
                    uncompressedImageData[i++] = (byte)(pixel >> 8 & 0xFF);
                    uncompressedImageData[i++] = (byte)(pixel & 0xFF);
                }
            }
        }
        compressor.setInput(uncompressedImageData);
        outputByteBuffer.mark();
        outputByteBuffer.putInt(0);
        outputByteBuffer.put("IDAT".getBytes());
        compressor.finish();
        compressor.deflate(outputByteBuffer, 3);
        outputByteBuffer.limit(outputByteBuffer.position());
        outputByteBuffer.reset();
        outputByteBuffer.putInt(compressor.getTotalOut());
        crc.reset();
        crc.update(outputByteBuffer);
        outputByteBuffer.limit(outputByteBuffer.capacity());
        outputByteBuffer.putInt((int)crc.getValue());
        ArrayCache.release((String)INTERNAL_ARRAY_CACHE_NAME, (byte[])uncompressedImageData);
    }

    private static void writeImageFooter(ByteBuffer outputByteBuffer, CRC32 crc) {
        outputByteBuffer.putInt(0);
        crc.reset();
        WriteFxImage.write("IEND".getBytes(), outputByteBuffer, crc);
        outputByteBuffer.putInt((int)crc.getValue());
    }

    private static void writeImageHeader(int width, int height, boolean alpha, ByteBuffer outputByteBuffer, CRC32 crc) {
        byte[] byArray;
        outputByteBuffer.put(new byte[]{-119, 80, 78, 71, 13, 10, 26, 10});
        outputByteBuffer.putInt(13);
        crc.reset();
        WriteFxImage.write("IHDR".getBytes(), outputByteBuffer, crc);
        WriteFxImage.write(width, outputByteBuffer, crc);
        WriteFxImage.write(height, outputByteBuffer, crc);
        if (alpha) {
            byte[] byArray2 = new byte[5];
            byArray2[0] = 8;
            byArray2[1] = 6;
            byArray2[2] = 0;
            byArray2[3] = 0;
            byArray = byArray2;
            byArray2[4] = 0;
        } else {
            byte[] byArray3 = new byte[5];
            byArray3[0] = 8;
            byArray3[1] = 2;
            byArray3[2] = 0;
            byArray3[3] = 0;
            byArray = byArray3;
            byArray3[4] = 0;
        }
        WriteFxImage.write(byArray, outputByteBuffer, crc);
        outputByteBuffer.putInt((int)crc.getValue());
    }
}

