/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.geonames_ww;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import org.apache.commons.lang3.RandomUtils;
import org.controlsfx.control.CheckListView;
import org.controlsfx.control.IndexedCheckModel;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.mapton.addon.geonames_ww.Bundle;
import org.mapton.api.Mapton;
import org.mapton.core.api.MTopComponent;
import org.mapton.geonames.api.Country;
import org.mapton.geonames.api.CountryManager;
import org.mapton.geonames.api.GeonamesManager;
import org.openide.windows.TopComponent;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

@TopComponent.Description(preferredID="GeoNamesTopComponent", persistenceType=0)
public final class GeoNamesTopComponent
extends MTopComponent {
    private IndexedCheckModel<Country> mCheckModel;
    private ListChangeListener<Country> mListChangeListener;
    private CheckListView<Country> mListView;
    private BorderPane mRoot;

    public GeoNamesTopComponent() {
        this.setName(Bundle.CTL_GeoNamesAction());
        GeonamesManager.getInstance().init();
    }

    protected void initFX() {
        this.setScene(this.createScene());
        this.initListeners();
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    private Scene createScene() {
        Action randomAction = new Action(Dict.RANDOM.toString(), event -> {
            int offset;
            this.mListView.getCheckModel().getCheckedItems().removeListener(this.mListChangeListener);
            int randomSpan = 10;
            for (int i = offset = RandomUtils.nextInt((int)0, (int)randomSpan); i < this.mListView.getItems().size(); i += randomSpan) {
                this.mListView.getCheckModel().check(i);
            }
            Mapton.getGlobalState().put("geoname.list.selection", (Object)this.mCheckModel.getCheckedItems());
            this.mCheckModel.getCheckedItems().addListener(this.mListChangeListener);
        });
        randomAction.setGraphic((Node)MaterialIcon._Places.CASINO.getImageView(Mapton.getIconSizeToolBarInt()));
        Action clearAction = new Action(Dict.CLEAR.toString(), event -> {
            this.mListView.getCheckModel().getCheckedItems().removeListener(this.mListChangeListener);
            this.mListView.getCheckModel().clearChecks();
            Mapton.getGlobalState().put("geoname.list.selection", (Object)this.mCheckModel.getCheckedItems());
            this.mCheckModel.getCheckedItems().addListener(this.mListChangeListener);
        });
        clearAction.setGraphic((Node)MaterialIcon._Content.CLEAR.getImageView(Mapton.getIconSizeToolBarInt()));
        List<Action> actions = Arrays.asList(randomAction, ActionUtils.ACTION_SPAN, clearAction);
        ToolBar toolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        FxHelper.adjustButtonWidth((Stream)toolBar.getItems().stream(), (double)Mapton.getIconSizeToolBarInt());
        toolBar.getItems().stream().filter(item -> item instanceof ButtonBase).map(item -> (ButtonBase)item).forEachOrdered(buttonBase -> FxHelper.undecorateButton((ButtonBase)buttonBase));
        FxHelper.slimToolBar((ToolBar)toolBar);
        Label titleLabel = Mapton.createTitle((String)Bundle.CTL_GeoNamesAction());
        this.mListView = new CheckListView();
        this.mListView.getItems().setAll((Collection)CountryManager.getInstance().getCountryList());
        this.mCheckModel = this.mListView.getCheckModel();
        BorderPane innerPane = new BorderPane((Node)toolBar);
        this.mRoot = new BorderPane(this.mListView);
        innerPane.setTop((Node)titleLabel);
        this.mRoot.setTop((Node)innerPane);
        titleLabel.prefWidthProperty().bind((ObservableValue)this.mRoot.widthProperty());
        return new Scene((Parent)this.mRoot);
    }

    private Country getSelected() {
        return (Country)this.mListView.getSelectionModel().getSelectedItem();
    }

    private void initListeners() {
        this.mListView.getSelectionModel().getSelectedItems().addListener(c -> {
            if (this.getSelected() != null) {
                Mapton.getEngine().fitToBounds(this.getSelected().getLatLonBox());
            }
        });
        this.mListChangeListener = c -> Mapton.getGlobalState().put("geoname.list.selection", (Object)this.mCheckModel.getCheckedItems());
        this.mCheckModel.getCheckedItems().addListener(this.mListChangeListener);
    }
}

