/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.wms.nasa;

import java.util.TreeMap;
import org.mapton.api.MAttribution;
import org.mapton.api.MWmsGenerator;

public class GenerateSources
extends MWmsGenerator {
    public static void main(String[] args) {
        new GenerateSources();
    }

    public GenerateSources() {
        this.init(true);
        System.out.println(this.getSourceJson());
    }

    private void init(boolean enabled) {
        TreeMap<String, String> layers = new TreeMap<String, String>();
        layers.put("AURA_UVI_CLIM_M", "gov.nasa.neo.uv");
        MAttribution attribution = new MAttribution();
        attribution.setProviderName("NASA Earth Observations");
        attribution.setProviderUrl("https://neo.sci.gsfc.nasa.gov/view.php?datasetId=AURA_UVI_CLIM_M");
        attribution.setLicenseName("\"Freely available for public use\"");
        attribution.setLicenseUrl("https://neo.sci.gsfc.nasa.gov/about/");
        attribution.setRawHtml("Imagery by Jesse Allen, NASA Earth Observatory, based on data provided by Jerry Ziemke from the Ozone Monitoring Instrument (OMI) science team.");
        TreeMap<String, MAttribution> attributions = new TreeMap<String, MAttribution>();
        attributions.put("gov.nasa.neo.uv", attribution);
        this.mSources.add(this.createSource("NEO", "https://neo.sci.gsfc.nasa.gov/wms/wms?version=1.3.0&service=WMS&request=GetCapabilities", layers, attributions, enabled));
    }

    private void initSwedGeo(boolean enabled) {
        TreeMap<String, String> layers = new TreeMap<String, String>();
        layers.put("orto025", "se.lm.orto_025");
        layers.put("topowebbkartan", "se.lm.topoweb");
        layers.put("topowebbkartan_nedtonad", "se.lm.topoweb_dim");
        layers.put("fastighet_text", "se.lm.fastighet_text");
        layers.put("fastighet_granser", "se.lm.fastighet_granser");
        layers.put("terrangskuggning", "se.lm.terrangskuggning");
        MAttribution attribution = new MAttribution();
        TreeMap attributions = new TreeMap();
        this.mSources.add(this.createSource("Lantm\u00e4teriet", "http://gis.swedgeo.se/geoserver/lantmateriet/wms?", layers, attributions, enabled));
    }
}

