/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.BeforeAfterViewSkin;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.PseudoClass;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class BeforeAfterView
extends Control {
    private static final PseudoClass horizontal = PseudoClass.getPseudoClass((String)"horizontal");
    private static final PseudoClass vertical = PseudoClass.getPseudoClass((String)"vertical");
    private final ObjectProperty<Orientation> orientation = new SimpleObjectProperty((Object)this, "orientation", (Object)Orientation.HORIZONTAL);
    private final DoubleProperty dividerPosition = new SimpleDoubleProperty((Object)this, "dividerPosition", 0.5);
    private final ObjectProperty<Node> before = new SimpleObjectProperty((Object)this, "before", (Object)new Label("Before"));
    private final ObjectProperty<Node> after = new SimpleObjectProperty((Object)this, "after", (Object)new Label("After"));

    public BeforeAfterView() {
        this.getStyleClass().add((Object)"before-after-view");
        Label before = new Label();
        before.setPrefSize(600.0, 400.0);
        before.setStyle("-fx-background-color: red;");
        this.setBefore((Node)before);
        Label after = new Label();
        after.setPrefSize(600.0, 400.0);
        after.setStyle("-fx-background-color: green;");
        this.setAfter((Node)after);
        this.beforeProperty().addListener(it -> {
            Node node = this.getBefore();
            if (node != null) {
                node.setMouseTransparent(true);
            }
        });
        this.afterProperty().addListener(it -> {
            Node node = this.getAfter();
            if (node != null) {
                node.setMouseTransparent(true);
            }
        });
        this.orientationProperty().addListener(it -> this.updatePseudoClass());
        this.updatePseudoClass();
    }

    private void updatePseudoClass() {
        this.pseudoClassStateChanged(horizontal, this.getOrientation().equals((Object)Orientation.HORIZONTAL));
        this.pseudoClassStateChanged(vertical, this.getOrientation().equals((Object)Orientation.VERTICAL));
    }

    public BeforeAfterView(Node beforeNode, Node afterNode) {
        this();
        this.setBefore(beforeNode);
        this.setAfter(afterNode);
    }

    public BeforeAfterView(Image beforeImage, Image afterImage) {
        this((Node)new ImageView(beforeImage), (Node)new ImageView(afterImage));
    }

    protected Skin<?> createDefaultSkin() {
        return new BeforeAfterViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return BeforeAfterView.class.getResource("before-after-view.css").toExternalForm();
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public final double getDividerPosition() {
        return this.dividerPosition.get();
    }

    public final DoubleProperty dividerPositionProperty() {
        return this.dividerPosition;
    }

    public final void setDividerPosition(double dividerPosition) {
        this.dividerPosition.set(dividerPosition);
    }

    public final Node getBefore() {
        return (Node)this.before.get();
    }

    public final ObjectProperty<Node> beforeProperty() {
        return this.before;
    }

    public final void setBefore(Node before) {
        this.before.set((Object)before);
    }

    public final Node getAfter() {
        return (Node)this.after.get();
    }

    public final ObjectProperty<Node> afterProperty() {
        return this.after;
    }

    public final void setAfter(Node after) {
        this.after.set((Object)after);
    }
}

