/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.DurationPickerSkin;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import javafx.util.Pair;

public class DurationPicker
extends Control {
    private final ReadOnlyBooleanWrapper showing = new ReadOnlyBooleanWrapper((Object)this, "showing", false);
    private final ObjectProperty<Callback<Pair<ChronoUnit, ChronoUnit>, Node>> separatorFactory = new SimpleObjectProperty((Object)this, "separatorFactory");
    private final ObjectProperty<Duration> duration = new SimpleObjectProperty((Object)this, "duration", (Object)Duration.ZERO);
    private final ListProperty<ChronoUnit> fields = new SimpleListProperty((Object)this, "fields", FXCollections.observableArrayList((Object[])new ChronoUnit[]{ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS}));
    private final BooleanProperty linkingFields = new SimpleBooleanProperty((Object)this, "linkingFields", true);
    private final BooleanProperty rollover = new SimpleBooleanProperty((Object)this, "rollOver", true);
    private final ObjectProperty<Consumer<DurationPicker>> onShowPopup = new SimpleObjectProperty((Object)this, "onShowPopup");
    private final BooleanProperty showPopupTriggerButton = new SimpleBooleanProperty((Object)this, "showPopupTriggerButton", true);
    private final ObjectProperty<Duration> minimumDuration = new SimpleObjectProperty((Object)this, "earliestTime", (Object)Duration.ZERO);
    private final ObjectProperty<Duration> maximumDuration = new SimpleObjectProperty((Object)this, "maximumDuration");
    private final ObjectProperty<LabelType> labelType = new SimpleObjectProperty((Object)this, "labelType", (Object)LabelType.SHORT);
    private final BooleanProperty fillDigits = new SimpleBooleanProperty((Object)this, "fillDigits", true);

    public DurationPicker() {
        this.getStyleClass().addAll((Object[])new String[]{"duration-picker", "text-input"});
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.minimumDurationProperty().addListener(it -> {
            Duration minimumDuration = this.getMinimumDuration();
            if (minimumDuration == null) {
                throw new IllegalArgumentException("the minimum duration can not be null, it always has to be at least Duration.ZERO");
            }
            if (minimumDuration.isNegative()) {
                throw new IllegalArgumentException("the minimum duration can not be negative, but was " + minimumDuration);
            }
        });
        InvalidationListener constrainListener = it -> this.constrain();
        this.durationProperty().addListener(constrainListener);
        this.minimumDurationProperty().addListener(constrainListener);
        this.maximumDurationProperty().addListener(constrainListener);
        this.setSeparatorFactory((Callback<Pair<ChronoUnit, ChronoUnit>, Node>)((Callback)pair -> {
            Label label = new Label(":");
            label.getStyleClass().add((Object)"separator");
            return label;
        }));
        this.setOnShowPopup(picker -> this.show());
        this.setMaximumDuration(Duration.ofDays(7L));
        this.getFields().setAll((Object[])new ChronoUnit[]{ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS, ChronoUnit.MILLIS});
        MapChangeListener propertiesListener = change -> {
            if (change.wasAdded()) {
                if (change.getKey().equals("TIME_PICKER_POPUP")) {
                    this.setShowing(!this.isShowing());
                    this.getProperties().remove((Object)"TIME_PICKER_POPUP");
                } else if (change.getKey().equals("NEW_DURATION")) {
                    this.setDuration((Duration)change.getValueAdded());
                    this.getProperties().remove((Object)"NEW_DURATION");
                }
            }
        };
        this.getProperties().addListener(propertiesListener);
        this.getStylesheets().add((Object)this.getUserAgentStylesheet());
    }

    private void constrain() {
        Duration duration = this.getDuration();
        if (duration != null) {
            Duration maximumDuration;
            Duration minimumDuration = this.getMinimumDuration();
            if (minimumDuration != null && duration.minus(minimumDuration).isNegative()) {
                this.setDuration(minimumDuration);
            }
            if ((maximumDuration = this.getMaximumDuration()) != null && maximumDuration.minus(duration).isNegative()) {
                this.setDuration(maximumDuration);
            }
        }
    }

    public String getUserAgentStylesheet() {
        return DurationPicker.class.getResource("duration-picker.css").toExternalForm();
    }

    protected Skin<?> createDefaultSkin() {
        return new DurationPickerSkin(this);
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    private void setShowing(boolean showing) {
        this.showing.set(showing);
    }

    public final void show() {
        this.setShowing(true);
    }

    public final void hide() {
        this.setShowing(false);
    }

    public final Callback<Pair<ChronoUnit, ChronoUnit>, Node> getSeparatorFactory() {
        return (Callback)this.separatorFactory.get();
    }

    public ObjectProperty<Callback<Pair<ChronoUnit, ChronoUnit>, Node>> separatorFactoryProperty() {
        return this.separatorFactory;
    }

    public void setSeparatorFactory(Callback<Pair<ChronoUnit, ChronoUnit>, Node> separatorFactory) {
        this.separatorFactory.set(separatorFactory);
    }

    public final Duration getDuration() {
        return (Duration)this.duration.get();
    }

    public final ObjectProperty<Duration> durationProperty() {
        return this.duration;
    }

    public final void setDuration(Duration duration) {
        this.duration.set((Object)duration);
    }

    public final ObservableList<ChronoUnit> getFields() {
        return (ObservableList)this.fields.get();
    }

    public final ListProperty<ChronoUnit> fieldsProperty() {
        return this.fields;
    }

    public final void setFields(ObservableList<ChronoUnit> fields) {
        this.fields.set(fields);
    }

    public final boolean isLinkingFields() {
        return this.linkingFields.get();
    }

    public final BooleanProperty linkingFieldsProperty() {
        return this.linkingFields;
    }

    public final void setLinkingFields(boolean linkingFields) {
        this.linkingFields.set(linkingFields);
    }

    public final boolean isRollover() {
        return this.rollover.get();
    }

    public final BooleanProperty rolloverProperty() {
        return this.rollover;
    }

    public final void setRollover(boolean rollover) {
        this.rollover.set(rollover);
    }

    public final Consumer<DurationPicker> getOnShowPopup() {
        return (Consumer)this.onShowPopup.get();
    }

    public final ObjectProperty<Consumer<DurationPicker>> onShowPopupProperty() {
        return this.onShowPopup;
    }

    public final void setOnShowPopup(Consumer<DurationPicker> onShowPopup) {
        this.onShowPopup.set(onShowPopup);
    }

    public final boolean getShowPopupTriggerButton() {
        return this.showPopupTriggerButton.get();
    }

    public final BooleanProperty showPopupTriggerButtonProperty() {
        return this.showPopupTriggerButton;
    }

    public final void setShowPopupTriggerButton(boolean showPopupTriggerButton) {
        this.showPopupTriggerButton.set(showPopupTriggerButton);
    }

    public final Duration getMinimumDuration() {
        return (Duration)this.minimumDuration.get();
    }

    public final ObjectProperty<Duration> minimumDurationProperty() {
        return this.minimumDuration;
    }

    public final void setMinimumDuration(Duration minimumDuration) {
        this.minimumDuration.set((Object)minimumDuration);
    }

    public final Duration getMaximumDuration() {
        return (Duration)this.maximumDuration.get();
    }

    public final ObjectProperty<Duration> maximumDurationProperty() {
        return this.maximumDuration;
    }

    public final void setMaximumDuration(Duration maximumDuration) {
        this.maximumDuration.set((Object)maximumDuration);
    }

    public final LabelType getLabelType() {
        return (LabelType)((Object)this.labelType.get());
    }

    public final ObjectProperty<LabelType> labelTypeProperty() {
        return this.labelType;
    }

    public final void setLabelType(LabelType labelType) {
        this.labelType.set((Object)labelType);
    }

    public final boolean isFillDigits() {
        return this.fillDigits.get();
    }

    public final BooleanProperty fillDigitsProperty() {
        return this.fillDigits;
    }

    public final void setFillDigits(boolean fillDigits) {
        this.fillDigits.set(fillDigits);
    }

    public static enum LabelType {
        NONE,
        SHORT,
        LONG;

    }
}

