/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.EmailFieldSkin;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.controlsfx.control.textfield.CustomTextField;

public class EmailField
extends Control {
    private static final EmailValidator emailValidator = EmailValidator.getInstance();
    private final CustomTextField editor = new CustomTextField();
    private final BooleanProperty required = new SimpleBooleanProperty((Object)this, "required", false);
    private final StringProperty promptText = new SimpleStringProperty((Object)this, "promptText");
    private final StringProperty emailAddress = new SimpleStringProperty((Object)this, "emailAddress");
    private final ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper((Object)this, "valid");

    public EmailField() {
        this.getStyleClass().add((Object)"email-field");
        this.setFocusTraversable(false);
        this.valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.isRequired()) {
                return emailValidator.isValid(this.getEmailAddress());
            }
            return StringUtils.isBlank((CharSequence)this.getEmailAddress()) || emailValidator.isValid(this.getEmailAddress());
        }, (Observable[])new Observable[]{this.emailAddressProperty(), this.requiredProperty()}));
    }

    protected Skin<?> createDefaultSkin() {
        return new EmailFieldSkin(this);
    }

    public String getUserAgentStylesheet() {
        return EmailField.class.getResource("email-field.css").toExternalForm();
    }

    public final CustomTextField getEditor() {
        return this.editor;
    }

    public final boolean isRequired() {
        return this.required.get();
    }

    public final BooleanProperty requiredProperty() {
        return this.required;
    }

    public final void setRequired(boolean required) {
        this.required.set(required);
    }

    public final String getPromptText() {
        return (String)this.promptText.get();
    }

    public final StringProperty promptTextProperty() {
        return this.promptText;
    }

    public final void setPromptText(String promptText) {
        this.promptText.set((Object)promptText);
    }

    public final String getEmailAddress() {
        return (String)this.emailAddress.get();
    }

    public final StringProperty emailAddressProperty() {
        return this.emailAddress;
    }

    public final void setEmailAddress(String emailAddress) {
        this.emailAddress.set((Object)emailAddress);
    }

    public final boolean isValid() {
        return this.valid.get();
    }

    public final ReadOnlyBooleanProperty validProperty() {
        return this.valid.getReadOnlyProperty();
    }
}

