/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.AutoscrollListView;
import com.dlsc.gemsfx.skins.MultiColumnListViewSkin;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class MultiColumnListView<T>
extends Control {
    private final BooleanProperty showHeaders = new SimpleBooleanProperty((Object)this, "showHeaders", true);
    private final ObjectProperty<Callback<MultiColumnListView<T>, ListView<T>>> listViewFactory = new SimpleObjectProperty((Object)this, "listViewFactory", m -> new AutoscrollListView());
    private final ListProperty<ListViewColumn<T>> columns = new SimpleListProperty((Object)this, "columns", FXCollections.observableArrayList());
    private final ObjectProperty<Callback<MultiColumnListView<T>, ColumnListCell<T>>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory", listView -> new ColumnListCell(listView));
    private final ObjectProperty<Callback<Integer, Node>> separatorFactory = new SimpleObjectProperty((Object)this, "separatorFactory", index -> {
        Region separator = new Region();
        separator.getStyleClass().add((Object)"column-separator");
        return separator;
    });
    private final BooleanProperty disableDragAndDrop = new SimpleBooleanProperty((Object)this, "disableDragAndDrop");
    private final ObjectProperty<T> draggedItem = new SimpleObjectProperty((Object)this, "draggedItem");
    private final ObservableList<T> draggedItems = FXCollections.observableArrayList();
    private final ObjectProperty<T> placeholderFrom = new SimpleObjectProperty((Object)this, "placeholderFrom");
    private final ObjectProperty<T> placeholderTo = new SimpleObjectProperty((Object)this, "placeholderTo");

    public MultiColumnListView() {
        this.getStyleClass().add((Object)"multi-column-list-view");
    }

    protected Skin<?> createDefaultSkin() {
        return new MultiColumnListViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return MultiColumnListView.class.getResource("multi-column-list-view.css").toExternalForm();
    }

    public final boolean isShowHeaders() {
        return this.showHeaders.get();
    }

    public final BooleanProperty showHeadersProperty() {
        return this.showHeaders;
    }

    public final void setShowHeaders(boolean showHeaders) {
        this.showHeaders.set(showHeaders);
    }

    public final Callback<MultiColumnListView<T>, ListView<T>> getListViewFactory() {
        return (Callback)this.listViewFactory.get();
    }

    public final ObjectProperty<Callback<MultiColumnListView<T>, ListView<T>>> listViewFactoryProperty() {
        return this.listViewFactory;
    }

    public final void setListViewFactory(Callback<MultiColumnListView<T>, ListView<T>> listViewFactory) {
        this.listViewFactory.set(listViewFactory);
    }

    public final ObservableList<ListViewColumn<T>> getColumns() {
        return (ObservableList)this.columns.get();
    }

    public final ListProperty<ListViewColumn<T>> columnsProperty() {
        return this.columns;
    }

    public final void setColumns(ObservableList<ListViewColumn<T>> columns) {
        this.columns.set(columns);
    }

    public final Callback<MultiColumnListView<T>, ColumnListCell<T>> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<MultiColumnListView<T>, ColumnListCell<T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final void setCellFactory(Callback<MultiColumnListView<T>, ColumnListCell<T>> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    public final Callback<Integer, Node> getSeparatorFactory() {
        return (Callback)this.separatorFactory.get();
    }

    public final ObjectProperty<Callback<Integer, Node>> separatorFactoryProperty() {
        return this.separatorFactory;
    }

    public final void setSeparatorFactory(Callback<Integer, Node> separatorFactory) {
        this.separatorFactory.set(separatorFactory);
    }

    public final boolean isDisableDragAndDrop() {
        return this.disableDragAndDrop.get();
    }

    public final BooleanProperty disableDragAndDropProperty() {
        return this.disableDragAndDrop;
    }

    public final void setDisableDragAndDrop(boolean disableDragAndDrop) {
        this.disableDragAndDrop.set(disableDragAndDrop);
    }

    public final T getDraggedItem() {
        return (T)this.draggedItem.get();
    }

    public final ObjectProperty<T> draggedItemProperty() {
        return this.draggedItem;
    }

    public final void setDraggedItem(T draggedItem) {
        this.draggedItem.set(draggedItem);
    }

    public final ObservableList<T> getDraggedItems() {
        return this.draggedItems;
    }

    public final T getPlaceholderFrom() {
        return (T)this.placeholderFrom.get();
    }

    public final ObjectProperty<T> placeholderFromProperty() {
        return this.placeholderFrom;
    }

    public final void setPlaceholderFrom(T placeholderFrom) {
        this.placeholderFrom.set(placeholderFrom);
    }

    public final T getPlaceholderTo() {
        return (T)this.placeholderTo.get();
    }

    public final ObjectProperty<T> placeholderToProperty() {
        return this.placeholderTo;
    }

    public final void setPlaceholderTo(T placeholderTo) {
        this.placeholderTo.set(placeholderTo);
    }

    public static class ColumnListCell<T>
    extends ListCell<T> {
        private final MultiColumnListView<T> multiColumnListView;
        private final ReadOnlyBooleanWrapper placeholder = new ReadOnlyBooleanWrapper((Object)this, "placeholder");
        private final ReadOnlyBooleanWrapper fromPlaceholder = new ReadOnlyBooleanWrapper((Object)this, "fromPlaceholder");
        private final ReadOnlyBooleanWrapper toPlaceholder = new ReadOnlyBooleanWrapper((Object)this, "toPlaceholder");

        public ColumnListCell(MultiColumnListView<T> multiColumnListView) {
            this.multiColumnListView = multiColumnListView;
            this.getStyleClass().add((Object)"column-list-cell");
            this.fromPlaceholder.bind((ObservableValue)this.itemProperty().isEqualTo(multiColumnListView.placeholderFromProperty()));
            this.toPlaceholder.bind((ObservableValue)this.itemProperty().isEqualTo(multiColumnListView.placeholderToProperty()));
            this.placeholder.bind((ObservableValue)this.fromPlaceholder.or((ObservableBooleanValue)this.toPlaceholder));
            InvalidationListener updateDraggedPseudoStateListener = it -> this.updateDraggedPseudoState();
            multiColumnListView.draggedItemProperty().addListener(updateDraggedPseudoStateListener);
            this.itemProperty().addListener(updateDraggedPseudoStateListener);
            this.setOnDragDetected(event -> {
                if (multiColumnListView.isDisableDragAndDrop()) {
                    return;
                }
                this.log("drag detected");
                if (this.isEmpty() || this.getItem() == null) {
                    return;
                }
                ClipboardContent content = new ClipboardContent();
                content.putString(Integer.toString(this.getIndex()));
                WritableImage snapshot = this.snapshot(null, null);
                Dragboard dragboard = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                dragboard.setContent((Map)content);
                dragboard.setDragView((Image)snapshot);
                dragboard.setDragViewOffsetX(snapshot.getWidth() / 2.0);
                dragboard.setDragViewOffsetY(-snapshot.getHeight() / 2.0);
                event.consume();
                multiColumnListView.setDraggedItem(this.getItem());
                multiColumnListView.getDraggedItems().setAll((Collection)this.getListView().getSelectionModel().getSelectedItems());
                this.getListView().getItems().replaceAll(item -> {
                    if (item == this.getItem()) {
                        return multiColumnListView.getPlaceholderFrom();
                    }
                    return item;
                });
            });
            this.setOnDragOver(event -> {
                this.log("drag over");
                if (event.getGestureSource() != this && multiColumnListView.getPlaceholderFrom() != this.getItem()) {
                    this.log("   accepting, " + ((Object)((Object)this)).hashCode() + ", txt: " + this.getText());
                    this.updateItems((DragEvent)event);
                    event.consume();
                    event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                } else {
                    this.log("   not accepting drag");
                    event.acceptTransferModes(TransferMode.NONE);
                }
            });
            this.setOnDragEntered(event -> this.log("drag entered"));
            this.setOnDragExited(event -> {
                this.log("drag exited");
                this.getListView().getItems().remove(multiColumnListView.getPlaceholderTo());
            });
            this.setOnDragDropped(event -> {
                this.log("drag dropped");
                if (multiColumnListView.getPlaceholderFrom() == this.getItem()) {
                    this.log("   not performing drop, drop happened on 'from' placeholder");
                    return;
                }
                this.log("   performing drop");
                ListView listView = this.getListView();
                ObservableList items = listView.getItems();
                items.remove(multiColumnListView.getPlaceholderFrom());
                Object draggedItem = multiColumnListView.getDraggedItem();
                items.replaceAll(item -> {
                    if (item == multiColumnListView.getPlaceholderTo()) {
                        return draggedItem;
                    }
                    return item;
                });
                listView.getSelectionModel().select(draggedItem);
                event.setDropCompleted(true);
                event.consume();
            });
            this.setOnDragDone(evt -> {
                this.log("drag done");
                if (Objects.equals(evt.getAcceptedTransferMode(), TransferMode.MOVE)) {
                    this.log("   drop was completed, removing the 'from' placeholder");
                    this.getListView().getItems().removeIf(item -> item == multiColumnListView.getPlaceholderFrom());
                } else {
                    this.log("   drop was not completed, replacing placeholder with dragged item");
                    this.getListView().getItems().replaceAll(item -> {
                        if (item == multiColumnListView.getPlaceholderFrom()) {
                            return multiColumnListView.getDraggedItem();
                        }
                        return item;
                    });
                }
                multiColumnListView.setDraggedItem(null);
                evt.consume();
            });
        }

        public final MultiColumnListView<T> getMultiColumnListView() {
            return this.multiColumnListView;
        }

        private void updateItems(DragEvent event) {
            if (event.getGestureSource() != this) {
                int toIndex = this.getIndex();
                T fromItem = this.multiColumnListView.getPlaceholderFrom();
                T toItem = this.multiColumnListView.getPlaceholderTo();
                int fromIndex = this.getListView().getItems().indexOf(fromItem);
                ObservableList items = this.getListView().getItems();
                this.log("item count: " + items.size());
                items.remove(toItem);
                this.log("item count now: " + items.size());
                if (event.getY() < this.getHeight() / 2.0) {
                    this.log("   attempt to add ABOVE");
                    if (toIndex > 0) {
                        int finalToIndex = Math.min(toIndex, items.size());
                        if (this.notNextToEachOther(fromIndex, finalToIndex)) {
                            this.log("      adding 'to' placeholder at index " + toIndex);
                            items.add(finalToIndex, toItem);
                        }
                    } else if (this.notNextToEachOther(fromIndex, 0)) {
                        this.log("      adding 'to' placeholder at index 0");
                        items.add(0, toItem);
                    }
                } else {
                    this.log("   attempt to add BELOW");
                    if (toIndex < items.size() - 1) {
                        int finalToIndex = toIndex + 1;
                        if (this.notNextToEachOther(fromIndex, finalToIndex)) {
                            this.log("      adding 'to' placeholder at index " + finalToIndex);
                            items.add(finalToIndex, toItem);
                        }
                    } else if (this.notNextToEachOther(fromIndex, items.size() - 1)) {
                        items.add(toItem);
                    }
                }
            }
        }

        private boolean notNextToEachOther(int fromIndex, int toIndex) {
            this.log("from / to index: " + fromIndex + " / " + toIndex);
            if (fromIndex != -1 && toIndex != -1) {
                if (fromIndex < toIndex) {
                    return Math.abs(fromIndex - toIndex) > 1;
                }
                return Math.abs(fromIndex - toIndex) > 0;
            }
            return true;
        }

        private void updateDraggedPseudoState() {
            T from = this.multiColumnListView.getPlaceholderFrom();
            this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"from"), from != null && from == this.getItem());
            T to = this.multiColumnListView.getPlaceholderTo();
            this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"to"), to != null && to == this.getItem());
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            this.updateDraggedPseudoState();
            if (!empty && item != null) {
                if (item == this.multiColumnListView.getPlaceholderFrom()) {
                    this.setText("From");
                } else if (item == this.multiColumnListView.getPlaceholderTo()) {
                    this.setText("To");
                } else {
                    this.setText(item.toString());
                }
            } else {
                this.setText("");
            }
        }

        public final boolean isPlaceholder() {
            return this.placeholder.get();
        }

        public final ReadOnlyBooleanWrapper placeholderProperty() {
            return this.placeholder;
        }

        public final boolean isFromPlaceholder() {
            return this.fromPlaceholder.get();
        }

        public final ReadOnlyBooleanProperty fromPlaceholderProperty() {
            return this.fromPlaceholder.getReadOnlyProperty();
        }

        public final boolean isToPlaceholder() {
            return this.toPlaceholder.get();
        }

        public final ReadOnlyBooleanProperty toPlaceholderProperty() {
            return this.toPlaceholder.getReadOnlyProperty();
        }

        private void log(String text) {
        }
    }

    public static class ListViewColumn<T> {
        private final ListProperty<T> items = new SimpleListProperty((Object)this, "items", FXCollections.observableArrayList());
        private final ObjectProperty<Node> header = new SimpleObjectProperty((Object)this, "header", (Object)new Label("Column Header"));

        public final ObservableList getItems() {
            return (ObservableList)this.items.get();
        }

        public final ListProperty<T> itemsProperty() {
            return this.items;
        }

        public final void setItems(ObservableList items) {
            this.items.set((Object)items);
        }

        public final Node getHeader() {
            return (Node)this.header.get();
        }

        public final ObjectProperty<Node> headerProperty() {
            return this.header;
        }

        public final void setHeader(Node header) {
            this.header.set((Object)header);
        }
    }
}

