/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.PhotoViewSkin;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.MapChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javax.imageio.ImageIO;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class PhotoView
extends Control {
    private final Logger LOG = Logger.getLogger(PhotoView.class.getName());
    private static final PseudoClass EMPTY_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"empty");
    private FileChooser fileChooser;
    public final BooleanProperty createCroppedImage = new SimpleBooleanProperty((Object)this, "createCroppedImage", true);
    private final ReadOnlyObjectWrapper<Image> croppedImage = new ReadOnlyObjectWrapper((Object)this, "croppedImage");
    private final ObjectProperty<Effect> photoEffect = new SimpleObjectProperty((Object)this, "photoEffect");
    private final ObjectProperty<Node> placeholder = new SimpleObjectProperty((Object)this, "placeholder");
    private final BooleanProperty editable = new SimpleBooleanProperty((Object)this, "editable", true);
    private final ObjectProperty<Supplier<Image>> photoSupplier = new SimpleObjectProperty((Object)this, "photoSupplier");
    private final ObjectProperty<ClipShape> clipShape = new SimpleObjectProperty((Object)this, "clipShape", (Object)ClipShape.CIRCLE);
    private final ObjectProperty<Image> photo = new SimpleObjectProperty((Object)this, "image");
    private final DoubleProperty photoZoom = new SimpleDoubleProperty((Object)this, "photoZoom", 1.0);
    private final DoubleProperty photoTranslateX = new SimpleDoubleProperty((Object)this, "photoTranslateX");
    private final DoubleProperty photoTranslateY = new SimpleDoubleProperty((Object)this, "photoTranslateY");
    private final DoubleProperty maxZoom = new SimpleDoubleProperty((Object)this, "maxZoom", 5.0);

    public PhotoView() {
        this.getStyleClass().add((Object)"photo-view");
        this.setFocusTraversable(true);
        this.pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, true);
        this.photo.addListener(it -> {
            this.setPhotoZoom(1.0);
            this.setPhotoTranslateX(0.0);
            this.setPhotoTranslateY(0.0);
            this.requestLayout();
            this.pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, this.getPhoto() == null);
        });
        FontIcon fontIcon = new FontIcon((Ikon)MaterialDesign.MDI_UPLOAD);
        fontIcon.getStyleClass().add((Object)"upload-icon");
        Label placeholder = new Label("DROP IMAGE FILE\nOR CLICK TO ADD");
        placeholder.setTextAlignment(TextAlignment.CENTER);
        placeholder.setGraphic((Node)fontIcon);
        placeholder.setContentDisplay(ContentDisplay.TOP);
        placeholder.getStyleClass().add((Object)"placeholder");
        this.setPlaceholder((Node)placeholder);
        this.getStylesheets().add((Object)PhotoView.class.getResource("photo-view.css").toExternalForm());
        this.setPhotoSupplier(() -> {
            File file;
            if (this.fileChooser == null) {
                this.fileChooser = new FileChooser();
                this.fileChooser.setTitle("Load Image File");
                FileChooser.ExtensionFilter imageFileFilter = new FileChooser.ExtensionFilter("Image Files", new String[]{"*.png", "*.gif", "*.jpg", "*.jpeg"});
                this.fileChooser.getExtensionFilters().add((Object)imageFileFilter);
                this.fileChooser.setSelectedExtensionFilter(imageFileFilter);
            }
            if ((file = this.fileChooser.showOpenDialog(this.getScene().getWindow())) != null) {
                Image image;
                FileInputStream stream = new FileInputStream(file);
                try {
                    image = new Image((InputStream)stream);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.LOG.log(Level.SEVERE, "error when trying to load selected image file", e);
                    }
                }
                stream.close();
                return image;
            }
            return null;
        });
        this.setOnDragOver(evt -> {
            if (this.isEditable()) {
                evt.acceptTransferModes(TransferMode.ANY);
            }
        });
        this.setOnDragDropped(evt -> {
            Dragboard dragboard;
            List files;
            if (this.isEditable() && (files = (dragboard = evt.getDragboard()).getFiles()) != null) {
                try {
                    File file = (File)files.get(0);
                    BufferedImage image = ImageIO.read(file);
                    if (image != null) {
                        this.setPhoto(new Image(file.toURI().toURL().toExternalForm(), true));
                    }
                }
                catch (IOException e) {
                    this.LOG.log(Level.SEVERE, "error when trying to use dropped image file", e);
                }
            }
        });
        this.setOnKeyPressed(evt -> {
            if (this.isEditable()) {
                switch (evt.getCode()) {
                    case BACK_SPACE: 
                    case DELETE: {
                        this.setPhoto(null);
                        break;
                    }
                    case SPACE: 
                    case ENTER: {
                        this.getPhotoSupplier().get();
                    }
                }
            }
        });
        this.setOnMouseClicked(evt -> this.requestFocus());
        MapChangeListener propertiesListener = change -> {
            if (change.wasAdded() && change.getKey().equals("cropped.image")) {
                this.croppedImage.set((Object)((Image)change.getValueAdded()));
            }
        };
        this.getProperties().addListener(propertiesListener);
        this.createCroppedImageProperty().addListener(it -> {
            if (!this.isCreateCroppedImage()) {
                this.croppedImage.set(null);
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new PhotoViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return PhotoView.class.getResource("photo-view.css").toExternalForm();
    }

    public final boolean isCreateCroppedImage() {
        return this.createCroppedImage.get();
    }

    public final BooleanProperty createCroppedImageProperty() {
        return this.createCroppedImage;
    }

    public final void setCreateCroppedImage(boolean createCroppedImage) {
        this.createCroppedImage.set(createCroppedImage);
    }

    public final Image getCroppedImage() {
        return (Image)this.croppedImage.get();
    }

    public final ReadOnlyObjectProperty<Image> croppedImageProperty() {
        return this.croppedImage.getReadOnlyProperty();
    }

    public final Effect getPhotoEffect() {
        return (Effect)this.photoEffect.get();
    }

    public final ObjectProperty<Effect> photoEffectProperty() {
        return this.photoEffect;
    }

    public final void setPhotoEffect(Effect photoEffect) {
        this.photoEffect.set((Object)photoEffect);
    }

    public final Node getPlaceholder() {
        return (Node)this.placeholder.get();
    }

    public final ObjectProperty<Node> placeholderProperty() {
        return this.placeholder;
    }

    public final void setPlaceholder(Node placeholder) {
        this.placeholder.set((Object)placeholder);
    }

    public final boolean isEditable() {
        return this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    public final void setEditable(boolean editable) {
        this.editable.set(editable);
    }

    public Supplier<Image> getPhotoSupplier() {
        return (Supplier)this.photoSupplier.get();
    }

    public ObjectProperty<Supplier<Image>> photoSupplierProperty() {
        return this.photoSupplier;
    }

    public void setPhotoSupplier(Supplier<Image> photoSupplier) {
        this.photoSupplier.set(photoSupplier);
    }

    public ClipShape getClipShape() {
        return (ClipShape)((Object)this.clipShape.get());
    }

    public ObjectProperty<ClipShape> clipShapeProperty() {
        return this.clipShape;
    }

    public void setClipShape(ClipShape clipShape) {
        this.clipShape.set((Object)clipShape);
    }

    public final Image getPhoto() {
        return (Image)this.photo.get();
    }

    public final ObjectProperty<Image> photoProperty() {
        return this.photo;
    }

    public final void setPhoto(Image photo) {
        this.photo.set((Object)photo);
    }

    public final double getPhotoZoom() {
        return this.photoZoom.get();
    }

    public final DoubleProperty photoZoomProperty() {
        return this.photoZoom;
    }

    public final void setPhotoZoom(double photoZoom) {
        this.photoZoom.set(photoZoom);
    }

    public final double getPhotoTranslateX() {
        return this.photoTranslateX.get();
    }

    public final DoubleProperty photoTranslateXProperty() {
        return this.photoTranslateX;
    }

    public final void setPhotoTranslateX(double photoTranslateX) {
        this.photoTranslateX.set(photoTranslateX);
    }

    public final double getPhotoTranslateY() {
        return this.photoTranslateY.get();
    }

    public final DoubleProperty photoTranslateYProperty() {
        return this.photoTranslateY;
    }

    public final void setPhotoTranslateY(double photoTranslateY) {
        this.photoTranslateY.set(photoTranslateY);
    }

    public final double getMaxZoom() {
        return this.maxZoom.get();
    }

    public final DoubleProperty maxZoomProperty() {
        return this.maxZoom;
    }

    public final void setMaxZoom(double maxZoom) {
        this.maxZoom.set(maxZoom);
    }

    public static enum ClipShape {
        CIRCLE,
        RECTANGLE;

    }
}

