/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.YearMonthView;
import com.dlsc.gemsfx.skins.YearMonthPickerSkin;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;

public class YearMonthPicker
extends Control {
    private final TextField editor = new TextField();
    private final ObjectProperty<StringConverter<YearMonth>> converter = new SimpleObjectProperty((Object)this, "value", (Object)new StringConverter<YearMonth>(){

        public String toString(YearMonth object) {
            if (object != null) {
                return DateTimeFormatter.ofPattern("MMMM yyyy").format(object);
            }
            return null;
        }

        public YearMonth fromString(String string) {
            try {
                return DateTimeFormatter.ofPattern("MMMM yyyy").parse((CharSequence)string, YearMonth::from);
            }
            catch (DateTimeParseException ex) {
                return null;
            }
        }
    });
    private final ObjectProperty<YearMonth> value = new SimpleObjectProperty((Object)this, "value", (Object)YearMonth.now());
    private final BooleanProperty editable = new SimpleBooleanProperty((Object)this, "editable", true);

    public YearMonthPicker() {
        this.getStyleClass().addAll((Object[])new String[]{"year-month-picker", "text-input"});
        this.setFocusTraversable(false);
        this.valueProperty().addListener(it -> this.updateText());
        this.editor.setPromptText("Example: March 2023");
        this.editor.editableProperty().bind((ObservableValue)this.editableProperty());
        this.editor.setOnAction(evt -> this.commitValue());
        this.editor.focusedProperty().addListener(it -> {
            if (!this.editor.isFocused()) {
                this.commitValue();
            }
            this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"focused"), this.editor.isFocused());
        });
        this.editor.addEventHandler(KeyEvent.ANY, evt -> {
            if (evt.getCode().equals((Object)KeyCode.DOWN)) {
                this.setValue(this.getValue().plusMonths(1L));
            } else if (evt.getCode().equals((Object)KeyCode.UP)) {
                this.setValue(this.getValue().minusMonths(1L));
            }
        });
        this.converterProperty().addListener((obs, oldConverter, newConverter) -> {
            if (newConverter == null) {
                this.setConverter((StringConverter<YearMonth>)oldConverter);
            }
        });
        this.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.updateText();
    }

    protected Skin<?> createDefaultSkin() {
        return new YearMonthPickerSkin(this);
    }

    public String getUserAgentStylesheet() {
        return YearMonthView.class.getResource("year-month-picker.css").toExternalForm();
    }

    private void commitValue() {
        StringConverter<YearMonth> converter;
        String text = this.editor.getText();
        if (StringUtils.isNotBlank((CharSequence)text) && (converter = this.getConverter()) != null) {
            YearMonth value = (YearMonth)converter.fromString(text);
            if (value != null) {
                this.setValue(value);
            } else {
                this.setValue(null);
            }
        }
    }

    private void updateText() {
        YearMonth value = this.getValue();
        if (value != null && this.getConverter() != null) {
            this.editor.setText(this.getConverter().toString((Object)value));
        } else {
            this.editor.setText("");
        }
        this.editor.positionCaret(this.editor.getText().length());
    }

    public final TextField getEditor() {
        return this.editor;
    }

    public final StringConverter<YearMonth> getConverter() {
        return (StringConverter)this.converter.get();
    }

    public final ObjectProperty<StringConverter<YearMonth>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<YearMonth> converter) {
        this.converter.set(converter);
    }

    public final YearMonth getValue() {
        return (YearMonth)this.value.get();
    }

    public final ObjectProperty<YearMonth> valueProperty() {
        return this.value;
    }

    public final void setValue(YearMonth value) {
        this.value.set((Object)value);
    }

    public final boolean isEditable() {
        return this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    public final void setEditable(boolean editable) {
        this.editable.set(editable);
    }
}

