/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.BeforeAfterView;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class BeforeAfterViewSkin
extends SkinBase<BeforeAfterView> {
    private StackPane content = new StackPane();
    private StackPane divider = new StackPane();
    private StackPane handle = new StackPane();
    private double startX;
    private double startY;

    public BeforeAfterViewSkin(BeforeAfterView view) {
        super((Control)view);
        this.content.getStyleClass().add((Object)"content");
        this.divider.getStyleClass().add((Object)"divider");
        this.divider.setManaged(false);
        this.divider.setMouseTransparent(true);
        this.handle.getStyleClass().add((Object)"handle");
        this.handle.setManaged(false);
        this.handle.getStylesheets().add((Object)BeforeAfterView.class.getResource("before-after-view.css").toExternalForm());
        this.handle.getChildren().add((Object)new FontIcon((Ikon)MaterialDesign.MDI_DRAG));
        this.handle.setMouseTransparent(true);
        view.setOnMousePressed(evt -> {
            this.startX = evt.getX();
            this.startY = evt.getY();
        });
        view.setOnMouseDragged(evt -> {
            if (view.getOrientation().equals((Object)Orientation.HORIZONTAL)) {
                double x = evt.getX();
                double delta = x - this.startX;
                view.setDividerPosition(Math.min(1.0, Math.max(0.0, view.getDividerPosition() + delta / view.getWidth())));
                this.startX = x;
            } else {
                double y = evt.getY();
                double delta = y - this.startY;
                view.setDividerPosition(Math.min(1.0, Math.max(0.0, view.getDividerPosition() + delta / view.getHeight())));
                this.startY = y;
            }
        });
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)view.widthProperty());
        clip.heightProperty().bind((ObservableValue)view.heightProperty());
        this.content.setClip((Node)clip);
        InvalidationListener updateListener = it -> this.updateView();
        view.beforeProperty().addListener(updateListener);
        view.afterProperty().addListener(updateListener);
        view.orientationProperty().addListener(updateListener);
        view.dividerPositionProperty().addListener(it -> view.requestLayout());
        this.getChildren().addAll((Object[])new Node[]{this.content, this.divider, this.handle});
        this.updateView();
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        double dividerPosition = ((BeforeAfterView)this.getSkinnable()).getDividerPosition();
        double dividerPrefWidth = this.divider.prefWidth(-1.0);
        double dividerPrefHeight = this.divider.prefHeight(-1.0);
        double handlePrefWidth = this.handle.prefWidth(-1.0);
        double handlePrefHeight = this.handle.prefHeight(-1.0);
        double my = contentY + contentHeight / 2.0;
        double x = contentX + contentWidth * dividerPosition;
        double y = contentY + contentHeight * dividerPosition;
        if (((BeforeAfterView)this.getSkinnable()).getOrientation().equals((Object)Orientation.HORIZONTAL)) {
            this.divider.resizeRelocate(x - dividerPrefWidth / 2.0, contentY, dividerPrefWidth, contentHeight);
            this.handle.resizeRelocate(x - handlePrefWidth / 2.0, my - handlePrefHeight / 2.0, handlePrefWidth, handlePrefHeight);
        } else {
            this.divider.resizeRelocate(contentX, y - dividerPrefHeight / 2.0, contentWidth, dividerPrefHeight);
            this.handle.resizeRelocate(contentX + contentWidth / 2.0 - handlePrefWidth / 2.0, y - handlePrefHeight / 2.0, handlePrefWidth, handlePrefHeight);
        }
    }

    private void updateView() {
        Node afterNode;
        this.content.getChildren().clear();
        BeforeAfterView view = (BeforeAfterView)this.getSkinnable();
        Node beforeNode = view.getBefore();
        if (beforeNode != null) {
            StackPane wrapper = new StackPane(new Node[]{beforeNode});
            this.content.getChildren().add((Object)wrapper);
            Rectangle clip = new Rectangle();
            if (view.getOrientation().equals((Object)Orientation.HORIZONTAL)) {
                clip.widthProperty().bind((ObservableValue)wrapper.widthProperty().multiply((ObservableNumberValue)view.dividerPositionProperty()));
                clip.heightProperty().bind((ObservableValue)wrapper.heightProperty());
            } else {
                clip.heightProperty().bind((ObservableValue)wrapper.heightProperty().multiply((ObservableNumberValue)view.dividerPositionProperty()));
                clip.widthProperty().bind((ObservableValue)wrapper.widthProperty());
            }
            wrapper.setClip((Node)clip);
        }
        if ((afterNode = view.getAfter()) != null) {
            StackPane wrapper = new StackPane(new Node[]{afterNode});
            this.content.getChildren().add((Object)wrapper);
            Rectangle clip = new Rectangle();
            if (view.getOrientation().equals((Object)Orientation.HORIZONTAL)) {
                clip.xProperty().bind((ObservableValue)wrapper.widthProperty().multiply((ObservableNumberValue)view.dividerPositionProperty()));
                clip.widthProperty().bind((ObservableValue)wrapper.widthProperty().subtract((ObservableNumberValue)wrapper.widthProperty().multiply((ObservableNumberValue)view.dividerPositionProperty())));
                clip.heightProperty().bind((ObservableValue)wrapper.heightProperty());
            } else {
                clip.yProperty().bind((ObservableValue)wrapper.heightProperty().multiply((ObservableNumberValue)view.dividerPositionProperty()));
                clip.heightProperty().bind((ObservableValue)wrapper.heightProperty().subtract((ObservableNumberValue)wrapper.heightProperty().multiply((ObservableNumberValue)view.dividerPositionProperty())));
                clip.widthProperty().bind((ObservableValue)wrapper.widthProperty());
            }
            wrapper.setClip((Node)clip);
        }
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Node afterNode;
        double w = 0.0;
        Node beforeNode = ((BeforeAfterView)this.getSkinnable()).getBefore();
        if (beforeNode != null) {
            w = Math.max(w, beforeNode.prefWidth(-1.0));
        }
        if ((afterNode = ((BeforeAfterView)this.getSkinnable()).getAfter()) != null) {
            w = Math.max(w, afterNode.prefWidth(-1.0));
        }
        return w + rightInset + leftInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }
}

