/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.SearchField;
import com.dlsc.gemsfx.skins.SearchFieldPopup;
import java.util.Optional;
import java.util.Set;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.TextFieldSkin;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;

public class SearchFieldEditorSkin<T>
extends TextFieldSkin {
    private static final PseudoClass HAS_NO_SIDE_NODE = PseudoClass.getPseudoClass((String)"no-side-nodes");
    private static final PseudoClass HAS_LEFT_NODE = PseudoClass.getPseudoClass((String)"left-node-visible");
    private static final PseudoClass HAS_RIGHT_NODE = PseudoClass.getPseudoClass((String)"right-node-visible");
    private final StackPane graphicWrapper = new StackPane();
    private final StackPane searchGraphicWrapper = new StackPane();
    private final Label autoCompletedTextLabel = new Label();
    private final SearchField<T> searchField;
    private Node left;
    private StackPane leftPane;
    private Node right;
    private StackPane rightPane;

    public SearchFieldEditorSkin(SearchField<T> searchField) {
        super(searchField.getEditor());
        this.searchField = searchField;
        this.graphicWrapper.getStyleClass().add((Object)"graphic-wrapper");
        this.graphicWrapper.visibleProperty().bind((ObservableValue)searchField.searchingProperty().not().and((ObservableBooleanValue)searchField.showSearchIconProperty()));
        this.graphicWrapper.setManaged(false);
        this.searchGraphicWrapper.getStyleClass().addAll((Object[])new String[]{"graphic-wrapper", "search-graphic-wrapper"});
        this.searchGraphicWrapper.visibleProperty().bind((ObservableValue)searchField.searchingProperty().and((ObservableBooleanValue)searchField.showSearchIconProperty()));
        this.searchGraphicWrapper.setManaged(false);
        this.setupGraphics();
        searchField.graphicProperty().addListener(it -> this.setupGraphics());
        this.autoCompletedTextLabel.getStyleClass().add((Object)"auto-completion-label");
        this.autoCompletedTextLabel.textProperty().bind((ObservableValue)searchField.autoCompletedTextProperty());
        this.autoCompletedTextLabel.visibleProperty().bind((ObservableValue)searchField.autoCompletedTextProperty().isEmpty().not());
        this.autoCompletedTextLabel.setManaged(false);
        this.autoCompletedTextLabel.setPrefHeight(0.0);
        this.registerChangeListener((ObservableValue)searchField.autoCompletedTextProperty(), it -> ((TextField)this.getSkinnable()).requestLayout());
        this.getChildren().addAll((Object[])new Node[]{this.autoCompletedTextLabel, this.graphicWrapper, this.searchGraphicWrapper});
        SearchFieldPopup<T> autoCompletionPopup = new SearchFieldPopup<T>(searchField);
        autoCompletionPopup.autoHideProperty().bind((ObservableValue)searchField.placeholderProperty().isNull());
        this.registerChangeListener((ObservableValue)searchField.leftProperty(), e -> this.updateChildren());
        this.registerChangeListener((ObservableValue)searchField.rightProperty(), e -> this.updateChildren());
        this.registerChangeListener((ObservableValue)searchField.showSearchIconProperty(), it -> ((TextField)this.getSkinnable()).requestLayout());
        this.updateChildren();
    }

    private void updateChildren() {
        Node newLeft = this.searchField.getLeft();
        this.getChildren().remove((Object)this.leftPane);
        if (newLeft != null) {
            this.leftPane = new StackPane(new Node[]{newLeft});
            this.leftPane.setManaged(false);
            this.leftPane.setAlignment(Pos.CENTER_LEFT);
            this.leftPane.getStyleClass().add((Object)"left-pane");
            this.getChildren().add((Object)this.leftPane);
            this.left = newLeft;
        } else {
            this.leftPane = null;
            this.left = null;
        }
        Node newRight = this.searchField.getRight();
        this.getChildren().remove((Object)this.rightPane);
        if (newRight != null) {
            this.rightPane = new StackPane(new Node[]{newRight});
            this.rightPane.setManaged(false);
            this.rightPane.setAlignment(Pos.CENTER_RIGHT);
            this.rightPane.getStyleClass().add((Object)"right-pane");
            this.getChildren().add((Object)this.rightPane);
            this.right = newRight;
        } else {
            this.rightPane = null;
            this.right = null;
        }
        this.searchField.pseudoClassStateChanged(HAS_LEFT_NODE, this.left != null);
        this.searchField.pseudoClassStateChanged(HAS_RIGHT_NODE, this.right != null);
        this.searchField.pseudoClassStateChanged(HAS_NO_SIDE_NODE, this.left == null && this.right == null);
    }

    private void setupGraphics() {
        this.graphicWrapper.getChildren().clear();
        Node graphic = this.searchField.getGraphic();
        if (graphic != null) {
            this.graphicWrapper.getChildren().setAll((Object[])new Node[]{graphic});
        }
        this.searchGraphicWrapper.getChildren().clear();
        Node searchGraphic = this.searchField.getBusyGraphic();
        if (searchGraphic != null) {
            this.searchGraphicWrapper.getChildren().setAll((Object[])new Node[]{searchGraphic});
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double fullHeight = h + this.snappedTopInset() + this.snappedBottomInset();
        double leftWidth = this.leftPane == null ? 0.0 : this.snapSizeX(this.leftPane.prefWidth(fullHeight));
        double rightWidth = this.rightPane == null ? 0.0 : this.snapSizeX(this.rightPane.prefWidth(fullHeight));
        double textFieldStartX = this.snapPositionX(x) + this.snapSizeX(leftWidth);
        double iconWidthA = 0.0;
        if (this.searchField.isShowSearchIcon()) {
            iconWidthA = this.graphicWrapper.prefWidth(-1.0);
            double iconHeightA = this.graphicWrapper.prefHeight(-1.0);
            this.graphicWrapper.resizeRelocate(x + w - iconWidthA, y + h / 2.0 - iconHeightA / 2.0, iconWidthA, iconHeightA);
        }
        double iconWidthB = 0.0;
        if (this.searchField.isShowSearchIcon()) {
            iconWidthB = this.searchGraphicWrapper.prefWidth(-1.0);
            double iconHeightB = this.searchGraphicWrapper.prefHeight(-1.0);
            this.searchGraphicWrapper.resizeRelocate(x + w - iconWidthB, y + h / 2.0 - iconHeightB / 2.0, iconWidthB, iconHeightB);
        }
        double maxIconWidth = Math.max(iconWidthA, iconWidthB);
        double textFieldWidth = w - this.snapSizeX(leftWidth) - this.snapSizeX(rightWidth) - maxIconWidth;
        super.layoutChildren(textFieldStartX, 0.0, textFieldWidth, fullHeight);
        if (this.leftPane != null) {
            this.leftPane.resizeRelocate(0.0, 0.0, leftWidth, fullHeight);
        }
        if (this.rightPane != null) {
            double rightStartX = w - rightWidth + this.snappedLeftInset() + this.snappedRightInset() - maxIconWidth;
            if (this.searchField.isShowSearchIcon()) {
                rightStartX -= this.snappedRightInset();
            }
            this.rightPane.resizeRelocate(rightStartX, 0.0, rightWidth, fullHeight);
        }
        TextField textField = (TextField)this.getSkinnable();
        double gap = Math.max(0.0, this.searchField.getAutoCompletionGap());
        Node lookup = null;
        Set nodes = textField.lookupAll(".text");
        if (nodes.size() > 2) {
            Optional<Node> lookupOptional = nodes.stream().filter(n -> {
                Text textNode;
                String text;
                if (n instanceof Text && (text = (textNode = (Text)n).getText()) != null) {
                    return !text.equals(textField.getPromptText());
                }
                return false;
            }).findFirst();
            if (lookupOptional.isPresent()) {
                lookup = lookupOptional.get();
            }
        } else {
            lookup = textField.lookup(".text");
        }
        if (lookup == null) {
            return;
        }
        Bounds standardTextBounds = lookup.getLayoutBounds();
        double autoCompleteWidth = this.autoCompletedTextLabel.prefWidth(-1.0);
        double autoCompletionX = textFieldStartX + this.snapSizeX(gap) + standardTextBounds.getWidth();
        this.autoCompletedTextLabel.resizeRelocate(this.snapPositionX(autoCompletionX), y, Math.max(0.0, Math.min(autoCompleteWidth, w - autoCompletionX)), h);
    }
}

