/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.SearchField;
import com.dlsc.gemsfx.skins.SearchFieldPopup;
import java.util.Comparator;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseButton;
import javafx.util.StringConverter;

public class SearchFieldPopupSkin<T>
implements Skin<SearchFieldPopup<T>> {
    private final SearchFieldPopup<T> control;
    private final ListView<T> suggestionList;
    private final SearchField<T> searchField;

    public SearchFieldPopupSkin(SearchFieldPopup<T> control) {
        this.control = control;
        this.searchField = control.getSearchField();
        SortedList sortedList = new SortedList(this.searchField.getSuggestions(), this.createInnerComparator());
        this.suggestionList = new ListView((ObservableList)sortedList);
        this.suggestionList.getStyleClass().add((Object)"search-field-list-view");
        this.suggestionList.getStylesheets().add((Object)SearchField.class.getResource("search-field.css").toExternalForm());
        this.suggestionList.cellFactoryProperty().bind(this.searchField.cellFactoryProperty());
        this.suggestionList.prefWidthProperty().bind((ObservableValue)control.prefWidthProperty());
        this.suggestionList.maxWidthProperty().bind((ObservableValue)control.maxWidthProperty());
        this.suggestionList.minWidthProperty().bind((ObservableValue)control.minWidthProperty());
        this.suggestionList.placeholderProperty().bind(this.searchField.placeholderProperty());
        this.suggestionList.getSelectionModel().selectedItemProperty().addListener(it -> control.getSearchField().setSelectedItem(this.suggestionList.getSelectionModel().getSelectedItem()));
        this.registerEventListener();
    }

    private Comparator<T> createInnerComparator() {
        return (o1, o2) -> {
            Comparator<Object> comparator = this.searchField.getComparator();
            int result = comparator.compare(o1, o2);
            T selectedItem = this.searchField.getSelectedItem();
            if (selectedItem != null) {
                if (o1.equals(selectedItem)) {
                    result = -1;
                }
                if (selectedItem.equals(o2)) {
                    result = 1;
                }
            }
            StringConverter<T> converter = this.searchField.getConverter();
            String searchText = this.searchField.getText().toLowerCase();
            String text1 = converter.toString(o1).toLowerCase();
            String text2 = converter.toString(o2).toLowerCase();
            if (text1.startsWith(searchText) && text2.startsWith(searchText)) {
                return text1.compareTo(text2);
            }
            if (text1.startsWith(searchText)) {
                result = -1;
            }
            if (text2.startsWith(searchText)) {
                result = 1;
            }
            return result;
        };
    }

    private void registerEventListener() {
        this.suggestionList.setOnMouseClicked(me -> {
            if (me.getButton() == MouseButton.PRIMARY) {
                this.selectItem();
            }
        });
        this.suggestionList.setOnKeyPressed(ke -> {
            switch (ke.getCode()) {
                case TAB: 
                case ENTER: {
                    this.selectItem();
                    this.control.hide();
                    break;
                }
                case ESCAPE: {
                    if (!this.control.isHideOnEscape()) break;
                    this.control.hide();
                }
            }
        });
        this.control.getSearchField().getEditor().focusedProperty().addListener((it, oldFocused, newFocused) -> {
            if (!newFocused.booleanValue()) {
                this.control.hide();
            }
        });
    }

    private void selectItem() {
        Object selectedItem = this.suggestionList.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            this.searchField.select(selectedItem);
            this.searchField.commit();
        }
    }

    public Node getNode() {
        return this.suggestionList;
    }

    public SearchFieldPopup<T> getSkinnable() {
        return this.control;
    }

    public void dispose() {
    }
}

