/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.MaskedView;
import com.dlsc.gemsfx.StripView;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class StripViewSkin<T>
extends SkinBase<StripView<T>> {
    private static final String SCROLL_TO_KEY = "scroll.to";
    private final HBox content;
    private final Region leftBtn;
    private final Region rightBtn;
    private final Map<T, Node> nodeMap = new HashMap<T, Node>();
    private final MaskedView maskedView;
    private final BooleanProperty showLeftScroll = new SimpleBooleanProperty(false);
    private final BooleanProperty showRightScroll = new SimpleBooleanProperty(false);
    private Timeline timeline;
    private final DoubleProperty translateX = new SimpleDoubleProperty();

    public StripViewSkin(StripView<T> strip) {
        super(strip);
        this.content = new HBox();
        this.content.getStyleClass().add((Object)"container");
        this.content.setMinWidth(Double.NEGATIVE_INFINITY);
        this.content.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.content.setAlignment(Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)this.content, (Pos)Pos.CENTER_LEFT);
        this.maskedView = new MaskedView((Node)this.content);
        this.maskedView.fadingSizeProperty().bind((ObservableValue)strip.fadingSizeProperty());
        this.leftBtn = new Region();
        this.leftBtn.getStyleClass().addAll((Object[])new String[]{"scroller", "left"});
        this.leftBtn.setOpacity(0.0);
        this.rightBtn = new Region();
        this.rightBtn.getStyleClass().addAll((Object[])new String[]{"scroller", "right"});
        this.rightBtn.setOpacity(0.0);
        this.getChildren().addAll((Object[])new Node[]{this.maskedView, this.leftBtn, this.rightBtn});
        this.getChildren().forEach(child -> child.setManaged(false));
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)strip.widthProperty());
        clip.heightProperty().bind((ObservableValue)strip.heightProperty());
        ((StripView)this.getSkinnable()).setClip((Node)clip);
        this.setupListeners();
        this.setupBindings();
        this.setupEventHandlers();
        strip.itemsProperty().addListener(it -> this.buildContent());
        this.buildContent();
    }

    private void scrollTo(T item) {
        Node node = this.nodeMap.get(item);
        if (node != null) {
            StripView strip = (StripView)this.getSkinnable();
            strip.getProperties().remove((Object)SCROLL_TO_KEY);
            Bounds nodeBounds = node.localToParent(node.getLayoutBounds());
            double x = -nodeBounds.getMinX() + strip.getWidth() / 2.0 - nodeBounds.getWidth() / 2.0;
            double x1 = -this.translateX.get();
            double x2 = x1 + strip.getLayoutBounds().getWidth();
            if (strip.isAlwaysCenter() || x1 > nodeBounds.getMinX() || x2 < nodeBounds.getMaxX()) {
                if (strip.isAnimateScrolling()) {
                    KeyValue keyValue = new KeyValue((WritableValue)this.translateX, (Object)x);
                    KeyFrame keyFrame = new KeyFrame(strip.getAnimationDuration(), new KeyValue[]{keyValue});
                    Timeline timeline = new Timeline(new KeyFrame[]{keyFrame});
                    timeline.play();
                } else {
                    this.translateX.set(x);
                }
            }
        }
    }

    private void buildContent() {
        this.nodeMap.clear();
        StripView strip = (StripView)this.getSkinnable();
        this.content.getChildren().setAll((Collection)strip.getItems().stream().map(item -> {
            StripView.StripCell cell = (StripView.StripCell)((Object)((Object)strip.getCellFactory().call((Object)strip)));
            this.nodeMap.put(item, (Node)cell);
            cell.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
                if (!evt.isConsumed() && evt.getClickCount() == 1 && evt.getButton() == MouseButton.PRIMARY) {
                    boolean wasSelected = item == ((StripView)this.getSkinnable()).getSelectedItem();
                    strip.setSelectedItem(item);
                    strip.scrollTo(item);
                    strip.requestLayout();
                    if (!wasSelected) {
                        evt.consume();
                    }
                }
            });
            cell.setStripView(strip);
            cell.setItem(item);
            return cell;
        }).collect(Collectors.toList()));
        strip.requestLayout();
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.maskedView.prefHeight(width);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.maskedView.minHeight(width);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.maskedView.maxHeight(width);
    }

    private void setupListeners() {
        this.translateX.addListener(it -> this.content.setTranslateX(this.translateX.get()));
        ((StripView)this.getSkinnable()).widthProperty().addListener(it -> this.fixTranslate());
        this.translateX.addListener(it -> this.fixTranslate());
        this.showLeftScroll.addListener((it, oldShow, newShow) -> this.fadeSupport((Boolean)newShow, this.leftBtn));
        this.showRightScroll.addListener((it, oldShow, newShow) -> this.fadeSupport((Boolean)newShow, this.rightBtn));
    }

    private void fadeSupport(Boolean newShow, Region button) {
        if (((StripView)this.getSkinnable()).isAnimateScrolling()) {
            if (newShow.booleanValue()) {
                this.createFadeTransition((Node)button, 0.0, 1.0).play();
            } else {
                this.createFadeTransition((Node)button, 1.0, 0.0).play();
            }
        } else {
            button.setOpacity(newShow != false ? 1.0 : 0.0);
        }
    }

    private FadeTransition createFadeTransition(Node node, double from, double to) {
        node.setOpacity(from);
        FadeTransition faderTransition = new FadeTransition();
        faderTransition.setNode(node);
        faderTransition.setFromValue(from);
        faderTransition.setToValue(to);
        faderTransition.setDuration(Duration.millis((double)200.0));
        return faderTransition;
    }

    private void setupBindings() {
        this.showLeftScroll.bind((ObservableValue)this.translateX.lessThan(0));
        BooleanBinding showRightBinding = Bindings.createBooleanBinding(() -> {
            double stripWidth;
            StripView strip = (StripView)this.getSkinnable();
            double rightX = this.translateX.get() + this.content.getWidth();
            return rightX > (stripWidth = strip.getWidth() - strip.getInsets().getLeft() - strip.getInsets().getRight());
        }, (Observable[])new Observable[]{this.translateX, this.content.widthProperty()});
        this.showRightScroll.bind((ObservableValue)showRightBinding);
    }

    private void setupEventHandlers() {
        this.leftBtn.setOnMouseClicked(event -> this.scroll(true));
        this.rightBtn.setOnMouseClicked(event -> this.scroll(false));
        ((StripView)this.getSkinnable()).addEventFilter(ScrollEvent.SCROLL, evt -> this.translateX.set(this.translateX.get() + evt.getDeltaY()));
    }

    private void fixTranslate() {
        StripView strip = (StripView)this.getSkinnable();
        if (this.content.getWidth() < strip.getWidth()) {
            this.translateX.set(0.0);
        } else {
            double newValue = this.translateX.get();
            newValue = Math.min(newValue, 0.0);
            newValue = Math.max(newValue, -(this.content.getWidth() - (strip.getWidth() - strip.getInsets().getLeft() - strip.getInsets().getRight())));
            this.translateX.set(newValue);
        }
    }

    private void scroll(boolean scrollToRight) {
        double dist;
        if (this.timeline != null && this.timeline.getStatus().equals((Object)Animation.Status.RUNNING)) {
            this.timeline.stop();
        }
        double scrollDistance = ((StripView)this.getSkinnable()).getWidth() / 2.0;
        double d = dist = scrollToRight ? scrollDistance : -scrollDistance;
        if (((StripView)this.getSkinnable()).isAnimateScrolling()) {
            KeyValue keyValue = new KeyValue((WritableValue)this.translateX, (Object)(this.translateX.get() + dist), Interpolator.EASE_BOTH);
            KeyFrame keyFrame = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{keyValue});
            this.timeline = new Timeline(new KeyFrame[]{keyFrame});
            this.timeline.play();
        } else {
            this.translateX.set(this.translateX.get() + dist);
        }
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        this.maskedView.resizeRelocate(contentX, contentY, contentWidth, contentHeight);
        this.leftBtn.resizeRelocate(contentX, contentY + (contentHeight - this.leftBtn.prefHeight(-1.0)) / 2.0, this.leftBtn.prefWidth(-1.0), this.leftBtn.prefHeight(-1.0));
        this.rightBtn.resizeRelocate(contentX + contentWidth - this.rightBtn.prefWidth(-1.0), contentY + (contentHeight - this.rightBtn.prefHeight(-1.0)) / 2.0, this.rightBtn.prefWidth(-1.0), this.rightBtn.prefHeight(-1.0));
        Object item = ((StripView)this.getSkinnable()).getProperties().get((Object)SCROLL_TO_KEY);
        if (item != null) {
            Platform.runLater(() -> this.scrollTo(item));
        }
    }
}

