/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.skins.TimePickerPopup;
import java.time.LocalTime;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.layout.HBox;

public class TimePickerPopupSkin
implements Skin<TimePickerPopup> {
    private final TimePickerPopup popup;
    private final HBox box;
    private final ListView<Integer> hourListView = new ListView();
    private final ListView<Integer> minuteListView = new ListView();

    public TimePickerPopupSkin(TimePickerPopup popup) {
        this.popup = popup;
        this.hourListView.getStyleClass().addAll((Object[])new String[]{"time-list-view", "hour-list"});
        this.hourListView.setCellFactory(view -> new HourCell());
        this.hourListView.getSelectionModel().selectedItemProperty().addListener(it -> {
            Integer newHour = (Integer)this.hourListView.getSelectionModel().getSelectedItem();
            if (newHour != null) {
                LocalTime time = popup.getTime();
                if (time != null) {
                    popup.setTime(LocalTime.of(newHour, time.getMinute()));
                } else {
                    popup.setTime(LocalTime.of(newHour, 0));
                }
            }
        });
        this.minuteListView.getStyleClass().addAll((Object[])new String[]{"time-list-view", "minute-list"});
        this.minuteListView.setCellFactory(view -> new MinuteCell());
        this.minuteListView.getSelectionModel().selectedItemProperty().addListener(it -> {
            Integer newMinute = (Integer)this.minuteListView.getSelectionModel().getSelectedItem();
            if (newMinute != null) {
                LocalTime time = popup.getTime();
                if (time != null) {
                    popup.setTime(LocalTime.of(time.getHour(), newMinute));
                } else {
                    popup.setTime(LocalTime.of(0, newMinute));
                }
            }
        });
        popup.timeProperty().addListener(it -> this.updateListViewSelection());
        this.box = new HBox(new Node[]{this.hourListView, this.minuteListView});
        this.box.getStyleClass().add((Object)"box");
        this.box.setMaxWidth(Double.NEGATIVE_INFINITY);
        InvalidationListener updateListener = it -> this.updateLists();
        popup.clockTypeProperty().addListener(updateListener);
        popup.stepRateInMinutesProperty().addListener(updateListener);
        popup.earliestTimeProperty().addListener(updateListener);
        popup.latestTimeProperty().addListener(updateListener);
        this.updateLists();
        popup.showingProperty().addListener(it -> Platform.runLater(() -> {
            this.updateListViewSelection();
            this.hourListView.scrollTo(this.hourListView.getSelectionModel().getSelectedIndex());
            this.minuteListView.scrollTo(this.minuteListView.getSelectionModel().getSelectedIndex());
        }));
    }

    private void updateListViewSelection() {
        LocalTime time = this.getSkinnable().getTime();
        if (time != null) {
            this.hourListView.getSelectionModel().select((Object)time.getHour());
            this.minuteListView.getSelectionModel().select((Object)time.getMinute());
        } else {
            this.hourListView.getSelectionModel().clearSelection();
            this.minuteListView.getSelectionModel().clearSelection();
        }
    }

    private void updateLists() {
        this.hourListView.getItems().clear();
        this.minuteListView.getItems().clear();
        for (int hour = this.getSkinnable().getEarliestTime().getHour(); hour <= this.getSkinnable().getLatestTime().getHour(); ++hour) {
            this.hourListView.getItems().add((Object)hour);
        }
        for (int minute = 0; minute < 60; minute += this.getSkinnable().getStepRateInMinutes()) {
            this.minuteListView.getItems().add((Object)minute);
        }
    }

    public TimePickerPopup getSkinnable() {
        return this.popup;
    }

    public Node getNode() {
        return this.box;
    }

    public void dispose() {
    }

    private class MinuteCell
    extends TimeCell {
        public MinuteCell() {
            this.getStyleClass().add((Object)"minute-cell");
            this.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                Integer hour = (Integer)TimePickerPopupSkin.this.hourListView.getSelectionModel().getSelectedItem();
                Integer minute = (Integer)this.getItem();
                if (hour != null && minute != null) {
                    LocalTime time = LocalTime.of(hour, minute);
                    return time.isAfter(TimePickerPopupSkin.this.getSkinnable().getLatestTime()) || time.isBefore(TimePickerPopupSkin.this.getSkinnable().getEarliestTime());
                }
                return false;
            }, (Observable[])new Observable[]{TimePickerPopupSkin.this.hourListView.getSelectionModel().selectedItemProperty(), TimePickerPopupSkin.this.getSkinnable().earliestTimeProperty(), TimePickerPopupSkin.this.getSkinnable().latestTimeProperty(), this.itemProperty()}));
        }

        protected void updateItem(Integer item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && item != null) {
                if (item < 10) {
                    this.setText("0" + item);
                } else {
                    this.setText(Integer.toString(item));
                }
            } else {
                this.setText("");
            }
        }
    }

    private static class HourCell
    extends TimeCell {
        public HourCell() {
            this.getStyleClass().add((Object)"hour-cell");
        }

        protected void updateItem(Integer item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && item != null) {
                this.setText(Integer.toString(item));
            } else {
                this.setText("");
            }
        }
    }

    public static abstract class TimeCell
    extends ListCell<Integer> {
        public TimeCell() {
            this.getStyleClass().add((Object)"time-cell");
            Label label = new Label();
            label.getStyleClass().add((Object)"time-label");
            label.visibleProperty().bind((ObservableValue)this.emptyProperty().not());
            label.textProperty().bind((ObservableValue)this.textProperty());
            this.setGraphic((Node)label);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }
    }
}

