/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.YearMonthPicker;
import com.dlsc.gemsfx.YearMonthView;
import com.dlsc.gemsfx.util.Utils;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Skinnable;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.WindowEvent;
import org.kordamp.ikonli.javafx.FontIcon;

public class YearMonthPickerSkin
extends SkinBase<YearMonthPicker> {
    private boolean popupNeedsReconfiguring = true;
    private YearMonthView view;
    private PopupControl popup;

    public YearMonthPickerSkin(YearMonthPicker picker) {
        super((Control)picker);
        picker.setOnMouseClicked(evt -> this.positionAndShowPopup());
        FontIcon calendarIcon = new FontIcon();
        calendarIcon.getStyleClass().add((Object)"edit-icon");
        StackPane editButton = new StackPane(new Node[]{calendarIcon});
        editButton.setFocusTraversable(false);
        editButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        editButton.getStyleClass().add((Object)"edit-button");
        editButton.setOnMouseClicked(evt -> this.positionAndShowPopup());
        HBox.setHgrow((Node)picker.getEditor(), (Priority)Priority.ALWAYS);
        HBox box = new HBox(new Node[]{picker.getEditor(), editButton});
        box.getStyleClass().add((Object)"box");
        this.getChildren().add((Object)box);
    }

    private PopupControl getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    private Node getPopupContent() {
        if (this.view == null) {
            this.view = new YearMonthView();
            this.view.valueProperty().bindBidirectional(((YearMonthPicker)this.getSkinnable()).valueProperty());
            this.view.valueProperty().addListener((obs, oldValue, newValue) -> {
                if (!Objects.equals(oldValue, newValue)) {
                    this.popup.hide();
                }
            });
        }
        return this.view;
    }

    private void positionAndShowPopup() {
        YearMonthPicker picker = (YearMonthPicker)this.getSkinnable();
        if (picker.getScene() == null) {
            return;
        }
        this.getPopup();
        this.popup.getScene().setNodeOrientation(((YearMonthPicker)this.getSkinnable()).getEffectiveNodeOrientation());
        Node popupContent = this.getPopupContent();
        this.sizePopup();
        Point2D p = this.getPrefPopupPosition();
        this.popupNeedsReconfiguring = true;
        this.reconfigurePopup();
        this.popup.show(picker.getScene().getWindow(), this.snapPositionX(p.getX()), this.snapPositionY(p.getY()));
        popupContent.requestFocus();
        this.sizePopup();
    }

    private Point2D getPrefPopupPosition() {
        return Utils.pointRelativeTo((Node)this.getSkinnable(), this.getPopupContent(), HPos.CENTER, VPos.BOTTOM, 0.0, 0.0, true);
    }

    private void sizePopup() {
        Node popupContent = this.getPopupContent();
        if (popupContent instanceof Region) {
            Region r = (Region)popupContent;
            double prefHeight = this.snapSizeY(r.prefHeight(0.0));
            double minHeight = this.snapSizeY(r.minHeight(0.0));
            double maxHeight = this.snapSizeY(r.maxHeight(0.0));
            double h = this.snapSizeY(Math.min(Math.max(prefHeight, minHeight), Math.max(minHeight, maxHeight)));
            double prefWidth = this.snapSizeX(r.prefWidth(h));
            double minWidth = this.snapSizeX(r.minWidth(h));
            double maxWidth = this.snapSizeX(r.maxWidth(h));
            double w = this.snapSizeX(Math.min(Math.max(prefWidth, minWidth), Math.max(minWidth, maxWidth)));
            popupContent.resize(w, h);
        } else {
            popupContent.autosize();
        }
    }

    private void createPopup() {
        this.popup = new PopupControl(){
            {
                this.setSkin((Skin)new Skin<Skinnable>(){

                    public Skinnable getSkinnable() {
                        return this.getSkinnable();
                    }

                    public Node getNode() {
                        return YearMonthPickerSkin.this.getPopupContent();
                    }

                    public void dispose() {
                    }
                });
            }

            public Styleable getStyleableParent() {
                return YearMonthPickerSkin.this.getSkinnable();
            }
        };
        this.popup.setConsumeAutoHidingEvents(false);
        this.popup.setAutoHide(true);
        this.popup.setAutoFix(true);
        this.popup.setHideOnEscape(true);
        this.popup.addEventHandler(WindowEvent.WINDOW_HIDDEN, t -> ((YearMonthPicker)this.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_NODE));
        InvalidationListener layoutPosListener = o -> {
            this.popupNeedsReconfiguring = true;
            this.reconfigurePopup();
        };
        ((YearMonthPicker)this.getSkinnable()).layoutXProperty().addListener(layoutPosListener);
        ((YearMonthPicker)this.getSkinnable()).layoutYProperty().addListener(layoutPosListener);
        ((YearMonthPicker)this.getSkinnable()).widthProperty().addListener(layoutPosListener);
        ((YearMonthPicker)this.getSkinnable()).heightProperty().addListener(layoutPosListener);
        ((YearMonthPicker)this.getSkinnable()).sceneProperty().addListener(o -> {
            if (((ObservableValue)o).getValue() == null) {
                this.popup.hide();
            }
        });
    }

    void reconfigurePopup() {
        double newHeight;
        if (this.popup == null) {
            return;
        }
        boolean isShowing = this.popup.isShowing();
        if (!isShowing) {
            return;
        }
        if (!this.popupNeedsReconfiguring) {
            return;
        }
        this.popupNeedsReconfiguring = false;
        Point2D p = this.getPrefPopupPosition();
        Node popupContent = this.getPopupContent();
        double minWidth = popupContent.prefWidth(-1.0);
        double minHeight = popupContent.prefHeight(-1.0);
        if (p.getX() > -1.0) {
            this.popup.setAnchorX(p.getX());
        }
        if (p.getY() > -1.0) {
            this.popup.setAnchorY(p.getY());
        }
        if (minWidth > -1.0) {
            this.popup.setMinWidth(minWidth);
        }
        if (minHeight > -1.0) {
            this.popup.setMinHeight(minHeight);
        }
        Bounds b = popupContent.getLayoutBounds();
        double currentWidth = b.getWidth();
        double currentHeight = b.getHeight();
        double newWidth = currentWidth < minWidth ? minWidth : currentWidth;
        double d = newHeight = currentHeight < minHeight ? minHeight : currentHeight;
        if (newWidth != currentWidth || newHeight != currentHeight) {
            popupContent.resize(newWidth, newHeight);
            if (popupContent instanceof Region) {
                ((Region)popupContent).setMinSize(newWidth, newHeight);
                ((Region)popupContent).setPrefSize(newWidth, newHeight);
            }
        }
    }
}

