/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.YearMonthView;
import java.time.Month;
import java.time.YearMonth;
import java.time.format.TextStyle;
import java.util.Locale;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class YearMonthViewSkin
extends SkinBase<YearMonthView> {
    private final ObjectProperty<Integer> year = new SimpleObjectProperty((Object)this, "year");

    public YearMonthViewSkin(YearMonthView control) {
        super((Control)control);
        this.year.set((Object)control.getValue().getYear());
        control.valueProperty().addListener(it -> this.year.set((Object)control.getValue().getYear()));
        Label yearLabel = new Label();
        yearLabel.getStyleClass().add((Object)"year-label");
        yearLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Integer.toString((Integer)this.year.get()), (Observable[])new Observable[]{this.year}));
        yearLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        HBox.setHgrow((Node)yearLabel, (Priority)Priority.ALWAYS);
        Region leftArrow = new Region();
        leftArrow.getStyleClass().addAll((Object[])new String[]{"arrow", "left-arrow"});
        Region rightArrow = new Region();
        rightArrow.getStyleClass().addAll((Object[])new String[]{"arrow", "right-arrow"});
        StackPane leftArrowButton = new StackPane(new Node[]{leftArrow});
        leftArrowButton.getStyleClass().addAll((Object[])new String[]{"arrow-button", "left-button"});
        leftArrowButton.setOnMouseClicked(evt -> this.year.set((Object)((Integer)this.year.get() - 1)));
        StackPane rightArrowButton = new StackPane(new Node[]{rightArrow});
        rightArrowButton.getStyleClass().addAll((Object[])new String[]{"arrow-button", "right-button"});
        rightArrowButton.setOnMouseClicked(evt -> this.year.set((Object)((Integer)this.year.get() + 1)));
        HBox header = new HBox(new Node[]{leftArrowButton, yearLabel, rightArrowButton});
        header.getStyleClass().add((Object)"header");
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"grid-pane");
        gridPane.add(this.createMonth(Month.JANUARY), 0, 0);
        gridPane.add(this.createMonth(Month.FEBRUARY), 2, 0);
        gridPane.add(this.createMonth(Month.MARCH), 0, 1);
        gridPane.add(this.createMonth(Month.APRIL), 2, 1);
        gridPane.add(this.createMonth(Month.MAY), 0, 2);
        gridPane.add(this.createMonth(Month.JUNE), 2, 2);
        gridPane.add(this.createMonth(Month.JULY), 0, 3);
        gridPane.add(this.createMonth(Month.AUGUST), 2, 3);
        gridPane.add(this.createMonth(Month.SEPTEMBER), 0, 4);
        gridPane.add(this.createMonth(Month.OCTOBER), 2, 4);
        gridPane.add(this.createMonth(Month.NOVEMBER), 0, 5);
        gridPane.add(this.createMonth(Month.DECEMBER), 2, 5);
        Region divider = new Region();
        divider.getStyleClass().add((Object)"divider");
        gridPane.add((Node)divider, 1, 0);
        GridPane.setRowSpan((Node)divider, (Integer)6);
        ColumnConstraints col1 = new ColumnConstraints();
        ColumnConstraints col2 = new ColumnConstraints();
        ColumnConstraints col3 = new ColumnConstraints();
        col1.setHalignment(HPos.CENTER);
        col1.setHgrow(Priority.ALWAYS);
        col2.setPrefWidth(1.0);
        col2.setMinWidth(1.0);
        col2.setMaxWidth(1.0);
        col3.setHgrow(Priority.ALWAYS);
        col3.setHalignment(HPos.CENTER);
        gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{col1, col2, col3});
        VBox container = new VBox(new Node[]{header, gridPane});
        container.getStyleClass().add((Object)"container");
        header.setViewOrder(Double.NEGATIVE_INFINITY);
        this.getChildren().add((Object)container);
    }

    private Node createMonth(Month month) {
        Label monthLabel = new Label(month.getDisplayName(TextStyle.FULL, Locale.getDefault()).toUpperCase());
        monthLabel.getStyleClass().add((Object)"month-label");
        monthLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        monthLabel.setMaxWidth(Double.NEGATIVE_INFINITY);
        YearMonthView view = (YearMonthView)this.getSkinnable();
        Region selectionIndicator = new Region();
        selectionIndicator.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> view.getValue().equals(YearMonth.of((int)((Integer)this.year.get()), month)), (Observable[])new Observable[]{view.valueProperty(), this.year}));
        selectionIndicator.getStyleClass().add((Object)"selection-indicator");
        VBox box = new VBox(new Node[]{monthLabel, selectionIndicator});
        box.setMaxWidth(Double.NEGATIVE_INFINITY);
        box.setAlignment(Pos.CENTER);
        box.getStyleClass().add((Object)"month-box");
        box.setOnMouseClicked(evt -> view.setValue(YearMonth.of((int)((Integer)this.year.get()), month.getValue())));
        GridPane.setMargin((Node)box, (Insets)new Insets(10.0, 30.0, 10.0, 30.0));
        if (month.equals(Month.JANUARY) || month.equals(Month.FEBRUARY)) {
            GridPane.setMargin((Node)box, (Insets)new Insets(30.0, 30.0, 10.0, 30.0));
        }
        if (month.equals(Month.NOVEMBER) || month.equals(Month.DECEMBER)) {
            GridPane.setMargin((Node)box, (Insets)new Insets(10.0, 30.0, 30.0, 30.0));
        }
        return box;
    }
}

