/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import com.dlsc.gemsfx.util.HttpStatusCode;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.concurrent.Worker;
import retrofit2.Response;

public final class ServiceInvocation<T>
implements Worker<T> {
    private static final Logger LOG = Logger.getLogger(ServiceInvocation.class.getName());
    private static final Executor EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("Service Invocation Thread");
        thread.setDaemon(true);
        thread.setPriority(1);
        return thread;
    });
    private final String name;
    private final ServiceSupplier<T> service;
    private Consumer<String> onStart;
    private Consumer<T> onSuccess;
    private Consumer<Response<T>> onSuccessDetailed;
    private Runnable onFinally;
    private BiConsumer<String, String> onFailure;
    private BiConsumer<String, Response> onFailureDetailed;
    private BiConsumer<String, Exception> onException;
    private BiConsumer<String, String> onFailureDefault;
    private BiConsumer<String, Response> onFailureDetailedDefault;
    private BiConsumer<String, Exception> onExceptionDefault;
    private Map<HttpStatusCode, BiConsumer<String, String>> onStatusCode;
    private Map<HttpStatusCode, BiConsumer<String, String>> onStatusCodeDefault;
    private boolean simulatingFailure;
    private long delay;
    private final ReadOnlyObjectWrapper<Worker.State> state = new ReadOnlyObjectWrapper((Object)this, "state", (Object)Worker.State.READY);
    private final ReadOnlyObjectWrapper<T> value = new ReadOnlyObjectWrapper((Object)this, "value");
    private final ReadOnlyObjectWrapper<Throwable> exception = new ReadOnlyObjectWrapper((Object)this, "exception");
    private final ReadOnlyDoubleWrapper workDone = new ReadOnlyDoubleWrapper((Object)this, "workDone");
    private final ReadOnlyDoubleWrapper totalWork = new ReadOnlyDoubleWrapper((Object)this, "totalWork");
    private final ReadOnlyDoubleWrapper progress = new ReadOnlyDoubleWrapper((Object)this, "progress");
    private final ReadOnlyBooleanWrapper running = new ReadOnlyBooleanWrapper((Object)this, "running");
    private final ReadOnlyStringWrapper message = new ReadOnlyStringWrapper((Object)this, "message");
    private final ReadOnlyStringWrapper title = new ReadOnlyStringWrapper((Object)this, "title");

    private ServiceInvocation(String name, ServiceSupplier<T> service) {
        this.name = Objects.requireNonNull(name, "service invocation name can not be null");
        this.service = Objects.requireNonNull(service, "service can not be null");
        this.title.set(name);
    }

    public static <T> ServiceInvocation<T> create(String name, ServiceSupplier<T> supplier) {
        return new ServiceInvocation<T>(name, supplier);
    }

    private BiConsumer<String, String> getOnFailure() {
        return this.onFailure != null ? this.onFailure : this.onFailureDefault;
    }

    private BiConsumer<String, Response> getOnFailureDetailed() {
        return this.onFailureDetailed != null ? this.onFailureDetailed : this.onFailureDetailedDefault;
    }

    private BiConsumer<String, Exception> getOnException() {
        return this.onException != null ? this.onException : this.onExceptionDefault;
    }

    private BiConsumer<String, String> getOnStatusCode(HttpStatusCode code) {
        BiConsumer<String, String> handler = null;
        if (this.onStatusCode != null) {
            handler = this.onStatusCode.get((Object)code);
        }
        if (handler == null && this.onStatusCodeDefault != null) {
            handler = this.onStatusCodeDefault.get((Object)code);
        }
        return handler;
    }

    public CompletableFuture<Void> execute() {
        return this.execute(EXECUTOR);
    }

    public CompletableFuture<Void> execute(Executor executor) {
        Objects.requireNonNull(executor, "executor can not be null");
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.state.set((Object)Worker.State.RUNNING);
        this.totalWork.set(1.0);
        this.running.set(true);
        this.progress.set(0.0);
        executor.execute(() -> {
            if (this.onStart != null) {
                Platform.runLater(() -> this.onStart.accept(this.getName()));
            }
            LOG.fine("executing service invocation with name: " + this.getName());
            try {
                if (this.delay > 0L) {
                    this.delay();
                }
                Instant startTime = Instant.now();
                Platform.runLater(() -> this.message.set("Calling service"));
                Response<T> response = this.service.get();
                if (LOG.isLoggable(Level.FINE)) {
                    Duration duration = Duration.between(startTime, Instant.now());
                    LOG.fine("server side call duration: " + duration.toMillis() + "ms");
                }
                if (response.isSuccessful() && !this.isSimulatingFailure()) {
                    this.success(response);
                } else {
                    this.failure(response);
                }
                result.complete(null);
            }
            catch (Exception t) {
                this.exception(result, t);
            }
            finally {
                this.doFinally();
            }
        });
        return result;
    }

    private void delay() throws InterruptedException {
        LOG.finer("delaying service call, millis = " + this.delay);
        Thread.sleep(this.delay);
    }

    private void success(Response<T> response) throws ExecutionException, InterruptedException {
        Platform.runLater(() -> {
            this.message.set("Call was successful");
            this.state.set((Object)Worker.State.SUCCEEDED);
        });
        if (this.onSuccess != null) {
            LOG.finer("invoking onSuccess handler");
            this.runAndWait(() -> this.onSuccess.accept(response.body()));
        } else if (this.onSuccessDetailed != null) {
            LOG.finer("invoking onSuccessDetailed handler");
            this.runAndWait(() -> this.onSuccessDetailed.accept(response));
        }
    }

    private void failure(Response<T> response) throws IOException, ExecutionException, InterruptedException {
        BiConsumer<String, String> onFailureHandler;
        BiConsumer<String, String> statusCodeConsumer;
        Platform.runLater(() -> {
            this.message.set("Call was not successful");
            this.state.set((Object)Worker.State.FAILED);
        });
        String errorMessage = this.simulatingFailure ? "Simulated failure" : (response.errorBody() != null ? response.errorBody().string() : "");
        LOG.log(Level.SEVERE, "service call was not successful: " + errorMessage);
        if ((this.onStatusCode != null || this.onStatusCodeDefault != null) && (statusCodeConsumer = this.getOnStatusCode(HttpStatusCode.fromStatusCode(response.code()))) != null) {
            LOG.finer("invoking onStatusCode handler for status code " + response.code());
            Platform.runLater(() -> statusCodeConsumer.accept(this.name, errorMessage));
        }
        if ((onFailureHandler = this.getOnFailure()) != null) {
            this.runAndWait(() -> {
                LOG.finer("invoking onFailure handler");
                onFailureHandler.accept(this.name, errorMessage);
            });
        } else {
            BiConsumer<String, Response> onFailureDetailedHandler = this.getOnFailureDetailed();
            if (onFailureDetailedHandler != null) {
                LOG.finer("invoking onFailureDetailed handler");
                this.runAndWait(() -> this.onFailureDetailed.accept(this.name, response));
            }
        }
    }

    private void exception(CompletableFuture<Void> result, Exception t) {
        LOG.log(Level.SEVERE, "error when trying to invoke the service: " + this.getName(), t);
        Platform.runLater(() -> {
            this.state.set((Object)Worker.State.FAILED);
            this.exception.set((Object)t);
            this.message.set("Server-side error");
        });
        BiConsumer<String, Exception> onExceptionHandler = this.getOnException();
        if (onExceptionHandler != null) {
            try {
                LOG.finer("invoking onException handler");
                this.runAndWait(() -> onExceptionHandler.accept(this.name, t));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "error when trying to propagate error message from service invocation: " + this.getName(), e);
            }
        }
        result.completeExceptionally(t);
    }

    private void doFinally() {
        Platform.runLater(() -> {
            this.running.set(false);
            this.progress.set(1.0);
        });
        if (this.onFinally != null) {
            try {
                LOG.finer("invoking onFinally handler");
                this.runAndWait(this.onFinally);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "error when trying to execute \u2018on finally' of service invocation: " + this.getName(), e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public ServiceInvocation<T> withDelay(long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("delay millis can not be negative but was " + delay);
        }
        this.delay = delay;
        return this;
    }

    public ServiceInvocation<T> withSimulatingFailure(boolean failure) {
        this.simulatingFailure = failure;
        return this;
    }

    public boolean isSimulatingFailure() {
        return this.simulatingFailure;
    }

    public ServiceInvocation<T> onStart(Consumer<String> onStart) {
        this.onStart = onStart;
        return this;
    }

    public ServiceInvocation<T> onSuccess(Consumer<T> onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    public ServiceInvocation<T> onSuccessDetailed(Consumer<Response<T>> onSuccessDetailed) {
        this.onSuccessDetailed = onSuccessDetailed;
        return this;
    }

    public ServiceInvocation<T> onFailure(BiConsumer<String, String> onFailure) {
        this.onFailure = onFailure;
        return this;
    }

    public ServiceInvocation<T> onFailureDefault(BiConsumer<String, String> onFailureDefault) {
        this.onFailureDefault = onFailureDefault;
        return this;
    }

    public ServiceInvocation<T> onFailureDetailed(BiConsumer<String, Response> onFailureDetailed) {
        this.onFailureDetailed = onFailureDetailed;
        return this;
    }

    public ServiceInvocation<T> onFailureDetailedDefault(BiConsumer<String, Response> onFailureDetailedDefault) {
        this.onFailureDetailedDefault = onFailureDetailedDefault;
        return this;
    }

    public ServiceInvocation<T> onStatusCode(HttpStatusCode code, BiConsumer<String, String> onStatusCode) {
        if (this.onStatusCode == null) {
            this.onStatusCode = new HashMap<HttpStatusCode, BiConsumer<String, String>>();
        }
        this.onStatusCode.put(code, onStatusCode);
        return this;
    }

    public ServiceInvocation<T> onStatusCodeDefault(HttpStatusCode code, BiConsumer<String, String> onStatusCodeDefault) {
        if (this.onStatusCodeDefault == null) {
            this.onStatusCodeDefault = new HashMap<HttpStatusCode, BiConsumer<String, String>>();
        }
        this.onStatusCodeDefault.put(code, onStatusCodeDefault);
        return this;
    }

    public ServiceInvocation<T> onException(BiConsumer<String, Exception> onException) {
        this.onException = onException;
        return this;
    }

    public ServiceInvocation<T> onExceptionDefault(BiConsumer<String, Exception> onExceptionDefault) {
        this.onExceptionDefault = onExceptionDefault;
        return this;
    }

    public ServiceInvocation<T> onFinally(Runnable onFinally) {
        this.onFinally = onFinally;
        return this;
    }

    private void runAndWait(Runnable runnable) throws ExecutionException, InterruptedException {
        CompletableFuture result = new CompletableFuture();
        Platform.runLater(() -> {
            try {
                runnable.run();
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        result.get();
    }

    public Worker.State getState() {
        return (Worker.State)this.state.get();
    }

    public ReadOnlyObjectProperty<Worker.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    public T getValue() {
        return (T)this.value.get();
    }

    public ReadOnlyObjectProperty<T> valueProperty() {
        return this.value;
    }

    public Throwable getException() {
        return (Throwable)this.exception.get();
    }

    public ReadOnlyObjectProperty<Throwable> exceptionProperty() {
        return this.exception.getReadOnlyProperty();
    }

    public double getWorkDone() {
        return this.workDone.get();
    }

    public ReadOnlyDoubleProperty workDoneProperty() {
        return this.workDone.getReadOnlyProperty();
    }

    public double getTotalWork() {
        return this.totalWork.get();
    }

    public ReadOnlyDoubleProperty totalWorkProperty() {
        return this.totalWork;
    }

    public double getProgress() {
        return this.progress.get();
    }

    public ReadOnlyDoubleProperty progressProperty() {
        return this.progress.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty runningProperty() {
        return this.running.getReadOnlyProperty();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public String getMessage() {
        return this.message.get();
    }

    public ReadOnlyStringProperty messageProperty() {
        return this.message;
    }

    public String getTitle() {
        return this.title.get();
    }

    public ReadOnlyStringProperty titleProperty() {
        return this.title;
    }

    public boolean cancel() {
        throw new UnsupportedOperationException();
    }

    @FunctionalInterface
    public static interface ServiceSupplier<T> {
        public Response<T> get() throws Exception;
    }
}

