/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.spi.DataRange;
import java.security.InvalidParameterException;
import java.util.Objects;

public class AxisRange
extends DataRange {
    protected double axisLength;
    protected double scale = 1.0;
    protected double tickUnit;

    public AxisRange() {
        this(Double.NaN, Double.NaN, 1.0, 1.0, 0.1);
    }

    public AxisRange(AxisRange other) {
        this(other.getMin(), other.getMax(), other.getAxisLength(), other.getScale(), other.getTickUnit());
    }

    public AxisRange(double lowerBound, double upperBound, double axisLength, double scale, double tickUnit) {
        super(lowerBound, upperBound);
        if (scale == 0.0) {
            throw new InvalidParameterException("scale should not be '0'");
        }
        if (tickUnit <= 0.0) {
            throw new InvalidParameterException("tickUnit should not be <='0'");
        }
        this.axisLength = axisLength;
        this.scale = scale;
        this.tickUnit = tickUnit;
    }

    public boolean add(AxisRange range) {
        boolean retVal = false;
        if (this.add(range.min)) {
            retVal = true;
        }
        if (this.add(range.max)) {
            retVal = true;
        }
        return retVal;
    }

    public AxisRange copy() {
        return new AxisRange(this.getLowerBound(), this.getUpperBound(), this.getAxisLength(), this.getScale(), this.getTickUnit());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AxisRange)) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }

    public double getAxisLength() {
        return this.axisLength;
    }

    public double getLowerBound() {
        return this.min;
    }

    public double getScale() {
        return this.scale;
    }

    public double getTickUnit() {
        return this.tickUnit;
    }

    public double getUpperBound() {
        return this.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.axisLength, this.scale, this.tickUnit);
    }

    public void setAxisLength(double length, Side side) {
        if (length == 0.0) {
            throw new InvalidParameterException("length should not be '0'");
        }
        this.axisLength = length;
        double newScale = 1.0;
        double diff = this.max - this.min;
        newScale = side.isVertical() ? (diff == 0.0 ? -length : -(length / diff)) : (diff == 0.0 ? length : length / diff);
        this.scale = newScale;
        this.tickUnit = diff / 10.0;
    }

    public String toString() {
        return String.format("AxisRange [min=%f, max=%f, axisLength=%f, scale=%f, tickUnit=%f]", this.min, this.max, this.axisLength, this.scale, this.tickUnit);
    }
}

