/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.axes.AxisTransform;
import de.gsi.chart.axes.LogAxisType;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.AbstractAxis;
import de.gsi.chart.axes.spi.AbstractAxisParameter;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.format.DefaultTickUnitSupplier;
import de.gsi.chart.ui.css.CssPropertyFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;

public final class NumericAxis
extends AbstractAxis {
    private static final CssPropertyFactory<NumericAxis> CSS = new CssPropertyFactory(AbstractAxisParameter.getClassCssMetaData());
    private static final int TICK_MARK_GAP = 6;
    private static final double NEXT_TICK_UNIT_FACTOR = 1.01;
    private static final int MAX_TICK_COUNT = 20;
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private static final int DEFAULT_RANGE_LENGTH = 2;
    private static final double DEFAULT_RANGE_PADDING = 0.1;
    private double localScale;
    private double localCurrentLowerBound;
    private double localOffset;
    private final BooleanProperty forceZeroInRange = new SimpleBooleanProperty(this, "forceZeroInRange", true){

        protected void invalidated() {
            if (NumericAxis.this.isAutoRanging()) {
                NumericAxis.this.invalidate();
                NumericAxis.this.requestAxisLayout();
            }
        }
    };
    private final DoubleProperty autoRangePadding = new SimpleDoubleProperty(0.0);
    private final StyleableDoubleProperty tickUnit = CSS.createDoubleProperty(this, "tickUnit", 5.0, () -> {
        if (!this.isAutoRanging()) {
            this.invalidate();
            this.requestAxisLayout();
        }
    });
    private final ObjectProperty<TickUnitSupplier> tickUnitSupplier = new SimpleObjectProperty((Object)this, "tickUnitSupplier", (Object)DEFAULT_TICK_UNIT_SUPPLIER);

    public NumericAxis() {
        super.minProperty().addListener((evt, o, n) -> {
            this.localCurrentLowerBound = n.doubleValue();
            double zero = super.getDisplayPosition(0.0);
            this.localOffset = zero + this.localCurrentLowerBound * this.scaleProperty().get();
        });
        super.scaleProperty().addListener((evt, o, n) -> {
            this.localScale = n.doubleValue();
            double zero = super.getDisplayPosition(0.0);
            this.localOffset = zero + this.getMin() * this.localScale;
        });
    }

    public NumericAxis(double lowerBound, double upperBound, double tickUnit) {
        this(null, lowerBound, upperBound, tickUnit);
    }

    public NumericAxis(String axisLabel, double lowerBound, double upperBound, double tickUnit) {
        super(lowerBound, upperBound);
        this.setName(axisLabel);
        this.setTickUnit(tickUnit);
        super.minProperty().addListener((evt, o, n) -> {
            this.localCurrentLowerBound = n.doubleValue();
            double zero = super.getDisplayPosition(0.0);
            this.localOffset = zero + this.localCurrentLowerBound * this.scaleProperty().get();
        });
        super.scaleProperty().addListener((evt, o, n) -> {
            this.localScale = n.doubleValue();
            double zero = super.getDisplayPosition(0.0);
            this.localOffset = zero + this.getMin() * this.localScale;
        });
    }

    @Override
    public DoubleProperty autoRangePaddingProperty() {
        return this.autoRangePadding;
    }

    @Override
    public double computePreferredTickUnit(double axisLength) {
        int ticksCount;
        double reqLength;
        double labelSize = this.getTickLabelFont().getSize() * 2.0;
        int numOfFittingLabels = (int)Math.floor(axisLength / labelSize);
        int numOfTickMarks = Math.max(Math.min(numOfFittingLabels, 20), 2);
        double max = this.maxProperty().get();
        double min = this.minProperty().get();
        double rawTickUnit = (max - min) / (double)numOfTickMarks;
        double tickUnitRounded = Double.MIN_VALUE;
        double minRounded = min;
        double maxRounded = max;
        do {
            double firstMajorTick;
            if (Double.isNaN(rawTickUnit)) {
                throw new IllegalArgumentException("Can't calculate axis range: data contains NaN value");
            }
            double prevTickUnitRounded = tickUnitRounded;
            tickUnitRounded = this.computeTickUnit(rawTickUnit);
            if (tickUnitRounded <= prevTickUnitRounded) break;
            if ((this.isAutoRanging() || this.isAutoGrowRanging()) && this.isAutoRangeRounding()) {
                minRounded = Math.floor(min / tickUnitRounded) * tickUnitRounded;
                maxRounded = Math.ceil(max / tickUnitRounded) * tickUnitRounded;
                firstMajorTick = minRounded;
            } else {
                firstMajorTick = Math.ceil(min / tickUnitRounded) * tickUnitRounded;
            }
            ticksCount = 0;
            double maxReqTickGap = 0.0;
            double halfOfLastTickSize = 0.0;
            double major = firstMajorTick;
            while (major <= maxRounded) {
                double tickMarkSize = this.measureTickMarkLength(major);
                if (major == firstMajorTick) {
                    halfOfLastTickSize = tickMarkSize / 2.0;
                } else {
                    maxReqTickGap = Math.max(maxReqTickGap, halfOfLastTickSize + 6.0 + tickMarkSize / 2.0);
                }
                major += tickUnitRounded;
                ++ticksCount;
            }
            reqLength = (double)(ticksCount - 1) * maxReqTickGap;
            rawTickUnit = tickUnitRounded * 1.01;
        } while (numOfTickMarks > 2 && (reqLength > axisLength || ticksCount > 20));
        return tickUnitRounded;
    }

    public BooleanProperty forceZeroInRangeProperty() {
        return this.forceZeroInRange;
    }

    @Override
    public double getAutoRangePadding() {
        return this.autoRangePaddingProperty().get();
    }

    @Override
    public AxisTransform getAxisTransform() {
        return null;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return NumericAxis.getClassCssMetaData();
    }

    @Override
    public double getDisplayPosition(double value) {
        return this.localOffset + (value - this.localCurrentLowerBound) * this.localScale;
    }

    @Override
    public LogAxisType getLogAxisType() {
        return LogAxisType.LINEAR_SCALE;
    }

    @Override
    public double getTickUnit() {
        return this.tickUnitProperty().get();
    }

    public TickUnitSupplier getTickUnitSupplier() {
        return (TickUnitSupplier)this.tickUnitSupplierProperty().get();
    }

    @Override
    public double getValueForDisplay(double displayPosition) {
        return (displayPosition - this.localOffset) / this.localScale + this.localCurrentLowerBound;
    }

    @Override
    public double getZeroPosition() {
        if (0.0 < this.getMin() || 0.0 > this.getMax()) {
            return Double.NaN;
        }
        return this.getDisplayPosition(0.0);
    }

    public boolean isForceZeroInRange() {
        return this.forceZeroInRange.getValue();
    }

    @Override
    public boolean isLogAxis() {
        return false;
    }

    @Override
    public boolean isValueOnAxis(double value) {
        return value >= this.getMin() && value <= this.getMax();
    }

    @Override
    public void setAutoRangePadding(double padding) {
        this.autoRangePaddingProperty().set(padding);
    }

    public void setForceZeroInRange(boolean value) {
        this.forceZeroInRange.setValue(Boolean.valueOf(value));
    }

    @Override
    public void setTickUnit(double unit) {
        this.tickUnitProperty().set(unit);
    }

    public void setTickUnitSupplier(TickUnitSupplier supplier) {
        this.tickUnitSupplierProperty().set((Object)supplier);
    }

    @Override
    public DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    public ObjectProperty<TickUnitSupplier> tickUnitSupplierProperty() {
        return this.tickUnitSupplier;
    }

    private AxisRange computeRangeImpl(double min, double max, double axisLength, double labelSize) {
        int ticksCount;
        double reqLength;
        int numOfFittingLabels = (int)Math.floor(axisLength / labelSize);
        int numOfTickMarks = Math.max(Math.min(numOfFittingLabels, 20), 2);
        double rawTickUnit = (max - min) / (double)numOfTickMarks;
        double tickUnitRounded = Double.MIN_VALUE;
        double minRounded = min;
        double maxRounded = max;
        do {
            double firstMajorTick;
            if (Double.isNaN(rawTickUnit)) {
                throw new IllegalArgumentException("Can't calculate axis range: data contains NaN value");
            }
            double prevTickUnitRounded = tickUnitRounded;
            tickUnitRounded = this.computeTickUnit(rawTickUnit);
            if (tickUnitRounded <= prevTickUnitRounded) break;
            if (this.isAutoRanging() && this.isAutoRangeRounding()) {
                minRounded = Math.floor(min / tickUnitRounded) * tickUnitRounded;
                maxRounded = Math.ceil(max / tickUnitRounded) * tickUnitRounded;
                firstMajorTick = minRounded;
            } else {
                firstMajorTick = Math.ceil(min / tickUnitRounded) * tickUnitRounded;
            }
            ticksCount = 0;
            double maxReqTickGap = 0.0;
            double halfOfLastTickSize = 0.0;
            double major = firstMajorTick;
            while (major <= maxRounded) {
                double tickMarkSize = this.measureTickMarkLength(major);
                if (major == firstMajorTick) {
                    halfOfLastTickSize = tickMarkSize / 2.0;
                } else {
                    maxReqTickGap = Math.max(maxReqTickGap, halfOfLastTickSize + 6.0 + tickMarkSize / 2.0);
                }
                major += tickUnitRounded;
                ++ticksCount;
            }
            reqLength = (double)(ticksCount - 1) * maxReqTickGap;
            rawTickUnit = tickUnitRounded * 1.01;
        } while (numOfTickMarks > 2 && (reqLength > axisLength || ticksCount > 20));
        double newScale = this.calculateNewScale(axisLength, minRounded, maxRounded);
        return new AxisRange(minRounded, maxRounded, axisLength, newScale, tickUnitRounded);
    }

    private double computeTickUnit(double rawTickUnit) {
        double majorUnit;
        TickUnitSupplier unitSupplier = this.getTickUnitSupplier();
        if (unitSupplier == null) {
            unitSupplier = DEFAULT_TICK_UNIT_SUPPLIER;
        }
        if ((majorUnit = unitSupplier.computeTickUnit(rawTickUnit)) <= 0.0) {
            throw new IllegalArgumentException("The " + unitSupplier.getClass().getName() + " computed illegal unit value [" + majorUnit + "] for argument " + rawTickUnit);
        }
        return majorUnit;
    }

    @Override
    protected AxisRange autoRange(double minValue, double maxValue, double length, double labelSize) {
        double min = minValue > 0.0 && this.isForceZeroInRange() ? 0.0 : minValue;
        double max = maxValue < 0.0 && this.isForceZeroInRange() ? 0.0 : maxValue;
        double padding = NumericAxis.getEffectiveRange(min, max) * this.getAutoRangePadding();
        double paddedMin = NumericAxis.clampBoundToZero(min - padding, min);
        double paddedMax = NumericAxis.clampBoundToZero(max + padding, max);
        return this.computeRange(paddedMin, paddedMax, length, labelSize);
    }

    @Override
    protected List<Double> calculateMajorTickValues(double axisLength, AxisRange range) {
        double firstTick;
        if (range.getLowerBound() == range.getUpperBound() || range.getTickUnit() <= 0.0) {
            return Collections.singletonList(range.getLowerBound());
        }
        ArrayList<Double> tickValues = new ArrayList<Double>();
        for (double major = firstTick = NumericAxis.computeFistMajorTick(range.getLowerBound(), range.getTickUnit()); major <= range.getUpperBound(); major += range.getTickUnit()) {
            tickValues.add(major);
        }
        return tickValues;
    }

    @Override
    protected List<Double> calculateMinorTickValues() {
        if (this.getMinorTickCount() == 0 || this.getTickUnit() == 0.0) {
            return Collections.emptyList();
        }
        ArrayList<Double> minorTickMarks = new ArrayList<Double>();
        double lowerBound = this.getMin();
        double upperBound = this.getMax();
        double majorUnit = this.getTickUnit();
        double firstMajorTick = NumericAxis.computeFistMajorTick(lowerBound, majorUnit);
        double minorUnit = majorUnit / (double)this.getMinorTickCount();
        for (double majorTick = firstMajorTick - majorUnit; majorTick < upperBound; majorTick += majorUnit) {
            double nextMajorTick = majorTick + majorUnit;
            for (double minorTick = majorTick + minorUnit; minorTick < nextMajorTick; minorTick += minorUnit) {
                if (!(minorTick >= lowerBound) || !(minorTick <= upperBound)) continue;
                minorTickMarks.add(minorTick);
            }
        }
        return minorTickMarks;
    }

    @Override
    protected AxisRange computeRange(double min, double max, double axisLength, double labelSize) {
        double minValue = min;
        double maxValue = max;
        if (max - min == 0.0) {
            double padding = this.getAutoRangePadding() == 0.0 ? 0.1 : this.getAutoRangePadding();
            double paddedRange = NumericAxis.getEffectiveRange(min, max) * padding;
            minValue = min - paddedRange / 2.0;
            maxValue = max + paddedRange / 2.0;
        }
        return this.computeRangeImpl(minValue, maxValue, axisLength, labelSize);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS.getCssMetaData();
    }

    private static double clampBoundToZero(double paddedBound, double bound) {
        if (paddedBound < 0.0 && bound >= 0.0 || paddedBound > 0.0 && bound <= 0.0) {
            return 0.0;
        }
        return paddedBound;
    }

    private static double computeFistMajorTick(double lowerBound, double tickUnit) {
        return Math.ceil(lowerBound / tickUnit) * tickUnit;
    }

    private static double getEffectiveRange(double min, double max) {
        double effectiveRange = max - min;
        if (effectiveRange == 0.0) {
            effectiveRange = min == 0.0 ? 2.0 : Math.abs(min);
        }
        return effectiveRange;
    }
}

