/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisTransform;
import de.gsi.chart.axes.LogAxisType;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.AbstractAxis;
import de.gsi.chart.axes.spi.AbstractAxisParameter;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.format.DefaultTickUnitSupplier;
import de.gsi.chart.axes.spi.transforms.DefaultAxisTransform;
import de.gsi.chart.ui.css.CssPropertyFactory;
import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.spi.DataRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.beans.property.DoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OscilloscopeAxis
extends AbstractAxis
implements Axis {
    private static final Logger LOGGER = LoggerFactory.getLogger(OscilloscopeAxis.class);
    private static final CssPropertyFactory<OscilloscopeAxis> CSS = new CssPropertyFactory(AbstractAxisParameter.getClassCssMetaData());
    private static final int DEFAULT_RANGE_LENGTH = 1;
    private static final int TICK_COUNT = 10;
    public static final SortedSet<Number> DEFAULT_MULTIPLIERS1 = Collections.unmodifiableSortedSet(new TreeSet<Double>(Arrays.asList(1.0, 2.0, 5.0)));
    public static final SortedSet<Number> DEFAULT_MULTIPLIERS2 = Collections.unmodifiableSortedSet(new TreeSet<Double>(Arrays.asList(1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5)));
    private final transient DefaultAxisTransform axisTransform = new DefaultAxisTransform(this);
    private transient TickUnitSupplier tickUnitSupplier = new DefaultTickUnitSupplier(DEFAULT_MULTIPLIERS1);
    private final transient DataRange clampedRange = new DataRange();
    private final transient DataRange minRange = new DataRange();
    private final transient DataRange maxRange = new DataRange();
    private final StyleableDoubleProperty axisZeroPosition = CSS.createDoubleProperty(this, "axisZeroPosition", 0.5, true, (oldVal, newVal) -> Math.max(0.0, Math.min(newVal, 1.0)), this::requestAxisLayout);
    private final StyleableDoubleProperty axisZeroValue = CSS.createDoubleProperty(this, "axisZeroValue", 0.0, true, null, this::requestAxisLayout);
    private final transient Cache cache = new Cache();
    protected boolean isUpdating;

    public OscilloscopeAxis(String axisLabel) {
        this(axisLabel, 0.0, 0.0, 5.0);
    }

    public OscilloscopeAxis(String axisLabel, double lowerBound, double upperBound, double tickUnit) {
        super(lowerBound, upperBound);
        this.setName(axisLabel);
        if (lowerBound >= upperBound) {
            this.setAutoRanging(true);
        }
        this.setTickUnit(tickUnit);
        this.setMinorTickCount(10);
        this.isUpdating = false;
    }

    public OscilloscopeAxis(String axisLabel, String unit) {
        this(axisLabel, 0.0, 0.0, 5.0);
        this.setUnit(unit);
    }

    public DoubleProperty axisZeroValueProperty() {
        return this.axisZeroValue;
    }

    public DoubleProperty centerAxisZeroPositionProperty() {
        return this.axisZeroPosition;
    }

    @Override
    public double computePreferredTickUnit(double axisLength) {
        double rawTickUnit;
        DataRange clamped = this.getClampedRange();
        double centre = this.getAxisZeroValue();
        double relCentre = this.getAxisZeroPosition();
        if (relCentre == 0.0) {
            rawTickUnit = OscilloscopeAxis.getEffectiveRange(centre, clamped.getMax()) / 10.0;
        } else if (relCentre == 1.0) {
            rawTickUnit = OscilloscopeAxis.getEffectiveRange(clamped.getMin(), centre) / 10.0;
        } else {
            double relTickCount1 = relCentre * 10.0;
            double relTickCount2 = (1.0 - relCentre) * 10.0;
            double rawTickUnit1 = OscilloscopeAxis.getEffectiveRange(clamped.getMin(), centre) / relTickCount1;
            double rawTickUnit2 = OscilloscopeAxis.getEffectiveRange(centre, clamped.getMax()) / relTickCount2;
            rawTickUnit = Math.max(rawTickUnit1, rawTickUnit2);
        }
        return this.tickUnitSupplier.computeTickUnit(rawTickUnit);
    }

    @Override
    public AxisTransform getAxisTransform() {
        return this.axisTransform;
    }

    public double getAxisZeroPosition() {
        return this.centerAxisZeroPositionProperty().get();
    }

    public double getAxisZeroValue() {
        return this.axisZeroValueProperty().get();
    }

    public DataRange getClampedRange() {
        this.recomputeClampedRange();
        return this.clampedRange;
    }

    @Override
    public LogAxisType getLogAxisType() {
        return LogAxisType.LINEAR_SCALE;
    }

    public DataRange getMaxRange() {
        return this.maxRange;
    }

    public DataRange getMinRange() {
        return this.minRange;
    }

    public TickUnitSupplier getTickUnitSupplier() {
        return this.tickUnitSupplier;
    }

    @Override
    public double getValueForDisplay(double displayPosition) {
        if (this.isInvertedAxis) {
            return this.cache.localCurrentLowerBound + (this.cache.offset - displayPosition - this.cache.localOffset) / this.cache.localScale;
        }
        return this.cache.localCurrentLowerBound + (displayPosition - this.cache.localOffset) / this.cache.localScale;
    }

    @Override
    public boolean isLogAxis() {
        return false;
    }

    public void setAxisZeroPosition(double value) {
        this.centerAxisZeroPositionProperty().set(value);
    }

    public void setAxisZeroValue(double value) {
        this.axisZeroValueProperty().set(value);
    }

    public void setTickUnitSupplier(TickUnitSupplier tickUnitSupplier) {
        this.tickUnitSupplier = tickUnitSupplier;
        this.invalidate();
    }

    @Override
    protected List<Double> calculateMajorTickValues(double length, AxisRange axisRange) {
        ArrayList<Double> tickValues = new ArrayList<Double>();
        if (axisRange.getMin() == axisRange.getMax() || axisRange.getTickUnit() <= 0.0) {
            return Collections.singletonList(axisRange.getMin());
        }
        double firstTick = Math.ceil(axisRange.getMin() / axisRange.getTickUnit()) * axisRange.getTickUnit();
        if (firstTick + axisRange.getTickUnit() == firstTick) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log("major ticks numerically not resolvable");
            }
            return tickValues;
        }
        int maxTickCount = this.getMaxMajorTickLabelCount();
        for (double major = firstTick; major <= axisRange.getMax() && tickValues.size() <= maxTickCount; major += axisRange.getTickUnit()) {
            tickValues.add(major);
        }
        return tickValues;
    }

    @Override
    protected List<Double> calculateMinorTickValues() {
        if (this.getMinorTickCount() <= 0 || this.getTickUnit() <= 0.0) {
            return Collections.emptyList();
        }
        ArrayList<Double> newMinorTickMarks = new ArrayList<Double>();
        double lowerBound = this.getMin();
        double upperBound = this.getMax();
        double majorUnit = this.getTickUnit();
        double firstMajorTick = Math.ceil(lowerBound / majorUnit) * majorUnit;
        double minorUnit = majorUnit / (double)this.getMinorTickCount();
        int maxTickCount = this.getMaxMajorTickLabelCount();
        int maxMinorTickCount = this.getMaxMajorTickLabelCount() * this.getMinorTickCount();
        int majorTickCount = 0;
        for (double majorTick = firstMajorTick - majorUnit; majorTick < upperBound && majorTickCount < maxTickCount && majorTick + majorUnit != majorTick; ++majorTickCount, majorTick += majorUnit) {
            double nextMajorTick = majorTick + majorUnit;
            for (double minorTick = majorTick + minorUnit; minorTick < nextMajorTick && newMinorTickMarks.size() < maxMinorTickCount && minorTick != majorTick; minorTick += minorUnit) {
                if (!(minorTick >= lowerBound) || !(minorTick <= upperBound)) continue;
                newMinorTickMarks.add(minorTick);
            }
        }
        return newMinorTickMarks;
    }

    @Override
    public boolean set(double min, double max) {
        if (this.cache == null) {
            return super.set(min, max);
        }
        AxisRange range = this.computeRange(min, max, this.getLength(), 0.0);
        return super.set(range.getMin(), range.getMax());
    }

    public boolean set(AxisDescription range) {
        return false;
    }

    @Override
    public boolean set(String axisName, String axisUnit, double rangeMin, double rangeMax) {
        if (this.cache == null) {
            return super.set(axisName, axisUnit, rangeMin, rangeMax);
        }
        AxisRange range = this.computeRange(rangeMin, rangeMax, this.getLength(), 0.0);
        return super.set(axisName, axisUnit, range.getMin(), range.getMax());
    }

    @Override
    public boolean setMax(double value) {
        if (this.cache == null) {
            return super.setMax(value);
        }
        AxisRange range = this.computeRange(this.getMin(), value, this.getLength(), 0.0);
        return super.set(range.getMin(), range.getMax());
    }

    @Override
    public boolean setMin(double value) {
        if (this.cache == null) {
            return super.setMin(value);
        }
        AxisRange range = this.computeRange(value, this.getMax(), this.getLength(), 0.0);
        return super.set(range.getMin(), range.getMax());
    }

    @Override
    protected AxisRange computeRange(double minValue, double maxValue, double axisLength, double labelSize) {
        double tickUnitRounded = this.computePreferredTickUnit(axisLength);
        double range = 10.0 * tickUnitRounded;
        double centre = this.getAxisZeroValue();
        double relCentre = this.getAxisZeroPosition();
        double minRounded = centre + (0.0 - relCentre) * range;
        double maxRounded = centre + (1.0 - relCentre) * range;
        double newScale = this.calculateNewScale(axisLength, minRounded, maxRounded);
        return new AxisRange(minRounded, maxRounded, axisLength, newScale, tickUnitRounded);
    }

    protected void recomputeClampedRange() {
        AxisRange effectiveRange = this.getRange();
        this.clampedRange.set(this.getMinRange());
        if (this.getMaxRange().isMaxDefined()) {
            this.clampedRange.add(Math.min(effectiveRange.getMax(), this.getMaxRange().getMax()));
        } else {
            this.clampedRange.add(effectiveRange.getMax());
        }
        if (this.getMaxRange().isMinDefined()) {
            this.clampedRange.add(Math.max(effectiveRange.getMin(), this.getMaxRange().getMin()));
        } else {
            this.clampedRange.add(effectiveRange.getMin());
        }
    }

    @Override
    protected void updateCachedVariables() {
        if (this.cache == null) {
            return;
        }
        this.cache.updateCachedAxisVariables();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS.getCssMetaData();
    }

    protected static double getEffectiveRange(double min, double max) {
        double effectiveRange = Math.abs(max - min);
        if (effectiveRange == 0.0 || Double.isNaN(effectiveRange)) {
            effectiveRange = 1.0;
        }
        return effectiveRange;
    }

    @Override
    public double getDisplayPosition(double value) {
        return this.cache.localOffset + (value - this.cache.localCurrentLowerBound) * this.cache.localScale;
    }

    @Override
    protected AxisRange autoRange(double minValue, double maxValue, double length, double labelSize) {
        return this.computeRange(minValue, maxValue, length, labelSize);
    }

    protected class Cache {
        protected double localScale;
        protected double localCurrentLowerBound;
        protected double localCurrentUpperBound;
        protected double localOffset;
        protected double localOffset2;
        protected double upperBoundLog;
        protected double lowerBoundLog;
        protected double logScaleLength;
        protected double logScaleLengthInv;
        protected boolean isVerticalAxis;
        protected double axisWidth;
        protected double axisHeight;
        protected double offset;

        protected Cache() {
        }

        private void updateCachedAxisVariables() {
            this.axisWidth = OscilloscopeAxis.this.getWidth();
            this.axisHeight = OscilloscopeAxis.this.getHeight();
            this.localCurrentLowerBound = OscilloscopeAxis.this.getMin();
            this.localCurrentUpperBound = OscilloscopeAxis.this.getMax();
            this.upperBoundLog = OscilloscopeAxis.this.axisTransform.forward(OscilloscopeAxis.this.getMax());
            this.lowerBoundLog = OscilloscopeAxis.this.axisTransform.forward(OscilloscopeAxis.this.getMin());
            this.logScaleLength = this.upperBoundLog - this.lowerBoundLog;
            this.logScaleLengthInv = 1.0 / this.logScaleLength;
            this.localScale = OscilloscopeAxis.this.scaleProperty().get();
            double zero = OscilloscopeAxis.super.getDisplayPosition(0.0);
            this.localOffset = zero + this.localCurrentLowerBound * this.localScale;
            this.localOffset2 = this.localOffset - OscilloscopeAxis.this.cache.localCurrentLowerBound * OscilloscopeAxis.this.cache.localScale;
            if (OscilloscopeAxis.this.getSide() != null) {
                this.isVerticalAxis = OscilloscopeAxis.this.getSide().isVertical();
            }
            this.logScaleLengthInv = this.isVerticalAxis ? this.axisHeight / this.logScaleLength : this.axisWidth / this.logScaleLength;
            this.offset = this.isVerticalAxis ? OscilloscopeAxis.this.getHeight() : OscilloscopeAxis.this.getWidth();
        }
    }
}

