/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.MouseEventsHelper;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.EditConstraints;
import de.gsi.dataset.EditableDataSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Popup;
import javafx.util.Pair;
import org.kordamp.ikonli.javafx.FontIcon;

public class EditDataSet
extends TableViewer {
    protected static final String STYLE_CLASS_SELECT_RECT = "chart-select-rect";
    protected static final String STYLE_CLASS_SELECT_PATH = "chart-select-marker";
    protected static final PseudoClass NOEDIT_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"noEdit");
    protected static final int DEFAULT_MARKER_RADIUS = 5;
    public static final int DEFAULT_PICKING_DISTANCE = 10;
    protected static final int SELECT_RECT_MIN_SIZE = 5;
    protected static final int FONT_SIZE_COMBO = 18;
    private static boolean shiftDown;
    private static boolean controlDown;
    protected boolean isPointDragActive;
    protected final Predicate<MouseEvent> defaultSelectFilter = event -> MouseEventsHelper.isOnlyPrimaryButtonDown(event) && event.isControlDown() && this.isMouseEventWithinCanvas((MouseEvent)event) && !this.isPointDragActive;
    protected final ConcurrentHashMap<EditableDataSet, ConcurrentHashMap<Integer, SelectedDataPoint>> markedPoints = new ConcurrentHashMap();
    protected final Rectangle selectRectangle = new Rectangle();
    protected Point2D selectStartPoint;
    protected Point2D selectEndPoint;
    protected Cursor originalCursor;
    protected final ObjectProperty<Cursor> dragCursor = new SimpleObjectProperty((Object)this, "dragCursor");
    protected BooleanProperty editEnable;
    protected BooleanProperty allowShiftX = new SimpleBooleanProperty((Object)this, "allowShiftX", true);
    protected BooleanProperty allowShiftY = new SimpleBooleanProperty((Object)this, "allowShiftY", true);
    protected Predicate<MouseEvent> zoomInMouseFilter = this.defaultSelectFilter;
    protected Pane markerPane = new Pane();
    private double mouseOriginX = -1.0;
    private double mouseOriginY = -1.0;
    protected PointEditionPopup popup = new PointEditionPopup();
    private final EventHandler<KeyEvent> keyReleasedHandler = keyEvent -> {
        if (keyEvent.getCode() == KeyCode.CONTROL) {
            this.uninstallCursor();
            controlDown = false;
        }
        if (keyEvent.getCode() == KeyCode.SHIFT) {
            shiftDown = false;
        }
    };
    private final EventHandler<KeyEvent> keyPressedHandler = keyEvent -> {
        if (keyEvent.getCode() == KeyCode.CONTROL) {
            this.installCursor();
            controlDown = true;
            this.isPointDragActive = false;
            keyEvent.consume();
        }
        if (keyEvent.getCode() == KeyCode.SHIFT) {
            shiftDown = true;
        }
        if (!(keyEvent.getCode() != KeyCode.ESCAPE || shiftDown && controlDown)) {
            this.markerPane.getChildren().clear();
        }
    };
    private final EventHandler<MouseEvent> selectionStartHandler = event -> {
        if (this.getSelectionMouseFilter() == null || this.getSelectionMouseFilter().test((MouseEvent)event)) {
            this.selectionStarted((MouseEvent)event);
            event.consume();
        }
        if (event.isSecondaryButtonDown()) {
            if (event.getSource() != null && event.getSource() instanceof SelectedDataPoint) {
                this.popup.showPopup((MouseEvent)event, (SelectedDataPoint)((Object)((Object)event.getSource())));
                event.consume();
            } else {
                this.popup.showPopup((MouseEvent)event, null);
                event.consume();
            }
        }
    };
    private final EventHandler<MouseEvent> selectionDragHandler = event -> {
        this.performPointDrag((MouseEvent)event);
        if (this.selectionOngoing() && !this.isPointDragActive) {
            this.selectionDragged((MouseEvent)event);
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> selectionEndHandler = event -> {
        if (this.selectionOngoing() && !this.isPointDragActive) {
            this.selectionEnded();
            event.consume();
        }
    };
    protected EventHandler<MouseEvent> dragHandler = this::performPointDrag;
    private final DoubleProperty pickingDistance = new SimpleDoubleProperty(this, "pickingDistance", 10.0){

        public void set(double newValue) {
            super.set(Math.max(1.0, newValue));
        }
    };

    public EditDataSet() {
        this.editable = true;
        this.setDragCursor(Cursor.CROSSHAIR);
        this.selectRectangle.setManaged(false);
        this.selectRectangle.getStyleClass().add((Object)STYLE_CLASS_SELECT_RECT);
        this.getChartChildren().add((Object)this.selectRectangle);
        this.registerMouseHandlers();
        this.registerKeyHandlers();
        this.markerPane.setManaged(false);
        this.chartProperty().addListener((change, o, n) -> {
            if (o != null) {
                o.getCanvasForeground().getChildren().remove((Object)this.markerPane);
                o.getPlotArea().setBottom(null);
            }
            if (n != null) {
                n.getCanvasForeground().getChildren().add((Object)this.markerPane);
                this.markerPane.toFront();
                this.markerPane.setVisible(true);
            }
        });
    }

    protected void addPoint(double x, double y) {
        if (!(this.getChart() instanceof XYChart)) {
            return;
        }
        XYChart xyChart = (XYChart)this.getChart();
        Pane pane = this.getChart().getCanvasForeground();
        Bounds bounds = pane.getBoundsInLocal();
        Bounds screenBounds = pane.localToScreen(bounds);
        int x0 = (int)screenBounds.getMinX();
        int y0 = (int)screenBounds.getMinY();
        DataPoint dataPoint = this.findNearestDataPoint(this.getChart(), new Point2D(x - (double)x0, y - (double)y0));
        if (dataPoint != null && dataPoint.getDataSet() instanceof EditableDataSet) {
            Axis xAxis = xyChart.getFirstAxis(Orientation.HORIZONTAL);
            Axis yAxis = xyChart.getFirstAxis(Orientation.VERTICAL);
            int index = dataPoint.getIndex();
            double newValX = xAxis.getValueForDisplay(x - (double)x0);
            double newValY = yAxis.getValueForDisplay(y - (double)y0);
            EditableDataSet ds = (EditableDataSet)dataPoint.getDataSet();
            double oldValX = ds.get(0, index);
            if (oldValX <= newValX) {
                ds.add(index, new double[]{newValX, newValY});
            } else {
                ds.add(index - 1, new double[]{newValX, newValY});
            }
        }
        this.updateMarker();
    }

    protected void applyDrag(double deltaX, double deltaY) {
        for (Node node : this.markerPane.getChildren()) {
            if (!(node instanceof SelectedDataPoint)) continue;
            SelectedDataPoint marker = (SelectedDataPoint)node;
            marker.applyDrag(deltaX, deltaY);
        }
        this.updateMarker();
    }

    protected void deleteAllMarkedPoints() {
        for (EditableDataSet dataSet : this.markedPoints.keySet()) {
            ConcurrentHashMap<Integer, SelectedDataPoint> dataPoints = this.markedPoints.get(dataSet);
            for (Integer dataPointIndex : dataPoints.keySet()) {
                SelectedDataPoint dataPoint = dataPoints.get(dataPointIndex);
                if (!dataPoint.delete()) continue;
                dataPoints.remove(dataPointIndex);
            }
        }
        this.updateMarker();
    }

    public final ObjectProperty<Cursor> dragCursorProperty() {
        return this.dragCursor;
    }

    public final ReadOnlyBooleanProperty editEnableProperty() {
        return this.editEnable;
    }

    protected void findDataPoint(Axis xAxis, Axis yAxis, List<DataSet> dataSets) {
        if (xAxis == null || yAxis == null || dataSets == null) {
            return;
        }
        double xMinScreen = Math.min(this.selectStartPoint.getX(), this.selectEndPoint.getX());
        double xMaxScreen = Math.max(this.selectStartPoint.getX(), this.selectEndPoint.getX());
        double yMinScreen = Math.min(this.selectStartPoint.getY(), this.selectEndPoint.getY());
        double yMaxScreen = Math.max(this.selectStartPoint.getY(), this.selectEndPoint.getY());
        for (DataSet ds : dataSets) {
            if (!(ds instanceof EditableDataSet)) continue;
            EditableDataSet dataSet = (EditableDataSet)ds;
            int indexMin = Math.max(0, ds.getIndex(0, new double[]{xAxis.getValueForDisplay(xMinScreen)}));
            int indexMax = Math.min(ds.getIndex(0, new double[]{xAxis.getValueForDisplay(xMaxScreen)}) + 1, ds.getDataCount());
            double yMax = yAxis.getValueForDisplay(yMinScreen);
            double yMin = yAxis.getValueForDisplay(yMaxScreen);
            ConcurrentHashMap dataSetHashMap = this.markedPoints.computeIfAbsent(dataSet, k -> new ConcurrentHashMap());
            for (int i = indexMin; i < indexMax; ++i) {
                double y = dataSet.get(1, i);
                if (!(y >= yMin) || !(y <= yMax)) continue;
                if (EditDataSet.isShiftDown()) {
                    if (dataSetHashMap.get(i) != null) {
                        dataSetHashMap.remove(i);
                        continue;
                    }
                    dataSetHashMap.put(i, new SelectedDataPoint(xAxis, yAxis, dataSet, i));
                    continue;
                }
                dataSetHashMap.put(i, new SelectedDataPoint(xAxis, yAxis, dataSet, i));
            }
        }
    }

    protected DataPoint findNearestDataPoint(Chart chart, Point2D mouseLocation) {
        if (!(chart instanceof XYChart)) {
            return null;
        }
        XYChart xyChart = (XYChart)chart;
        double xValue = xyChart.getXAxis().getValueForDisplay(mouseLocation.getX());
        DataPoint nearestDataPoint = null;
        for (DataPoint dataPoint : this.findNeighborPoints(xyChart, xValue)) {
            if (this.getChart().getFirstAxis(Orientation.HORIZONTAL) == null) continue;
            double x = xyChart.getXAxis().getDisplayPosition(dataPoint.getX());
            double y = xyChart.getYAxis().getDisplayPosition(dataPoint.getY());
            Point2D displayPoint = new Point2D(x, y);
            dataPoint.setDistanceFromMouse(displayPoint.distance(mouseLocation));
            if (nearestDataPoint != null && !(dataPoint.getDistanceFromMouse() < nearestDataPoint.getDistanceFromMouse())) continue;
            nearestDataPoint = dataPoint;
        }
        return nearestDataPoint;
    }

    protected Pair<DataPoint, DataPoint> findNeighborPoints(DataSet dataSet, double searchedX) {
        int prevIndex = -1;
        int nextIndex = -1;
        double prevX = Double.MIN_VALUE;
        double nextX = Double.MAX_VALUE;
        for (int i = 0; i < dataSet.getDataCount(); ++i) {
            double currentX = dataSet.get(0, i);
            if (currentX <= searchedX) {
                if (!(prevX <= currentX)) continue;
                prevIndex = i;
                prevX = currentX;
                continue;
            }
            if (!(nextX > currentX)) continue;
            nextIndex = i;
            nextX = currentX;
        }
        DataPoint prevPoint = prevIndex == -1 ? null : new DataPoint(this.getChart(), dataSet, prevIndex, dataSet.get(0, prevIndex), dataSet.get(1, prevIndex), dataSet.getDataLabel(prevIndex));
        DataPoint nextPoint = nextIndex == -1 || nextIndex == prevIndex ? null : new DataPoint(this.getChart(), dataSet, nextIndex, dataSet.get(0, nextIndex), dataSet.get(1, nextIndex), dataSet.getDataLabel(nextIndex));
        return new Pair((Object)prevPoint, (Object)nextPoint);
    }

    protected List<DataPoint> findNeighborPoints(XYChart chart, double searchedX) {
        LinkedList<DataPoint> points = new LinkedList<DataPoint>();
        for (DataSet dataSet : chart.getAllDatasets()) {
            Pair<DataPoint, DataPoint> neighborPoints = this.findNeighborPoints(dataSet, searchedX);
            if (neighborPoints.getKey() != null) {
                points.add((DataPoint)neighborPoints.getKey());
            }
            if (neighborPoints.getValue() == null) continue;
            points.add((DataPoint)neighborPoints.getValue());
        }
        return points;
    }

    public final Cursor getDragCursor() {
        return (Cursor)this.dragCursorProperty().get();
    }

    @Override
    protected HBox getInteractorBar() {
        HBox interactorBar = super.getInteractorBar();
        FontIcon editIcon = new FontIcon("fa-edit:22");
        FontIcon addIcon = new FontIcon("fa-plus-circle:22");
        FontIcon removeIcon = new FontIcon("fa-minus-circle:22");
        Button editButton = new Button(null, (Node)editIcon);
        editButton.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        editButton.setTooltip(new Tooltip("enables edit interactor"));
        interactorBar.getChildren().add((Object)editButton);
        Button addButton = new Button(null, (Node)addIcon);
        addIcon.setFill((Paint)Color.DARKGREEN);
        addButton.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        addButton.setTooltip(new Tooltip("add data point"));
        interactorBar.getChildren().add((Object)addButton);
        Button removeButton = new Button(null, (Node)removeIcon);
        removeIcon.setFill((Paint)Color.DARKRED);
        removeButton.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        removeButton.setTooltip(new Tooltip("remove data point"));
        interactorBar.getChildren().add((Object)removeButton);
        ComboBox comBox = new ComboBox();
        comBox.setPrefSize(-1.0, -1.0);
        comBox.setPadding(Insets.EMPTY);
        comBox.setBorder(null);
        comBox.setValue((Object)ShiftConstraint.SHIFTXY);
        comBox.getItems().addAll((Object[])ShiftConstraint.values());
        comBox.setButtonCell((ListCell)new ShiftConstraintListCell());
        comBox.setCellFactory(listView -> new ShiftConstraintListCell());
        comBox.valueProperty().addListener((ch, o, n) -> {
            if (n == null) {
                return;
            }
            switch (n) {
                case SHIFTX: {
                    this.allowShiftX.set(true);
                    this.allowShiftY.set(false);
                    break;
                }
                case SHIFTY: {
                    this.allowShiftX.set(false);
                    this.allowShiftY.set(true);
                    break;
                }
                default: {
                    this.allowShiftX.set(true);
                    this.allowShiftY.set(true);
                }
            }
        });
        interactorBar.getChildren().add((Object)comBox);
        if (this.editEnable == null) {
            this.editEnable = new SimpleBooleanProperty((Object)this, "editEnable", false);
        }
        this.editEnable.addListener((ch, o, n) -> {
            removeButton.setDisable(n == false);
            comBox.setDisable(n == false);
        });
        return interactorBar;
    }

    public final double getPickingDistance() {
        return this.pickingDistanceProperty().get();
    }

    public Predicate<MouseEvent> getSelectionMouseFilter() {
        return this.zoomInMouseFilter;
    }

    protected void installCursor() {
        Chart chart = this.getChart();
        this.originalCursor = chart.getCursor();
        if (this.getDragCursor() != null) {
            chart.setCursor(this.getDragCursor());
        }
    }

    public final boolean isEditable() {
        return this.editEnableProperty().get();
    }

    protected void performPointDrag(MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY && !controlDown && this.isPointDragActive) {
            if (this.mouseOriginX < 0.0) {
                this.mouseOriginX = event.getSceneX();
            }
            if (this.mouseOriginY < 0.0) {
                this.mouseOriginY = event.getSceneY();
            }
            double deltaX = event.getSceneX() - this.mouseOriginX;
            double deltaY = event.getSceneY() - this.mouseOriginY;
            this.mouseOriginX = event.getSceneX();
            this.mouseOriginY = event.getSceneY();
            this.applyDrag(deltaX, deltaY);
            event.consume();
        } else {
            this.isPointDragActive = false;
        }
    }

    protected void performSelection() {
        if (!(this.getChart() instanceof XYChart)) {
            return;
        }
        XYChart xyChart = (XYChart)this.getChart();
        if (!EditDataSet.isShiftDown()) {
            this.markedPoints.clear();
        }
        this.findDataPoint(xyChart.getFirstAxis(Orientation.HORIZONTAL), xyChart.getFirstAxis(Orientation.VERTICAL), (List<DataSet>)xyChart.getDatasets());
        for (Renderer rend : xyChart.getRenderers()) {
            ObservableList<Axis> axes = rend.getAxes();
            this.findDataPoint(EditDataSet.getFirstAxis(axes, Orientation.HORIZONTAL), EditDataSet.getFirstAxis(axes, Orientation.VERTICAL), (List<DataSet>)rend.getDatasets());
        }
        this.editEnable.set(!this.markedPoints.isEmpty());
        this.updateMarker();
    }

    public final DoubleProperty pickingDistanceProperty() {
        return this.pickingDistance;
    }

    private void registerKeyHandlers() {
        this.registerInputEventHandler(KeyEvent.KEY_PRESSED, this.keyPressedHandler);
        this.registerInputEventHandler(KeyEvent.KEY_RELEASED, this.keyReleasedHandler);
    }

    private void registerMouseHandlers() {
        this.registerInputEventHandler(MouseEvent.MOUSE_PRESSED, this.selectionStartHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_DRAGGED, this.selectionDragHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_RELEASED, this.selectionEndHandler);
    }

    protected void selectionDragged(MouseEvent event) {
        Bounds plotAreaBounds = this.getChart().getPlotArea().getBoundsInLocal();
        this.selectEndPoint = EditDataSet.limitToPlotArea(event, plotAreaBounds);
        this.selectRectangle.setX(Math.min(this.selectStartPoint.getX(), this.selectEndPoint.getX()));
        this.selectRectangle.setY(Math.min(this.selectStartPoint.getY(), this.selectEndPoint.getY()));
        this.selectRectangle.setWidth(Math.abs(this.selectEndPoint.getX() - this.selectStartPoint.getX()));
        this.selectRectangle.setHeight(Math.abs(this.selectEndPoint.getY() - this.selectStartPoint.getY()));
    }

    protected void selectionEnded() {
        this.selectRectangle.setVisible(false);
        if (this.selectRectangle.getWidth() > 5.0 && this.selectRectangle.getHeight() > 5.0) {
            this.performSelection();
        }
        this.selectEndPoint = null;
        this.selectStartPoint = null;
    }

    protected boolean selectionOngoing() {
        return this.selectStartPoint != null;
    }

    protected void selectionStarted(MouseEvent event) {
        this.selectStartPoint = new Point2D(event.getX(), event.getY());
        this.selectRectangle.setX(this.selectStartPoint.getX());
        this.selectRectangle.setY(this.selectStartPoint.getY());
        this.selectRectangle.setWidth(0.0);
        this.selectRectangle.setHeight(0.0);
        this.selectRectangle.setVisible(true);
    }

    public final void setDragCursor(Cursor cursor) {
        this.dragCursorProperty().set((Object)cursor);
    }

    public final void setPickingDistance(double distance) {
        this.pickingDistanceProperty().set(distance);
    }

    public void setZoomInMouseFilter(Predicate<MouseEvent> zoomInMouseFilter) {
        this.zoomInMouseFilter = zoomInMouseFilter;
    }

    protected EventHandler<MouseEvent> startDragHandler(SelectedDataPoint dataPoint) {
        return event -> {
            if (event.isPrimaryButtonDown() && !controlDown && !shiftDown) {
                this.isPointDragActive = true;
                this.mouseOriginX = event.getSceneX();
                this.mouseOriginY = event.getSceneY();
                dataPoint.setCursor(Cursor.CLOSED_HAND);
                event.consume();
            }
            if (event.isSecondaryButtonDown()) {
                this.popup.showPopup((MouseEvent)event, dataPoint);
            }
        };
    }

    protected void uninstallCursor() {
        this.getChart().setCursor(this.originalCursor);
    }

    protected void updateMarker() {
        this.markerPane.getChildren().clear();
        this.markerPane.getParent().setMouseTransparent(false);
        for (EditableDataSet dataSet : this.markedPoints.keySet()) {
            ConcurrentHashMap<Integer, SelectedDataPoint> dataPoints = this.markedPoints.get(dataSet);
            if (dataPoints == null) continue;
            for (Integer dataPointIndex : dataPoints.keySet()) {
                SelectedDataPoint dataPoint = dataPoints.get(dataPointIndex);
                dataPoint.update();
                this.markerPane.getChildren().add((Object)dataPoint);
            }
        }
        if (this.markerPane.getChildren().isEmpty()) {
            this.markerPane.getParent().setMouseTransparent(true);
        }
    }

    private static Axis getFirstAxis(List<Axis> axes, Orientation orientation) {
        block3: for (Axis axis : axes) {
            if (axis.getSide() == null) continue;
            switch (orientation) {
                case VERTICAL: {
                    if (!axis.getSide().isVertical()) continue block3;
                    return axis;
                }
            }
            if (!axis.getSide().isHorizontal()) continue;
            return axis;
        }
        return null;
    }

    public static boolean isControlDown() {
        return controlDown;
    }

    public static boolean isShiftDown() {
        return shiftDown;
    }

    private static Point2D limitToPlotArea(MouseEvent event, Bounds plotBounds) {
        double limitedX = Math.max(Math.min(event.getX() - plotBounds.getMinX(), plotBounds.getMaxX()), plotBounds.getMinX());
        double limitedY = Math.max(Math.min(event.getY() - plotBounds.getMinY(), plotBounds.getMaxY()), plotBounds.getMinY());
        return new Point2D(limitedX, limitedY);
    }

    protected int findIndex(DataSet dataSet, int cachedIndex, double x, double y) {
        if (cachedIndex >= 0 && cachedIndex < dataSet.getDataCount() && dataSet.get(0, cachedIndex) == x && dataSet.get(1, cachedIndex) == y) {
            return cachedIndex;
        }
        for (int i = 0; i < dataSet.getDataCount(); ++i) {
            if (dataSet.get(0, i) != x || dataSet.get(1, i) != y) continue;
            return i;
        }
        return -1;
    }

    protected class SelectedDataPoint
    extends Circle {
        private final Axis xAxis;
        private final Axis yAxis;
        private final EditableDataSet dataSet;
        private double xValue;
        private double yValue;
        private int cachedIndex;

        SelectedDataPoint(Axis xAxis, Axis yAxis, EditableDataSet dataSet, int index) {
            this.getStyleClass().add((Object)EditDataSet.STYLE_CLASS_SELECT_PATH);
            this.setManaged(false);
            EditConstraints constraints = dataSet.getEditConstraints();
            if (constraints == null) {
                this.pseudoClassStateChanged(NOEDIT_PSEUDO_CLASS, false);
            } else {
                boolean canChange = constraints.canChange(index);
                if (!canChange) {
                    this.pseudoClassStateChanged(NOEDIT_PSEUDO_CLASS, true);
                }
            }
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.dataSet = dataSet;
            this.xValue = dataSet.get(0, index);
            this.yValue = dataSet.get(1, index);
            this.cachedIndex = index;
            this.setCenterX(this.getX());
            this.setCenterY(this.getY());
            this.setRadius(5.0);
            EventHandler dragOver = e -> {
                EditDataSet.this.isPointDragActive = false;
                this.setCursor(Cursor.DEFAULT);
            };
            this.setOnMouseEntered(e -> this.setCursor(Cursor.OPEN_HAND));
            this.addEventFilter(MouseDragEvent.MOUSE_DRAG_OVER, dragOver);
            this.setOnMousePressed(EditDataSet.this.startDragHandler(this));
            this.setOnMouseReleased(dragOver);
            this.setOnMouseDragOver(dragOver);
            xAxis.addListener(evt -> FXUtils.runFX(() -> this.setCenterX(this.getX())));
            yAxis.addListener(evt -> FXUtils.runFX(() -> this.setCenterY(this.getY())));
            dataSet.addListener(e -> FXUtils.runFX(this::update));
        }

        public void applyDrag(double deltaX, double deltaY) {
            if (!this.dataSet.isVisible()) {
                return;
            }
            double nX = this.getX();
            double nY = this.getY();
            int index = this.getIndex();
            EditConstraints constraints = this.dataSet.getEditConstraints();
            if (constraints == null) {
                if (EditDataSet.this.allowShiftX.get()) {
                    nX += deltaX;
                }
                if (EditDataSet.this.allowShiftY.get()) {
                    nY += deltaY;
                }
                double x = this.xAxis.getValueForDisplay(nX);
                double y = this.yAxis.getValueForDisplay(nY);
                this.dataSet.set(index, new double[]{x, y});
                this.xValue = x;
                this.yValue = y;
                return;
            }
            boolean canChange = constraints.canChange(index);
            if (canChange && constraints.isEditable(0) && EditDataSet.this.allowShiftX.get()) {
                nX += deltaX;
            }
            if (canChange && constraints.isEditable(1) && EditDataSet.this.allowShiftY.get()) {
                nY += deltaY;
            }
            double x = this.xAxis.getValueForDisplay(nX);
            double y = this.yAxis.getValueForDisplay(nY);
            this.dataSet.set(index, new double[]{x, y});
            this.xValue = x;
            this.yValue = y;
        }

        public boolean delete() {
            if (!this.dataSet.isVisible()) {
                return false;
            }
            EditConstraints constraints = this.dataSet.getEditConstraints();
            int index = this.getIndex();
            if (constraints == null || constraints.canDelete(index)) {
                this.dataSet.remove(index);
                return true;
            }
            return false;
        }

        public EditableDataSet getDataSet() {
            return this.dataSet;
        }

        public int getIndex() {
            this.cachedIndex = EditDataSet.this.findIndex((DataSet)this.dataSet, this.cachedIndex, this.xValue, this.yValue);
            return this.cachedIndex;
        }

        public double getX() {
            return this.xAxis.getDisplayPosition(this.xValue);
        }

        public double getY() {
            return this.yAxis.getDisplayPosition(this.yValue);
        }

        public String toString() {
            return "selected index=" + this.getIndex();
        }

        public void update() {
            this.setCenterX(this.getX());
            this.setCenterY(this.getY());
        }
    }

    protected class PointEditionPopup
    extends Popup {
        private final Button addPoint = new Button("add");
        private final Button deletePoint = new Button("delete");
        private final Button deletePoints = new Button("delete all");

        public PointEditionPopup() {
            this.setAutoFix(true);
            this.setAutoHide(true);
            this.setHideOnEscape(true);
            this.setAutoHide(true);
            this.getContent().add((Object)this.initContent());
            this.addPoint.setOnAction(evt -> {
                double x = this.getX();
                double y = this.getY();
                EditDataSet.this.addPoint(x, y);
            });
            this.deletePoints.setOnAction(evt -> EditDataSet.this.deleteAllMarkedPoints());
        }

        private VBox initContent() {
            VBox pane = new VBox();
            pane.getChildren().add((Object)new Label("popup"));
            pane.getChildren().add((Object)this.addPoint);
            pane.getChildren().add((Object)this.deletePoint);
            pane.getChildren().add((Object)this.deletePoints);
            return pane;
        }

        public void showPopup(MouseEvent event, SelectedDataPoint selectedPoint) {
            this.deletePoints.setDisable(EditDataSet.this.markerPane.getChildren().isEmpty());
            if (selectedPoint == null) {
                this.deletePoint.setDisable(true);
            } else {
                this.deletePoint.setDisable(false);
                this.deletePoint.setOnAction(evt -> {
                    if (selectedPoint.delete()) {
                        EditDataSet.this.markedPoints.get(selectedPoint.getDataSet()).remove(selectedPoint.getIndex());
                    }
                    EditDataSet.this.updateMarker();
                });
            }
            this.show(EditDataSet.this.getChart().getScene().getWindow(), event.getScreenX(), event.getScreenY());
        }
    }

    public static class DataPoint {
        private final Chart chart;
        private final double x;
        private final double y;
        private final String label;
        private double distanceFromMouse;
        private final DataSet dataSet;
        private final int index;

        public DataPoint(Chart chart, DataSet dataSet, int index, double x, double y, String label) {
            this.chart = chart;
            this.dataSet = dataSet;
            this.index = index;
            this.x = x;
            this.y = y;
            this.label = label;
        }

        public Chart getChart() {
            return this.chart;
        }

        public DataSet getDataSet() {
            return this.dataSet;
        }

        public double getDistanceFromMouse() {
            return this.distanceFromMouse;
        }

        public int getIndex() {
            return this.index;
        }

        public String getLabel() {
            return this.label;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setDistanceFromMouse(double distance) {
            this.distanceFromMouse = distance;
        }

        public String toString() {
            return "DataSet= '" + this.dataSet.getName() + "' index=" + this.index;
        }
    }

    static class ShiftConstraintListCell
    extends ListCell<ShiftConstraint> {
        public ShiftConstraintListCell() {
            this.setContentDisplay(ContentDisplay.LEFT);
        }

        protected void updateItem(ShiftConstraint shiftConstraint, boolean empty) {
            FontIcon result;
            super.updateItem((Object)shiftConstraint, empty);
            if (shiftConstraint == null || empty) {
                this.setGraphic(null);
                return;
            }
            Tooltip tooltip = new Tooltip();
            switch (shiftConstraint) {
                case SHIFTX: {
                    result = new FontIcon("fa-arrows-h:18");
                    tooltip.setText("Allow to modify the points's x values");
                    this.setText("shift x");
                    break;
                }
                case SHIFTXY: {
                    result = new FontIcon("fa-arrows:18");
                    tooltip.setText("Allow to modify the points freely");
                    this.setText("shift xy");
                    break;
                }
                case SHIFTY: {
                    result = new FontIcon("fa-arrows-v:18");
                    tooltip.setText("Allow to modify the point's y values");
                    this.setText("shift y");
                    break;
                }
                default: {
                    result = new FontIcon("fa-question-circle-o:18");
                    this.setText("-");
                }
            }
            result.setFill((Paint)Color.DARKBLUE);
            this.setGraphic((Node)result);
        }
    }

    static enum ShiftConstraint {
        SHIFTXY,
        SHIFTX,
        SHIFTY;

    }
}

