/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.MouseEventsHelper;
import de.gsi.chart.ui.geometry.Side;
import java.util.Objects;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;

public class Panner
extends ChartPlugin {
    public static final Predicate<MouseEvent> DEFAULT_MOUSE_FILTER = MouseEventsHelper::isOnlyMiddleButtonDown;
    private Predicate<MouseEvent> mouseFilter = DEFAULT_MOUSE_FILTER;
    private Point2D previousMouseLocation = null;
    private final ObjectProperty<AxisMode> axisMode = new SimpleObjectProperty<AxisMode>((Object)this, "axisMode", AxisMode.XY){

        protected void invalidated() {
            Objects.requireNonNull((AxisMode)((Object)this.get()), "The " + this.getName() + " must not be null");
        }
    };
    private Cursor originalCursor;
    private final ObjectProperty<Cursor> dragCursor = new SimpleObjectProperty((Object)this, "dragCursor");
    private final EventHandler<MouseEvent> panStartHandler = event -> {
        if (this.mouseFilter == null || this.mouseFilter.test((MouseEvent)event)) {
            this.panStarted((MouseEvent)event);
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> panDragHandler = event -> {
        if (this.panOngoing()) {
            this.panDragged((MouseEvent)event);
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> panEndHandler = event -> {
        if (this.panOngoing()) {
            this.panEnded();
            event.consume();
        }
    };

    public Panner() {
        this(AxisMode.XY);
    }

    public Panner(AxisMode panMode) {
        this.setAxisMode(panMode);
        this.setDragCursor(Cursor.CLOSED_HAND);
        this.registerMouseHandlers();
    }

    public final ObjectProperty<AxisMode> axisModeProperty() {
        return this.axisMode;
    }

    public final ObjectProperty<Cursor> dragCursorProperty() {
        return this.dragCursor;
    }

    public final AxisMode getAxisMode() {
        return (AxisMode)((Object)this.axisModeProperty().get());
    }

    public final Cursor getDragCursor() {
        return (Cursor)this.dragCursorProperty().get();
    }

    public Predicate<MouseEvent> getMouseFilter() {
        return this.mouseFilter;
    }

    private void installCursor() {
        this.originalCursor = this.getChart().getCursor();
        if (this.getDragCursor() != null) {
            this.getChart().setCursor(this.getDragCursor());
        }
    }

    private void panChart(Chart chart, Point2D mouseLocation) {
        if (!(chart instanceof XYChart)) {
            return;
        }
        for (Axis axis : chart.getAxes()) {
            boolean allowsShift;
            if (axis.getSide() == null) continue;
            Side side = axis.getSide();
            double prevData = axis.getValueForDisplay(side.isHorizontal() ? this.previousMouseLocation.getX() : this.previousMouseLocation.getY());
            double newData = axis.getValueForDisplay(side.isHorizontal() ? mouseLocation.getX() : mouseLocation.getY());
            double offset = prevData - newData;
            boolean bl = allowsShift = side.isHorizontal() ? this.getAxisMode().allowsX() : this.getAxisMode().allowsY();
            if (axis.minProperty().isBound() || axis.maxProperty().isBound() || !allowsShift) continue;
            axis.setAutoRanging(false);
            this.shiftBounds(axis, offset);
        }
    }

    private void panDragged(MouseEvent event) {
        Point2D mouseLocation = this.getLocationInPlotArea(event);
        this.panChart(this.getChart(), mouseLocation);
        this.previousMouseLocation = mouseLocation;
    }

    private void panEnded() {
        this.previousMouseLocation = null;
        this.uninstallCursor();
    }

    private boolean panOngoing() {
        return this.previousMouseLocation != null;
    }

    private void panStarted(MouseEvent event) {
        this.previousMouseLocation = this.getLocationInPlotArea(event);
        this.installCursor();
    }

    private void registerMouseHandlers() {
        this.registerInputEventHandler(MouseEvent.MOUSE_PRESSED, this.panStartHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_DRAGGED, this.panDragHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_RELEASED, this.panEndHandler);
    }

    public final void setAxisMode(AxisMode mode) {
        this.axisModeProperty().set((Object)mode);
    }

    public final void setDragCursor(Cursor cursor) {
        this.dragCursorProperty().set((Object)cursor);
    }

    public void setMouseFilter(Predicate<MouseEvent> mouseFilter) {
        this.mouseFilter = mouseFilter;
    }

    private void shiftBounds(Axis axis, double offset) {
        if (offset < 0.0) {
            axis.setMin(axis.getMin() + offset);
            axis.setMax(axis.getMax() + offset);
        } else {
            axis.setMax(axis.getMax() + offset);
            axis.setMin(axis.getMin() + offset);
        }
    }

    private void uninstallCursor() {
        this.getChart().setCursor(this.originalCursor);
    }
}

