/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.measurements.AbstractChartMeasurement;
import de.gsi.chart.plugins.measurements.DataSetMeasurements;
import de.gsi.chart.plugins.measurements.SimpleMeasurements;
import de.gsi.chart.ui.TilingPane;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.viewer.DataView;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import org.kordamp.ikonli.javafx.FontIcon;

public class ParameterMeasurements
extends ChartPlugin {
    private static final String TOOL_BUTTON = "fas-drafting-compass:18";
    protected final ObservableList<AbstractChartMeasurement> chartMeasurements = FXCollections.observableArrayList();
    private final DataView dataView = new DataView("ChartViews", (Node)new FontIcon("fas-drafting-compass:18"));
    private MenuBar parameterMenu;
    private final ChangeListener<Boolean> parentVisibleListener = (obs, o, n) -> {
        if (Boolean.FALSE.equals(n)) {
            ((Menu)this.parameterMenu.getMenus().get(0)).hide();
        }
    };

    public ParameterMeasurements() {
        this(Side.RIGHT, true);
    }

    public ParameterMeasurements(Side side, boolean addToToolBar) {
        this.parameterMenu = this.getMenuBar();
        this.parameterMenu.setId("ParameterMeasurements::parameterMenu");
        this.parameterMenu.parentProperty().addListener((obs, o, n) -> {
            if (o != null) {
                o.visibleProperty().addListener(this.parentVisibleListener);
            }
            if (n != null) {
                n.visibleProperty().addListener(this.parentVisibleListener);
            }
        });
        this.chartProperty().addListener((change, oldChart, newChart) -> {
            if (oldChart != null) {
                oldChart.getToolBar().getChildren().remove((Object)this.parameterMenu);
                oldChart.getMeasurementBar(side).getChildren().remove((Object)this.dataView);
            }
            if (newChart != null) {
                if (addToToolBar) {
                    newChart.getToolBar().getChildren().add((Object)this.parameterMenu);
                }
                newChart.getMeasurementBar(side).getChildren().add((Object)this.dataView);
            }
        });
        this.dataView.setNodeLayout(TilingPane.Layout.VBOX);
    }

    public ObservableList<AbstractChartMeasurement> getChartMeasurements() {
        return this.chartMeasurements;
    }

    public DataView getDataView() {
        return this.dataView;
    }

    public MenuBar getMenuBar() {
        MenuItem newMeasurement;
        Menu newCategory;
        if (this.parameterMenu != null) {
            return this.parameterMenu;
        }
        this.parameterMenu = new MenuBar();
        Menu measurementMenu = new Menu(null, (Node)new FontIcon(TOOL_BUTTON));
        measurementMenu.getProperties().put((Object)"TOOL_TIP", (Object)new Tooltip("add measurement indicator"));
        measurementMenu.setId("ParameterMeasurements::measurementMenu");
        for (SimpleMeasurements.MeasurementCategory measurementCategory : SimpleMeasurements.MeasurementCategory.values()) {
            newCategory = new Menu(measurementCategory.getName());
            measurementMenu.getItems().addAll((Object[])new MenuItem[]{newCategory});
            for (SimpleMeasurements.MeasurementType measurementType : SimpleMeasurements.MeasurementType.values()) {
                if (measurementType.getCategory() != measurementCategory) continue;
                newMeasurement = new MenuItem(measurementType.getName());
                newMeasurement.setId("ParameterMeasurements::newMeasurement::" + measurementType.toString());
                newMeasurement.setOnAction(evt -> new SimpleMeasurements(this, measurementType).initialize());
                newCategory.getItems().addAll((Object[])new MenuItem[]{newMeasurement});
            }
        }
        for (Enum enum_ : DataSetMeasurements.MeasurementCategory.values()) {
            newCategory = new Menu(((DataSetMeasurements.MeasurementCategory)enum_).getName());
            measurementMenu.getItems().addAll((Object[])new MenuItem[]{newCategory});
            for (Enum enum_2 : DataSetMeasurements.MeasurementType.values()) {
                if (((DataSetMeasurements.MeasurementType)enum_2).getCategory() != enum_) continue;
                newMeasurement = new MenuItem(((DataSetMeasurements.MeasurementType)enum_2).getName());
                newMeasurement.setId("ParameterMeasurements::newMeasurement::" + enum_2.toString());
                newMeasurement.setOnAction(arg_0 -> this.lambda$getMenuBar$4((DataSetMeasurements.MeasurementType)enum_2, arg_0));
                newCategory.getItems().addAll((Object[])new MenuItem[]{newMeasurement});
            }
        }
        this.parameterMenu.getMenus().addAll((Object[])new Menu[]{measurementMenu});
        return this.parameterMenu;
    }

    private /* synthetic */ void lambda$getMenuBar$4(DataSetMeasurements.MeasurementType measType, ActionEvent evt) {
        new DataSetMeasurements(this, measType).initialize();
    }
}

