/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements.utils;

import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.measurements.AbstractChartMeasurement;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartMeasurementSelector
extends GridPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartMeasurementSelector.class);
    private static final int DEFAULT_SELECTOR_HEIGHT = 50;
    private static final int ROW_HEIGHT = 24;
    protected final ListView<AbstractChartMeasurement> chartMeasurementListView;

    public ChartMeasurementSelector(ParameterMeasurements plugin, AbstractChartMeasurement dataSetMeasurement, int requiredNumberOfChartMeasurements) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin must not be null");
        }
        Label label = new Label("Selected Measurement: ");
        GridPane.setConstraints((Node)label, (int)0, (int)0);
        this.chartMeasurementListView = new ListView((ObservableList)plugin.getChartMeasurements().filtered(t -> !t.equals(dataSetMeasurement)));
        GridPane.setConstraints(this.chartMeasurementListView, (int)1, (int)0);
        this.chartMeasurementListView.setOrientation(Orientation.VERTICAL);
        this.chartMeasurementListView.setPrefSize(-1.0, 50.0);
        this.chartMeasurementListView.setCellFactory(list -> new ChartMeasurementLabel());
        this.chartMeasurementListView.setPrefHeight((double)(Math.max(2, plugin.getChartMeasurements().size()) * 24) + 2.0);
        MultipleSelectionModel selModel = this.chartMeasurementListView.getSelectionModel();
        if (requiredNumberOfChartMeasurements == 1) {
            selModel.setSelectionMode(SelectionMode.SINGLE);
        } else if (requiredNumberOfChartMeasurements >= 2) {
            selModel.setSelectionMode(SelectionMode.MULTIPLE);
        }
        if (selModel.getSelectedIndices().isEmpty() && plugin.getChartMeasurements().size() >= requiredNumberOfChartMeasurements) {
            for (int i = 0; i < requiredNumberOfChartMeasurements; ++i) {
                selModel.select(i);
            }
        }
        if (selModel.getSelectedIndices().size() < requiredNumberOfChartMeasurements && LOGGER.isWarnEnabled()) {
            LOGGER.atWarn().addArgument((Object)plugin.getChartMeasurements().size()).addArgument((Object)requiredNumberOfChartMeasurements).log("could not add default selection: required {} vs. selected {}");
        }
        if (requiredNumberOfChartMeasurements >= 1) {
            this.getChildren().addAll((Object[])new Node[]{label, this.chartMeasurementListView});
        }
    }

    public AbstractChartMeasurement getSelectedChartMeasurement() {
        MultipleSelectionModel selModel = this.chartMeasurementListView.getSelectionModel();
        return (AbstractChartMeasurement)selModel.getSelectedItem();
    }

    public ObservableList<AbstractChartMeasurement> getSelectedChartMeasurements() {
        MultipleSelectionModel selModel = this.chartMeasurementListView.getSelectionModel();
        return selModel.getSelectedItems();
    }

    protected static class ChartMeasurementLabel
    extends ListCell<AbstractChartMeasurement> {
        protected ChartMeasurementLabel() {
        }

        public void updateItem(AbstractChartMeasurement item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                String dataSetName = item.getDataSet() == null ? "n/a" : item.getDataSet().getName();
                this.setText(item.getTitle() + "<" + dataSetName + ">");
            }
        }
    }
}

