/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements.utils;

import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.dataset.DataSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.GridPane;

public class DataSetSelector
extends GridPane {
    private static final int DEFAULT_SELECTOR_HEIGHT = 50;
    private static final int ROW_HEIGHT = 24;
    protected final ListView<DataSet> dataSetListView;
    protected final ObservableList<DataSet> allDataSets;

    public DataSetSelector(ParameterMeasurements plugin, int requiredNumberOfDataSets) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin must not be null");
        }
        this.allDataSets = plugin.getChart() != null ? FXCollections.observableArrayList(plugin.getChart().getAllDatasets()) : FXCollections.emptyObservableList();
        Label label = new Label("Selected Dataset: ");
        GridPane.setConstraints((Node)label, (int)0, (int)0);
        this.dataSetListView = new ListView(this.allDataSets);
        GridPane.setConstraints(this.dataSetListView, (int)1, (int)0);
        this.dataSetListView.setOrientation(Orientation.VERTICAL);
        this.dataSetListView.setPrefSize(-1.0, 50.0);
        this.dataSetListView.setCellFactory(list -> new DataSetLabel());
        this.dataSetListView.setPrefHeight((double)(Math.max(2, this.allDataSets.size()) * 24) + 2.0);
        MultipleSelectionModel selModel = this.dataSetListView.getSelectionModel();
        if (requiredNumberOfDataSets == 1) {
            selModel.setSelectionMode(SelectionMode.SINGLE);
        } else if (requiredNumberOfDataSets >= 2) {
            selModel.setSelectionMode(SelectionMode.MULTIPLE);
        }
        if (selModel.getSelectedIndices().isEmpty() && this.allDataSets.size() >= requiredNumberOfDataSets) {
            for (int i = 0; i < requiredNumberOfDataSets; ++i) {
                selModel.select(i);
            }
        }
        if (requiredNumberOfDataSets >= 1) {
            this.getChildren().addAll((Object[])new Node[]{label, this.dataSetListView});
        }
    }

    public int getNumberDataSets() {
        return this.allDataSets.size();
    }

    public DataSet getSelectedDataSet() {
        MultipleSelectionModel selModel = this.dataSetListView.getSelectionModel();
        return (DataSet)selModel.getSelectedItem();
    }

    public ObservableList<DataSet> getSelectedDataSets() {
        MultipleSelectionModel selModel = this.dataSetListView.getSelectionModel();
        return selModel.getSelectedItems();
    }

    public ListView<DataSet> getDataSetListView() {
        return this.dataSetListView;
    }

    protected static class DataSetLabel
    extends ListCell<DataSet> {
        protected DataSetLabel() {
        }

        public void updateItem(DataSet item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                this.setText(item.getName());
            }
        }
    }
}

