/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.financial;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.AbstractDataSetManagement;
import de.gsi.chart.renderer.spi.financial.service.OhlcvRendererEpData;
import de.gsi.chart.renderer.spi.financial.service.PaintBarMarker;
import de.gsi.dataset.DataSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class AbstractFinancialRenderer<R extends Renderer>
extends AbstractDataSetManagement<R>
implements Renderer {
    protected PaintBarMarker paintBarMarker;
    private final BooleanProperty computeLocalYRange = new SimpleBooleanProperty((Object)this, "computeLocalYRange", true);

    public BooleanProperty computeLocalRangeProperty() {
        return this.computeLocalYRange;
    }

    public boolean computeLocalRange() {
        return this.computeLocalRangeProperty().get();
    }

    public void setComputeLocalRange(boolean value) {
        this.computeLocalRangeProperty().set(value);
    }

    public void setPaintBarMarker(PaintBarMarker paintBarMarker) {
        this.paintBarMarker = paintBarMarker;
    }

    protected double[] findAreaDistances(FindAreaDistances findAreaDistances, DataSet dataset, Axis xAxis, Axis yAxis, double xmin, double xmax) {
        return findAreaDistances.findAreaDistances(dataset, xAxis, yAxis, xmin, xmax);
    }

    protected Paint getPaintBarColor(OhlcvRendererEpData data) {
        if (this.paintBarMarker != null && data != null) {
            return this.paintBarMarker.getPaintBy(data);
        }
        return null;
    }

    protected void paintVolume(GraphicsContext gc, DataSet ds, int index, Color volumeLongColor, Color volumeShortColor, Axis yAxis, double[] distances, double barWidth, double barWidthHalf, double x0) {
        double volume = ds.get(5, index);
        double open = ds.get(1, index);
        double close = ds.get(4, index);
        double maxVolume = distances[1];
        double volumeHeight = volume / maxVolume * 0.3;
        double min = yAxis.getDisplayPosition(yAxis.getMin());
        double max = yAxis.getDisplayPosition(yAxis.getMax());
        double zzVolume = volumeHeight * (max - min);
        gc.setFill((Paint)(open < close ? volumeLongColor : volumeShortColor));
        gc.fillRect(x0 - barWidthHalf, min + zzVolume, barWidth, -zzVolume);
    }

    protected void applyLocalYRange(DataSet ds, Axis yAxis, double xmin, double xmax) {
        double minYRange = Double.MAX_VALUE;
        double maxYRange = Double.MIN_VALUE;
        for (int i = ds.getIndex(0, new double[]{xmin}) + 1; i < Math.min(ds.getIndex(0, new double[]{xmax}) + 1, ds.getDataCount()); ++i) {
            double low = ds.get(3, i);
            double high = ds.get(2, i);
            if (minYRange > low) {
                minYRange = low;
            }
            if (!(maxYRange < high)) continue;
            maxYRange = high;
        }
        double space = (maxYRange - minYRange) * 0.05;
        yAxis.set(minYRange - space, maxYRange + space);
    }

    protected static Double getMostPopularElement(List<Double> a) {
        Double curr;
        int counter = 0;
        int maxcounter = -1;
        Double maxvalue = curr = a.get(0);
        for (Double e : a) {
            if (Math.abs(curr - e) < 1.0E-10) {
                ++counter;
                continue;
            }
            if (counter > maxcounter) {
                maxcounter = counter;
                maxvalue = curr;
            }
            counter = 0;
            curr = e;
        }
        if (counter > maxcounter) {
            maxvalue = curr;
        }
        return maxvalue;
    }

    protected static class XMinVolumeMaxAreaDistances
    implements FindAreaDistances {
        protected XMinVolumeMaxAreaDistances() {
        }

        @Override
        public double[] findAreaDistances(DataSet dataset, Axis xAxis, Axis yAxis, double xmin, double xmax) {
            double[] xminAreaDistances = new XMinAreaDistances().findAreaDistances(dataset, xAxis, yAxis, xmin, xmax);
            double maxVolume = Double.MIN_VALUE;
            int imin = dataset.getIndex(0, new double[]{xmin}) + 1;
            int imax = Math.min(dataset.getIndex(0, new double[]{xmax}) + 1, dataset.getDataCount());
            for (int i = imin; i < imax; ++i) {
                double volume = dataset.get(5, i);
                if (!(maxVolume < volume)) continue;
                maxVolume = volume;
            }
            return new double[]{xminAreaDistances[0], maxVolume};
        }
    }

    protected static class XMinAreaDistances
    implements FindAreaDistances {
        protected XMinAreaDistances() {
        }

        @Override
        public double[] findAreaDistances(DataSet dataset, Axis xAxis, Axis yAxis, double xmin, double xmax) {
            int imin = dataset.getIndex(0, new double[]{xmin}) + 1;
            int imax = Math.min(dataset.getIndex(0, new double[]{xmax}) + 1, dataset.getDataCount());
            int diff = imax - imin;
            int incr = diff > 30 ? (int)Math.round(Math.floor((double)diff / 30.0)) : 1;
            ArrayList<Double> distances = new ArrayList<Double>();
            for (int i = imin; i < imax; i += incr) {
                double param1;
                double param0 = xAxis.getDisplayPosition(dataset.get(0, i - 1));
                if (param0 == (param1 = xAxis.getDisplayPosition(dataset.get(0, i)))) continue;
                distances.add(Math.abs(param1 - param0));
            }
            double popularDistance = 0.0;
            if (!distances.isEmpty()) {
                Collections.sort(distances);
                popularDistance = AbstractFinancialRenderer.getMostPopularElement(distances);
            }
            return new double[]{popularDistance};
        }
    }

    @FunctionalInterface
    protected static interface FindAreaDistances {
        public double[] findAreaDistances(DataSet var1, Axis var2, Axis var3, double var4, double var6);
    }
}

