/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.financial;

import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.FontMetrics;
import com.sun.javafx.tk.Toolkit;
import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.financial.AbstractFinancialRenderer;
import de.gsi.chart.renderer.spi.financial.service.OhlcvRendererEpData;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEP;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEPAware;
import de.gsi.chart.renderer.spi.financial.service.footprint.FootprintRendererAttributes;
import de.gsi.chart.renderer.spi.financial.service.footprint.NbColumnColorGroup;
import de.gsi.chart.renderer.spi.utils.DefaultRenderColorScheme;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.financial.api.attrs.AttributeModelAware;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItemAware;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class FootprintRenderer
extends AbstractFinancialRenderer<FootprintRenderer>
implements Renderer,
RendererPaintAfterEPAware {
    private static final double FONT_RATIO = 13.0;
    private final boolean paintVolume;
    private final boolean paintPoc;
    private final boolean paintPullbackColumn;
    private final AbstractFinancialRenderer.FindAreaDistances findAreaDistances;
    private final IFootprintRenderedAPI footprintRenderedApi;
    private final FootprintRendererAttributes footprintAttrs;
    private final FontLoader fontLoader;
    private AttributeModelAware attrs;
    private IOhlcvItemAware itemAware;
    private boolean isEpAvailable;
    private Color pocColor;
    private Color footprintDefaultFontColor;
    private Color footprintCrossLineColor;
    private Color footprintBoxLongColor;
    private Color fooprintBoxShortColor;
    private Color footprintVolumeLongColor;
    private Color footprintVolumeShortColor;
    private double[] distances;
    private int iMin;
    private int iMax;
    private double localBarWidth;
    private double barWidthHalf;
    private double ratio;
    private Font basicFont;
    private Font selectedFont;
    private double fontGap;
    private double basicGap;
    private float heightText;
    protected List<RendererPaintAfterEP> paintAfterEPS = new ArrayList<RendererPaintAfterEP>();

    public FootprintRenderer(IFootprintRenderedAPI footprintRenderedApi, boolean paintVolume, boolean paintPoc, boolean paintPullbackColumn) {
        this.footprintRenderedApi = footprintRenderedApi;
        this.footprintAttrs = footprintRenderedApi.getFootprintAttributes();
        this.paintVolume = paintVolume;
        this.paintPoc = paintPoc;
        this.paintPullbackColumn = paintPullbackColumn;
        this.findAreaDistances = paintVolume ? new AbstractFinancialRenderer.XMinVolumeMaxAreaDistances() : new AbstractFinancialRenderer.XMinAreaDistances();
        this.fontLoader = Toolkit.getToolkit().getFontLoader();
    }

    public FootprintRenderer(IFootprintRenderedAPI footprintRenderedApi) {
        this(footprintRenderedApi, false, true, true);
    }

    public boolean isPaintVolume() {
        return this.paintVolume;
    }

    public boolean isPaintPoc() {
        return this.paintPoc;
    }

    public boolean isPaintPullbackColumn() {
        return this.paintPullbackColumn;
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        Canvas canvas = new Canvas((double)width, (double)height);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        String style = dataSet.getStyle();
        gc.save();
        Color candleLongColor = StyleParser.getColorPropertyValue(style, "candleLongColor", Color.GREEN);
        Color candleShortColor = StyleParser.getColorPropertyValue(style, "candleShortColor", Color.RED);
        gc.setFill((Paint)candleLongColor);
        gc.setStroke((Paint)candleLongColor);
        gc.fillRect(1.0, 3.0, (double)width / 2.0 - 2.0, (double)height - 8.0);
        double x = (double)width / 4.0;
        gc.strokeLine(x, 1.0, x, (double)height - 2.0);
        gc.setFill((Paint)candleShortColor);
        gc.setStroke((Paint)candleShortColor);
        gc.fillRect((double)width / 2.0 + 2.0, 4.0, (double)width - 2.0, (double)height - 12.0);
        x = 3.0 * (double)width / 4.0 + 1.5;
        gc.strokeLine(x, 1.0, x, (double)height - 3.0);
        gc.restore();
        return canvas;
    }

    @Override
    protected FootprintRenderer getThis() {
        return this;
    }

    @Override
    public List<DataSet> render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)super.getDatasets());
        long start = 0L;
        if (ProcessingProfiler.getDebugState()) {
            start = ProcessingProfiler.getTimeStamp();
        }
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        double xAxisWidth = xAxis.getWidth();
        double xmin = xAxis.getValueForDisplay(0.0);
        double xmax = xAxis.getValueForDisplay(xAxisWidth);
        int index = 0;
        for (DataSet ds : localDataSetList) {
            if (ds.getDimension() < 7) continue;
            int lindex = index;
            ds.lock().readLockGuardOptimistic(() -> {
                if (lindex == 0 && xyChart.getXAxis() instanceof CategoryAxis) {
                    CategoryAxis axis = (CategoryAxis)xyChart.getXAxis();
                    axis.updateCategories(ds);
                }
                this.attrs = null;
                if (ds instanceof AttributeModelAware) {
                    this.attrs = (AttributeModelAware)ds;
                }
                this.itemAware = (IOhlcvItemAware)ds;
                this.isEpAvailable = !this.paintAfterEPS.isEmpty() || this.paintBarMarker != null;
                gc.save();
                String style = ds.getStyle();
                DefaultRenderColorScheme.setLineScheme(gc, style, lindex);
                DefaultRenderColorScheme.setGraphicsContextAttributes(gc, style);
                Font basicFontTemplate = ((Font[])this.footprintAttrs.getRequiredAttribute(FootprintRendererAttributes.BID_ASK_VOLUME_FONTS))[1];
                Font selectedFontTemplate = ((Font[])this.footprintAttrs.getRequiredAttribute(FootprintRendererAttributes.BID_ASK_VOLUME_FONTS))[2];
                this.pocColor = StyleParser.getColorPropertyValue(style, "footprintPocColor", Color.rgb((int)255, (int)255, (int)0));
                this.footprintDefaultFontColor = StyleParser.getColorPropertyValue(style, "footprintDefaultFontColor", Color.rgb((int)255, (int)255, (int)255, (double)0.58));
                this.footprintCrossLineColor = StyleParser.getColorPropertyValue(style, "footprintCrossLineColor", Color.GRAY);
                this.footprintBoxLongColor = StyleParser.getColorPropertyValue(style, "footprintLongColor", Color.GREEN);
                this.fooprintBoxShortColor = StyleParser.getColorPropertyValue(style, "footprintShortColor", Color.RED);
                this.footprintVolumeLongColor = StyleParser.getColorPropertyValue(style, "footprintVolumeLongColor", Color.rgb((int)139, (int)199, (int)194, (double)0.2));
                this.footprintVolumeShortColor = StyleParser.getColorPropertyValue(style, "footprintVolumeShortColor", Color.rgb((int)235, (int)160, (int)159, (double)0.2));
                double barWidthPercent = StyleParser.getFloatingDecimalPropertyValue(style, "footprintBarWidthPercent", 0.5);
                double positionPaintMainRatio = StyleParser.getFloatingDecimalPropertyValue(style, "footprintPaintMainRatio", 5.157);
                if (ds.getDataCount() > 0) {
                    this.iMin = ds.getIndex(0, new double[]{xmin});
                    if (this.iMin < 0) {
                        this.iMin = 0;
                    }
                    this.iMax = Math.min(ds.getIndex(0, new double[]{xmax}) + 1, ds.getDataCount());
                    this.distances = null;
                    double minRequiredWidth = 0.0;
                    if (lindex == 0) {
                        this.distances = this.findAreaDistances(this.findAreaDistances, ds, xAxis, yAxis, xmin, xmax);
                        minRequiredWidth = this.distances[0];
                    }
                    this.localBarWidth = minRequiredWidth * barWidthPercent;
                    this.barWidthHalf = this.localBarWidth / 2.0;
                    this.ratio = Math.pow(this.localBarWidth, 0.25) * positionPaintMainRatio;
                    this.basicFont = this.getFontWithRatio(basicFontTemplate, this.ratio);
                    this.selectedFont = this.getFontWithRatio(selectedFontTemplate, this.ratio);
                    this.fontGap = this.getFontGap(5.0, this.ratio);
                    this.basicGap = this.getFontGap(1.0, this.ratio);
                    FontMetrics metricsBasicFont = this.getFontMetrics(this.basicFont);
                    this.heightText = metricsBasicFont.getLeading() + metricsBasicFont.getAscent();
                    for (int i = this.iMin; i < this.iMax; ++i) {
                        boolean isLastBar;
                        double x0 = xAxis.getDisplayPosition(ds.get(0, i));
                        IOhlcvItem ohlcvItem = this.itemAware.getItem(i);
                        IOhlcvItem lastOhlcvItem = this.itemAware.getLastItem();
                        boolean bl = isLastBar = lastOhlcvItem == null || lastOhlcvItem.getTimeStamp().equals(ohlcvItem.getTimeStamp());
                        if (!this.footprintRenderedApi.isFootprintAvailable(ohlcvItem)) continue;
                        Object object = this.footprintRenderedApi.getLock(ohlcvItem);
                        synchronized (object) {
                            IOhlcvItem pullbackColumn;
                            this.drawFootprintItem(gc, yAxis, ds, i, x0, ohlcvItem, this.isEpAvailable, isLastBar, this.paintVolume);
                            if (isLastBar && this.paintPullbackColumn && (pullbackColumn = this.footprintRenderedApi.getPullbackColumn(ohlcvItem)) != null) {
                                x0 = x0 + this.localBarWidth + this.barWidthHalf;
                                this.drawFootprintItem(gc, yAxis, ds, i, x0, pullbackColumn, false, true, false);
                            }
                            continue;
                        }
                    }
                }
                gc.restore();
            });
            if (this.computeLocalRange()) {
                this.applyLocalYRange(ds, yAxis, xmin, xmax);
            }
            ++index;
        }
        if (ProcessingProfiler.getDebugState()) {
            ProcessingProfiler.getTimeDiff((long)start);
        }
        return localDataSetList;
    }

    private void drawFootprintItem(GraphicsContext gc, Axis yAxis, DataSet ds, int i, double x0, IOhlcvItem ohlcvItem, boolean isEpAvailable, boolean isLastBar, boolean paintVolume) {
        double price;
        double yOpen = yAxis.getDisplayPosition(ohlcvItem.getOpen());
        double yHigh = yAxis.getDisplayPosition(ohlcvItem.getHigh());
        double yLow = yAxis.getDisplayPosition(ohlcvItem.getLow());
        double yClose = yAxis.getDisplayPosition(ohlcvItem.getClose());
        double open = ohlcvItem.getOpen();
        double close = ohlcvItem.getClose();
        Collection<Double[]> priceVolumeList = this.footprintRenderedApi.getPriceVolumeList(ohlcvItem);
        double pocPrice = this.footprintRenderedApi.getPocPrice(ohlcvItem);
        NbColumnColorGroup resultColorGroups = this.footprintRenderedApi.getColumnColorGroup(ohlcvItem);
        double yDiff = yOpen - yClose;
        double yMin = yDiff > 0.0 ? yClose : yOpen;
        OhlcvRendererEpData data = null;
        if (isEpAvailable) {
            data = new OhlcvRendererEpData();
            data.gc = gc;
            data.ds = ds;
            data.attrs = this.attrs;
            data.ohlcvItemAware = this.itemAware;
            data.ohlcvItem = ohlcvItem;
            data.index = i;
            data.minIndex = this.iMin;
            data.maxIndex = this.iMax;
            data.barWidth = this.localBarWidth;
            data.barWidthHalf = this.barWidthHalf;
            data.xCenter = x0;
            data.yOpen = yOpen;
            data.yHigh = yHigh;
            data.yLow = yLow;
            data.yClose = yClose;
            data.yDiff = yDiff;
            data.yMin = yMin;
        }
        if (paintVolume) {
            assert (this.distances != null);
            this.paintVolume(gc, ds, i, this.footprintVolumeLongColor, this.footprintVolumeShortColor, yAxis, this.distances, this.localBarWidth, this.barWidthHalf, x0);
        }
        Paint barPaint = null;
        if (data != null) {
            barPaint = this.getPaintBarColor(data);
        }
        gc.setStroke((Paint)this.footprintCrossLineColor);
        gc.strokeLine(x0, yHigh - (double)this.heightText / 2.0, x0, yLow + (double)this.heightText / 2.0);
        double maxWidthTextBid = -1.7976931348623157E308;
        for (Double[] priceVolume : priceVolumeList) {
            double widthTextAsk;
            price = priceVolume[0];
            double bidVolume = priceVolume[1];
            double askVolume = priceVolume[2];
            boolean isLastBarAndLastPrice = isLastBar && price == close;
            double widthTextBidBasic = Utils.computeTextWidth((Font)this.basicFont, (String)this.getFormattedVolume(bidVolume), (double)0.0);
            double widthTextBidSelected = Utils.computeTextWidth((Font)this.selectedFont, (String)this.getFormattedVolume(bidVolume), (double)0.0);
            double widthTextAskBasic = Utils.computeTextWidth((Font)this.basicFont, (String)this.getFormattedVolume(askVolume), (double)0.0);
            double widthTextAskSelected = Utils.computeTextWidth((Font)this.selectedFont, (String)this.getFormattedVolume(askVolume), (double)0.0);
            double widthTextBid = isLastBarAndLastPrice ? widthTextBidSelected : widthTextBidBasic;
            double d = widthTextAsk = isLastBarAndLastPrice ? widthTextAskSelected : widthTextAskBasic;
            if (widthTextBidBasic > maxWidthTextBid) {
                maxWidthTextBid = widthTextBidBasic;
            }
            double xxBid = x0 - widthTextBid - this.fontGap;
            double xxAsk = x0 + this.fontGap;
            double bidAskVolumeY = yAxis.getDisplayPosition(price) + (double)this.heightText / 2.0;
            if (this.paintPoc && price == pocPrice) {
                gc.setStroke((Paint)this.pocColor);
                gc.setLineCap(StrokeLineCap.BUTT);
                gc.setLineJoin(StrokeLineJoin.MITER);
                gc.setMiterLimit(10.0);
                gc.setLineWidth(1.5);
                gc.strokeRect(x0 - widthTextBid - this.fontGap - 2.0 * this.basicGap, bidAskVolumeY - (double)this.heightText - this.basicGap, widthTextBid + widthTextAsk + 2.0 * this.fontGap + 2.0 * this.basicGap, (double)this.heightText + 4.0 * this.basicGap);
            }
            if (resultColorGroups != null) {
                NbColumnColorGroup.FontColor fontColor = resultColorGroups.fontColorMap.get(price);
                gc.setFont(isLastBarAndLastPrice ? this.selectedFont : fontColor.bidFont);
                gc.setFont(new Font(this.calcFontSize(gc.getFont().getSize(), this.ratio)));
                gc.setFill((Paint)fontColor.bidColor);
                gc.fillText(this.getFormattedVolume(bidVolume), xxBid, bidAskVolumeY);
                gc.setFont(isLastBarAndLastPrice ? this.selectedFont : fontColor.askFont);
                gc.setFont(new Font(this.calcFontSize(gc.getFont().getSize(), this.ratio)));
                gc.setFill((Paint)fontColor.askColor);
                gc.fillText(this.getFormattedVolume(askVolume), xxAsk, bidAskVolumeY);
                continue;
            }
            gc.setFont(isLastBarAndLastPrice ? this.selectedFont : this.basicFont);
            gc.setFill((Paint)this.footprintDefaultFontColor);
            gc.fillText(this.getFormattedVolume(bidVolume), xxBid, bidAskVolumeY);
            gc.fillText(this.getFormattedVolume(askVolume), xxAsk, bidAskVolumeY);
        }
        for (Double[] priceVolume : priceVolumeList) {
            price = priceVolume[0];
            double bidAskVolumeY = yAxis.getDisplayPosition(price) + (double)this.heightText / 2.0;
            if (!(close > open && price >= open && price <= close) && (!(close <= open) || !(price <= open) || !(price >= close))) continue;
            gc.setLineWidth(1.0);
            if (close > open) {
                if (barPaint != null) {
                    gc.setFill(barPaint);
                } else {
                    gc.setFill((Paint)this.footprintBoxLongColor);
                }
            } else if (barPaint != null) {
                gc.setFill(barPaint);
            } else {
                gc.setFill((Paint)this.fooprintBoxShortColor);
            }
            gc.fillRect(x0 - maxWidthTextBid - this.fontGap - 10.0 * this.basicGap, bidAskVolumeY - (double)this.heightText, 4.0 * this.basicGap, (double)this.heightText);
        }
        if (isEpAvailable) {
            EpDataAddon epDataAddon = new EpDataAddon();
            epDataAddon.basicGap = this.basicGap;
            epDataAddon.fontGap = this.fontGap;
            epDataAddon.heightText = this.heightText;
            epDataAddon.maxWidthTextBid = maxWidthTextBid;
            data.addon = epDataAddon;
            this.paintAfter(data);
        }
    }

    private String getFormattedVolume(double askVolume) {
        return String.format("%1.0f", askVolume);
    }

    private Font getFontWithRatio(Font fontTemplate, double ratio) {
        return Font.font((String)fontTemplate.getFamily(), (FontWeight)FontWeight.findByName((String)fontTemplate.getStyle()), (double)this.calcFontSize(fontTemplate.getSize(), ratio));
    }

    private double calcFontSize(double size, double ratio) {
        return size / 13.0 * ratio;
    }

    private double getFontGap(double gap, double ratio) {
        return gap / 13.0 * ratio;
    }

    private FontMetrics getFontMetrics(Font font) {
        return this.fontLoader.getFontMetrics(font);
    }

    protected void paintAfter(OhlcvRendererEpData data) {
        for (RendererPaintAfterEP paintAfterEP : this.paintAfterEPS) {
            paintAfterEP.paintAfter(data);
        }
    }

    @Override
    public void addPaintAfterEp(RendererPaintAfterEP paintAfterEP) {
        this.paintAfterEPS.add(paintAfterEP);
    }

    @Override
    public List<RendererPaintAfterEP> getPaintAfterEps() {
        return this.paintAfterEPS;
    }

    public static class EpDataAddon {
        public double heightText;
        public double fontGap;
        public double basicGap;
        public double maxWidthTextBid;
    }

    public static interface IFootprintRenderedAPI {
        public boolean isFootprintAvailable(IOhlcvItem var1);

        public FootprintRendererAttributes getFootprintAttributes();

        public Collection<Double[]> getPriceVolumeList(IOhlcvItem var1);

        public double getPocPrice(IOhlcvItem var1);

        public NbColumnColorGroup getColumnColorGroup(IOhlcvItem var1);

        public IOhlcvItem getPullbackColumn(IOhlcvItem var1);

        public Object getLock(IOhlcvItem var1);
    }
}

