/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.financial;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.spi.financial.service.DataSetAware;
import de.gsi.chart.renderer.spi.financial.service.OhlcvRendererEpData;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEP;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class PositionFinancialRendererPaintAfterEP
implements RendererPaintAfterEP,
DataSetAware {
    protected final DataSet ds;
    protected final XYChart chart;
    protected final Axis xAxis;
    protected final Axis yAxis;
    private Color positionTriangleLongColor;
    private Color positionTriangleShortColor;
    private Color positionTriangleExitColor;
    private Color positionArrowLongColor;
    private Color positionArrowShortColor;
    private Color positionArrowExitColor;
    private Color positionLabelTradeDescriptionColor;
    private Color positionOrderLinkageProfitColor;
    private Color positionOrderLinkageLossColor;
    private String positionLabelLongText;
    private String positionLabelShortText;
    private double positionPaintMainRatio;
    private double positionOrderLinkageLineDash;
    private double positionOrderLinkageLineWidth;

    public PositionFinancialRendererPaintAfterEP(DataSet positionDataSet, XYChart chart) {
        this.ds = positionDataSet;
        this.chart = chart;
        this.xAxis = chart.getXAxis();
        this.yAxis = chart.getYAxis();
        if (!(positionDataSet instanceof PositionRenderedAware)) {
            throw new IllegalArgumentException("The position dataset has to implement PositionRenderedAware interface");
        }
    }

    @Override
    public DataSet getDataSet() {
        return this.ds;
    }

    protected void initByDatasetFxStyle() {
        String style = this.ds.getStyle();
        this.positionTriangleLongColor = StyleParser.getColorPropertyValue(style, "positionTriangleLongColor", Color.GREEN);
        this.positionTriangleShortColor = StyleParser.getColorPropertyValue(style, "positionTriangleShortColor", Color.RED);
        this.positionTriangleExitColor = StyleParser.getColorPropertyValue(style, "positionTriangleExitColor", Color.BLACK);
        this.positionArrowLongColor = StyleParser.getColorPropertyValue(style, "positionArrowLongColor", Color.GREEN);
        this.positionArrowShortColor = StyleParser.getColorPropertyValue(style, "positionArrowShortColor", Color.RED);
        this.positionArrowExitColor = StyleParser.getColorPropertyValue(style, "positionArrowExitColor", Color.BLACK);
        this.positionLabelTradeDescriptionColor = StyleParser.getColorPropertyValue(style, "positionLabelTradeDescriptionColor", Color.BLACK);
        this.positionOrderLinkageProfitColor = StyleParser.getColorPropertyValue(style, "positionOrderLinkageProfitColor", Color.GREEN);
        this.positionOrderLinkageLossColor = StyleParser.getColorPropertyValue(style, "positionOrderLinkageLossColor", Color.RED);
        this.positionLabelLongText = StyleParser.getPropertyValue(style, "positionLabelLongText", "Buy%n%1.0f%n(%1.1f)");
        this.positionLabelShortText = StyleParser.getPropertyValue(style, "positionLabelShortText", "Sell%n%1.0f%n(%1.1f)");
        this.positionOrderLinkageLineDash = StyleParser.getFloatingDecimalPropertyValue(style, "positionOrderLinkageLineDash", 8.0);
        this.positionOrderLinkageLineWidth = StyleParser.getFloatingDecimalPropertyValue(style, "positionOrderLinkageLineWidth", 2.0);
        this.positionPaintMainRatio = StyleParser.getFloatingDecimalPropertyValue(style, "positionPaintMainRatio", 5.157);
    }

    @Override
    public void paintAfter(OhlcvRendererEpData d) {
        String label;
        long xcorr;
        PositionRendered position;
        if (d.index == d.minIndex) {
            this.initByDatasetFxStyle();
        }
        if ((position = ((PositionRenderedAware)this.ds).getPositionByTime(xcorr = Math.round((double)d.ohlcvItem.getTimeStamp().getTime() / 1000.0))) == null) {
            return;
        }
        d.gc.save();
        double x0 = d.xCenter;
        double yPrice = this.yAxis.getDisplayPosition(position.price);
        double ratio = Math.pow(d.barWidth, 0.25) * this.positionPaintMainRatio;
        double arrowSize = ratio * 0.25;
        d.gc.setStroke((Paint)Color.BLACK);
        d.gc.setLineWidth(1.0);
        if (position.entryExit == 1) {
            d.gc.setFill((Paint)(position.posType > 0 ? this.positionTriangleLongColor : this.positionTriangleShortColor));
            this.drawTriangle(d, x0, yPrice, ratio, -1.0);
        } else {
            d.gc.setFill((Paint)this.positionTriangleExitColor);
            this.drawTriangle(d, x0, yPrice, ratio, 1.0);
        }
        if (position.entryExit == 1) {
            if (position.posType > 0) {
                d.gc.setFill((Paint)this.positionArrowLongColor);
                this.drawArrow(d, x0, d.yLow + ratio, arrowSize, 1.0);
            } else {
                d.gc.setFill((Paint)this.positionArrowShortColor);
                this.drawArrow(d, x0, d.yHigh - ratio, arrowSize, -1.0);
            }
        } else {
            d.gc.setFill((Paint)this.positionArrowExitColor);
            if (position.posType > 0) {
                this.drawArrow(d, x0, d.yHigh - ratio, arrowSize, -1.0);
            } else {
                this.drawArrow(d, x0, d.yLow + ratio, arrowSize, 1.0);
            }
        }
        d.gc.setStroke((Paint)this.positionLabelTradeDescriptionColor);
        d.gc.setFill((Paint)this.positionLabelTradeDescriptionColor);
        d.gc.setFont(new Font(1.5 * ratio));
        d.gc.setTextAlign(TextAlignment.CENTER);
        if (position.posType > 0 && position.entryExit == 1 || position.posType < 0 && position.entryExit != 1) {
            label = String.format(this.positionLabelLongText, position.quantity, position.price);
            d.gc.fillText(label, x0, d.yLow + 6.0 * ratio);
        } else {
            label = String.format(this.positionLabelShortText, -position.quantity, position.price);
            d.gc.fillText(label, x0, d.yHigh - 9.0 * ratio);
        }
        if (position.entryExit != 1) {
            for (List<Double> joinedEntry : position.joinedEntries) {
                double xe0 = this.xAxis.getDisplayPosition(joinedEntry.get(0));
                double ye1 = this.yAxis.getDisplayPosition(joinedEntry.get(1));
                d.gc.setStroke((Paint)(joinedEntry.get(2) > 0.0 ? this.positionOrderLinkageProfitColor : this.positionOrderLinkageLossColor));
                d.gc.setLineWidth(this.positionOrderLinkageLineWidth);
                d.gc.setLineDashes(new double[]{this.positionOrderLinkageLineDash});
                d.gc.strokeLine(x0, yPrice, xe0, ye1);
            }
        }
        d.gc.restore();
    }

    protected void drawArrow(OhlcvRendererEpData d, double x0, double start, double ratio, double sign) {
        d.gc.fillPolygon(new double[]{x0, x0 - 3.0 * ratio, x0 - 1.5 * ratio, x0 - 1.5 * ratio, x0 + 1.5 * ratio, x0 + 1.5 * ratio, x0 + 3.0 * ratio, x0}, new double[]{start, start + sign * 3.0 * ratio, start + sign * 3.0 * ratio, start + sign * 9.0 * ratio, start + sign * 9.0 * ratio, start + sign * 3.0 * ratio, start + sign * 3.0 * ratio, start}, 8);
    }

    protected void drawTriangle(OhlcvRendererEpData d, double x0, double yPrice, double trSize, double sign) {
        d.gc.fillPolygon(new double[]{x0, x0 + sign * trSize, x0 + sign * trSize, x0}, new double[]{yPrice, yPrice + trSize, yPrice - trSize, yPrice}, 4);
    }

    public static class PositionRendered
    implements Comparable<PositionRendered> {
        public long positionId;
        public long index;
        public int entryExit;
        public double quantity;
        public int posType;
        public double price;
        public boolean closed;
        public List<List<Double>> joinedEntries = new ArrayList<List<Double>>();

        @Override
        public int compareTo(PositionRendered o) {
            return Double.compare(this.index, o.index);
        }

        public String toString() {
            return "PositionRendered{positionId=" + this.positionId + ", index=" + this.index + ", entryExit=" + this.entryExit + ", quantity=" + this.quantity + ", posType=" + this.posType + ", price=" + this.price + ", closed=" + this.closed + ", joinedEntries=" + this.joinedEntries + "}";
        }
    }

    public static interface PositionRenderedAware {
        public PositionRendered getPositionByTime(long var1);
    }
}

