/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.financial.service.footprint;

import de.gsi.dataset.spi.financial.api.attrs.AttributeKey;
import de.gsi.dataset.spi.financial.api.attrs.AttributeModel;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class FootprintRendererAttributes
extends AttributeModel {
    public static final AttributeKey<Boolean> COLUMN_COLORING_FEATURE_ACTIVE = AttributeKey.create(Boolean.class, (String)"COLUMN_COLORING_FEATURE_ACTIVE");
    public static final AttributeKey<Boolean> DRAW_PULLBACK_COLUMN = AttributeKey.create(Boolean.class, (String)"DRAW_PULLBACK_COLUMN");
    public static final AttributeKey<Boolean> DRAW_POC_RECTANGLE_OF_EACH_BAR = AttributeKey.create(Boolean.class, (String)"DRAW_POC_RECTANGLE_OF_EACH_BAR");
    public static final AttributeKey<Color[][]> COLUMN_COLOR_GROUP_SETTINGS = AttributeKey.create(Color[][].class, (String)"COLUMN_COLOR_GROUP_SETTINGS");
    public static final AttributeKey<Double[]> COLUMN_COLOR_GROUP_THRESHOLDS = AttributeKey.create(Double[].class, (String)"COLUMN_COLOR_GROUP_THRESHOLDS");
    public static final AttributeKey<Double> BID_ASK_BOLD_THRESHOLD = AttributeKey.create(Double.class, (String)"BID_ASK_BOLD_THRESHOLD");
    public static final AttributeKey<Font[]> BID_ASK_VOLUME_FONTS = AttributeKey.create(Font[].class, (String)"BID_ASK_VOLUME_FONTS");

    public static FootprintRendererAttributes getDefaultValues(String scheme) {
        Color[][] columnColorGroupSettings;
        FootprintRendererAttributes model = new FootprintRendererAttributes();
        model.setAttribute(COLUMN_COLORING_FEATURE_ACTIVE, true);
        model.setAttribute(DRAW_POC_RECTANGLE_OF_EACH_BAR, true);
        model.setAttribute(DRAW_PULLBACK_COLUMN, true);
        model.setAttribute(COLUMN_COLOR_GROUP_THRESHOLDS, new Double[]{40.0, 100.0, 150.0});
        model.setAttribute(BID_ASK_BOLD_THRESHOLD, 30.0);
        model.setAttribute(BID_ASK_VOLUME_FONTS, new Font[]{Font.font((String)"Segoe UI", (FontWeight)FontWeight.NORMAL, (double)13.0), Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)12.0), Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)15.0)});
        switch (scheme) {
            case "SAND": 
            case "CLASSIC": 
            case "CLEARLOOK": {
                columnColorGroupSettings = new Color[][]{{Color.rgb((int)0, (int)128, (int)255), Color.rgb((int)128, (int)128, (int)128), Color.rgb((int)255, (int)128, (int)192), Color.rgb((int)242, (int)0, (int)0)}, {Color.rgb((int)0, (int)128, (int)255), Color.rgb((int)128, (int)128, (int)128), Color.rgb((int)124, (int)190, (int)190), Color.rgb((int)0, (int)128, (int)0)}};
                break;
            }
            default: {
                columnColorGroupSettings = new Color[][]{{Color.rgb((int)0, (int)128, (int)255), Color.rgb((int)255, (int)255, (int)255), Color.rgb((int)255, (int)128, (int)192), Color.rgb((int)242, (int)0, (int)0)}, {Color.rgb((int)0, (int)128, (int)255), Color.rgb((int)255, (int)255, (int)255), Color.rgb((int)124, (int)190, (int)190), Color.rgb((int)0, (int)128, (int)0)}};
            }
        }
        model.setAttribute(COLUMN_COLOR_GROUP_SETTINGS, columnColorGroupSettings);
        return model;
    }
}

