/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.marchingsquares;

import de.gsi.chart.renderer.spi.marchingsquares.Cell;
import de.gsi.chart.renderer.spi.marchingsquares.GeneralPath;
import de.gsi.chart.renderer.spi.marchingsquares.Grid;
import javafx.geometry.Side;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathGenerator.class);
    private static final double EPSILON = 1.0E-7;

    PathGenerator() {
    }

    public GeneralPath generalPath(Grid grid) {
        GeneralPath result = new GeneralPath();
        for (int r = 0; r < grid.rowCount; ++r) {
            for (int c = 0; c < grid.colCount; ++c) {
                Cell cell = grid.getCellAt(r, c);
                if (cell == null || cell.isTrivial() || cell.isSaddle()) continue;
                this.update(grid, r, c, result);
            }
        }
        return result;
    }

    private Side nextSide(Cell cell, Side prev) {
        return this.secondSide(cell, prev);
    }

    private Side secondSide(Cell cell, Side prev) {
        switch (cell.getCellNdx()) {
            case 8: 
            case 12: 
            case 14: {
                return Side.LEFT;
            }
            case 1: 
            case 9: 
            case 13: {
                return Side.BOTTOM;
            }
            case 2: 
            case 3: 
            case 11: {
                return Side.RIGHT;
            }
            case 4: 
            case 6: 
            case 7: {
                return Side.TOP;
            }
            case 5: {
                if (prev == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.atError().addArgument((Object)cell).log("cell '{}' switch case 5, prev is null");
                    }
                    throw new IllegalStateException("cell " + cell + " prev is null");
                }
                switch (prev) {
                    case LEFT: {
                        return cell.isFlipped() ? Side.BOTTOM : Side.TOP;
                    }
                    case RIGHT: {
                        return cell.isFlipped() ? Side.TOP : Side.BOTTOM;
                    }
                }
                String m = "Saddle w/ no connected neighbour; Cell = " + cell + ", previous side = " + prev;
                throw new IllegalStateException(m);
            }
            case 10: {
                if (prev == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.atError().addArgument((Object)cell).log("cell '{}' switch case 5, prev is null");
                    }
                    throw new IllegalStateException("cell " + cell + " prev is null");
                }
                switch (prev) {
                    case BOTTOM: {
                        return cell.isFlipped() ? Side.RIGHT : Side.LEFT;
                    }
                    case TOP: {
                        return cell.isFlipped() ? Side.LEFT : Side.RIGHT;
                    }
                }
                String m = "Saddle w/ no connected neighbour; Cell = " + cell + ", previous side = " + prev;
                throw new IllegalStateException(m);
            }
        }
        String m = "Attempt to use a trivial Cell as a node: " + cell;
        throw new IllegalStateException(m);
    }

    private void update(Grid grid, int rowIndex, int clumnIndex, GeneralPath path) {
        Side prevSide = null;
        int r = rowIndex;
        int c = clumnIndex;
        Cell start = grid.getCellAt(r, c);
        float[] pt = start.getXY(PathGenerator.firstSide(start, prevSide));
        float x = (float)c + pt[0];
        float y = (float)r + pt[1];
        path.moveTo(x, y);
        pt = start.getXY(this.secondSide(start, prevSide));
        float xPrev = (float)c + pt[0];
        float yPrev = (float)r + pt[1];
        prevSide = this.nextSide(start, prevSide);
        switch (prevSide) {
            case BOTTOM: {
                --r;
                break;
            }
            case LEFT: {
                --c;
                break;
            }
            case RIGHT: {
                ++c;
                break;
            }
            case TOP: {
                ++r;
                break;
            }
        }
        start.clear();
        Cell currentCell = grid.getCellAt(r, c);
        while (!start.equals(currentCell)) {
            pt = currentCell.getXY(this.secondSide(currentCell, prevSide));
            x = (float)c + pt[0];
            y = (float)r + pt[1];
            if ((double)Math.abs(x - xPrev) > 1.0E-7 && (double)Math.abs(y - yPrev) > 1.0E-7) {
                path.lineTo(x, y);
            }
            xPrev = x;
            yPrev = y;
            prevSide = this.nextSide(currentCell, prevSide);
            switch (prevSide) {
                case BOTTOM: {
                    --r;
                    break;
                }
                case LEFT: {
                    --c;
                    break;
                }
                case RIGHT: {
                    ++c;
                    break;
                }
                case TOP: {
                    ++r;
                    break;
                }
            }
            currentCell.clear();
            currentCell = grid.getCellAt(r, c);
        }
        path.closePath();
    }

    private static Side firstSide(Cell cell, Side prev) {
        switch (cell.getCellNdx()) {
            case 1: 
            case 3: 
            case 7: {
                return Side.LEFT;
            }
            case 2: 
            case 6: 
            case 14: {
                return Side.BOTTOM;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: {
                return Side.RIGHT;
            }
            case 8: 
            case 9: {
                return Side.TOP;
            }
            case 5: {
                if (prev == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.atError().addArgument((Object)cell).log("cell '{}' switch case 5, prev is null");
                    }
                    throw new IllegalStateException("cell " + cell + " prev is null");
                }
                switch (prev) {
                    case LEFT: {
                        return Side.RIGHT;
                    }
                    case RIGHT: {
                        return Side.LEFT;
                    }
                }
                throw new NoSaddlePointException(cell, prev);
            }
            case 10: {
                if (prev == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.atError().addArgument((Object)cell).log("cell '{}' switch case 5, prev is null");
                    }
                    throw new IllegalStateException("cell " + cell + " prev is null");
                }
                switch (prev) {
                    case BOTTOM: {
                        return Side.TOP;
                    }
                    case TOP: {
                        return Side.BOTTOM;
                    }
                }
                throw new NoSaddlePointException(cell, prev);
            }
        }
        String m = "Attempt to use a trivial cell as a start node: " + cell;
        throw new IllegalStateException(m);
    }

    protected static class NoSaddlePointException
    extends IllegalStateException {
        private static final long serialVersionUID = -5628254997299110176L;

        NoSaddlePointException(Cell cell, Side prev) {
            super("Saddle w/ no connected neighbour; Cell = " + cell + ", previous side = " + prev);
        }
    }
}

