/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.utils;

import de.gsi.chart.Chart;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public final class ChartIconFactory {
    private static final String ICON_INFO = "I";
    private static final String ICON_WARN = "W";
    private static final String ICON_ERROR = "E";
    private static final Map<String, Color[]> colourMap = new HashMap<String, Color[]>();
    private static final int DEFAULT_HEIGHT = 32;
    public static Font iconFont;

    private ChartIconFactory() {
    }

    public static Node getErrorIcon() {
        return ChartIconFactory.getIcon(ICON_ERROR);
    }

    public static Node getErrorIcon(double size) {
        return ChartIconFactory.getIcon(ICON_ERROR, size);
    }

    private static Node getIcon(String iconString) {
        return ChartIconFactory.getIcon(iconString, 32.0);
    }

    public static Node getIcon(String iconString, double size) {
        Group group = new Group();
        Text text1 = new Text(iconString);
        text1.setFont(Font.font((String)"fair-chart-icons", (double)size));
        text1.setFill((Paint)colourMap.get(iconString)[0]);
        Text text2 = new Text(Character.toString(iconString.charAt(0) + '\u0001'));
        text2.setFont(Font.font((String)"fair-chart-icons", (double)size));
        text2.setFill((Paint)colourMap.get(iconString)[1]);
        group.getChildren().addAll((Object[])new Node[]{text1, text2});
        return group;
    }

    public static Node getInfoIcon() {
        return ChartIconFactory.getIcon(ICON_INFO);
    }

    public static Node getInfoIcon(double size) {
        return ChartIconFactory.getIcon(ICON_INFO, size);
    }

    public static Node getWarningIcon() {
        return ChartIconFactory.getIcon(ICON_WARN);
    }

    public static Node getWarningIcon(double size) {
        return ChartIconFactory.getIcon(ICON_WARN, size);
    }

    static {
        try (InputStream fontStream = Chart.class.getResourceAsStream("fonts/fair-chart-icons.ttf");){
            iconFont = Font.loadFont((InputStream)fontStream, (double)32.0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        colourMap.put(ICON_INFO, new Color[]{Color.rgb((int)0, (int)0, (int)200), Color.WHITE});
        colourMap.put(ICON_WARN, new Color[]{Color.rgb((int)255, (int)215, (int)0), Color.BLACK});
        colourMap.put(ICON_ERROR, new Color[]{Color.rgb((int)237, (int)28, (int)36), Color.WHITE});
    }
}

