/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.ui;

import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;

public class BorderedTitledPane
extends StackPane {
    private final Label title;
    private final StackPane contentPane;

    public BorderedTitledPane(String titleString, Node content) {
        this.getStyleClass().add((Object)"bordered-titled-border");
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        this.title = new Label(titleString);
        this.title.getStyleClass().add((Object)"bordered-titled-title");
        StackPane.setAlignment((Node)this.title, (Pos)Pos.TOP_LEFT);
        this.contentPane = new StackPane();
        content.getStyleClass().add((Object)"bordered-titled-content");
        this.contentPane.getChildren().add((Object)content);
        this.getChildren().addAll((Object[])new Node[]{this.contentPane, this.title});
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("titled-border.css")).toExternalForm();
    }

    public StackPane getContentPane() {
        return this.contentPane;
    }

    public Label getTitle() {
        return this.title;
    }
}

