/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.ui;

import java.security.InvalidParameterException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javafx.collections.ObservableListBase;

public class ObservableDeque<E>
extends ObservableListBase<E>
implements Deque<E> {
    private final transient Deque<E> deque;

    public ObservableDeque(Deque<E> deque) {
        if (deque == null) {
            throw new InvalidParameterException("deque must not be null");
        }
        this.deque = deque;
    }

    @Override
    public void clear() {
        if (this.hasListeners()) {
            this.beginChange();
            this.nextRemove(0, (List)((Object)this));
        }
        this.deque.clear();
        ++this.modCount;
        if (this.hasListeners()) {
            this.endChange();
        }
    }

    @Override
    public boolean offer(E e) {
        this.beginChange();
        boolean result = this.deque.offer(e);
        if (result) {
            this.nextAdd(this.deque.size() - 1, this.deque.size());
        }
        this.endChange();
        return result;
    }

    @Override
    public boolean add(E e) {
        this.beginChange();
        try {
            this.deque.add(e);
            this.nextAdd(this.deque.size() - 1, this.deque.size());
            boolean bl = true;
            return bl;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public E remove() {
        this.beginChange();
        try {
            E e = this.deque.remove();
            this.nextRemove(0, e);
            E e2 = e;
            return e2;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public E poll() {
        this.beginChange();
        E e = this.deque.poll();
        if (e != null) {
            this.nextRemove(0, e);
        }
        this.endChange();
        return e;
    }

    @Override
    public E element() {
        return this.deque.element();
    }

    @Override
    public E peek() {
        return this.deque.peek();
    }

    public E get(int index) {
        Iterator<E> iterator = this.deque.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public void addFirst(E e) {
        this.beginChange();
        try {
            this.deque.addFirst(e);
            this.nextAdd(0, 1);
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public void addLast(E e) {
        this.beginChange();
        try {
            this.deque.addLast(e);
            this.nextAdd(this.deque.size() - 1, this.deque.size());
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public boolean offerFirst(E e) {
        if (this.deque.offerFirst(e)) {
            this.beginChange();
            try {
                this.nextAdd(0, this.deque.size());
            }
            finally {
                this.endChange();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean offerLast(E e) {
        if (this.deque.offerLast(e)) {
            try {
                this.deque.addLast(e);
                this.nextAdd(this.deque.size() - 1, this.deque.size());
            }
            finally {
                this.endChange();
            }
            return true;
        }
        return false;
    }

    @Override
    public E removeFirst() {
        this.beginChange();
        E e = this.deque.removeFirst();
        if (e != null) {
            this.nextRemove(0, e);
        }
        this.endChange();
        return e;
    }

    @Override
    public E removeLast() {
        this.beginChange();
        E e = this.deque.removeLast();
        if (e != null) {
            this.nextRemove(this.deque.size() - 1, e);
        }
        this.endChange();
        return e;
    }

    @Override
    public E pollFirst() {
        this.beginChange();
        E e = this.deque.pollFirst();
        if (e != null) {
            this.nextRemove(0, e);
        }
        this.endChange();
        return e;
    }

    @Override
    public E pollLast() {
        this.beginChange();
        E e = this.deque.pollLast();
        if (e != null) {
            this.nextRemove(this.deque.size(), e);
        }
        this.endChange();
        return e;
    }

    @Override
    public E getFirst() {
        return this.deque.getFirst();
    }

    @Override
    public E getLast() {
        return this.deque.getLast();
    }

    @Override
    public E peekFirst() {
        return this.deque.peekFirst();
    }

    @Override
    public E peekLast() {
        return this.deque.peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (o == null) {
            return false;
        }
        Iterator<E> iterator = this.deque.iterator();
        this.beginChange();
        for (int i = 0; i < this.deque.size(); ++i) {
            E e = iterator.next();
            if (!o.equals(e)) continue;
            this.nextRemove(i, e);
            this.endChange();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o == null) {
            return false;
        }
        Iterator<E> iterator = this.deque.descendingIterator();
        this.beginChange();
        for (int i = 0; i < this.deque.size(); ++i) {
            E e = iterator.next();
            if (!o.equals(e)) continue;
            this.nextRemove(this.deque.size() - 1 - i, e);
            this.endChange();
            return true;
        }
        return false;
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.deque.descendingIterator();
    }
}

