/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.ui;

import java.util.ArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.kordamp.ikonli.javafx.FontIcon;

public class TilingPane
extends GridPane {
    protected static final String FONT_AWESOME = "FontAwesome";
    protected static final int FONT_SIZE = 20;
    private final ObjectProperty<Layout> layout = new SimpleObjectProperty<Layout>((Object)this, "layout", Layout.GRID){

        public void set(Layout newLayout) {
            if (newLayout == null) {
                throw new IllegalArgumentException("layout must not be null");
            }
            super.set((Object)newLayout);
        }
    };

    public TilingPane() {
        this(Layout.GRID);
    }

    public TilingPane(Layout layout) {
        this(layout, null);
    }

    public TilingPane(Layout layout, Node ... nodes) {
        this.layout.set((Object)layout);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        this.getChildren().addListener(change -> {
            while (change.next()) {
                this.layoutNormal();
            }
        });
        this.layout.addListener((ch, o, n) -> this.layoutNormal());
        if (nodes != null) {
            this.getChildren().addAll((Object[])nodes);
        }
    }

    public Layout getLayout() {
        return (Layout)((Object)this.layoutProperty().get());
    }

    public ObjectProperty<Layout> layoutProperty() {
        return this.layout;
    }

    public void setLayout(Layout value) {
        this.layoutProperty().set((Object)value);
    }

    public String toString() {
        return TilingPane.class.getSimpleName() + "('" + this.getLayout() + "0')";
    }

    protected int getColumnsCount() {
        int childCount = this.getChildren().size();
        if (childCount == 0) {
            return 1;
        }
        switch (this.getLayout()) {
            case HBOX: {
                return childCount;
            }
            case MAXIMISE: 
            case VBOX: {
                return 1;
            }
        }
        if (childCount < 4) {
            return 2;
        }
        return (int)Math.ceil(Math.sqrt(childCount));
    }

    protected void layoutNormal() {
        if (this.getChildren().isEmpty()) {
            return;
        }
        int colsCount = this.getColumnsCount();
        if (this.getColumnConstraints().size() != colsCount) {
            ArrayList<ColumnConstraints> colConstraintList = new ArrayList<ColumnConstraints>();
            for (int i = 0; i < colsCount; ++i) {
                ColumnConstraints colConstraints = new ColumnConstraints();
                colConstraints.setPercentWidth(100.0 / (double)colsCount);
                colConstraints.setFillWidth(true);
                colConstraintList.add(colConstraints);
            }
            this.getColumnConstraints().setAll(colConstraintList);
        }
        int rowIndex = 0;
        int colIndex = 0;
        int childCount = 0;
        int nChildren = this.getChildren().size();
        int nColSpan = Math.max(1, colsCount / (nChildren - childCount));
        for (Node child : this.getChildren()) {
            GridPane.setFillWidth((Node)child, (Boolean)true);
            GridPane.setFillHeight((Node)child, (Boolean)true);
            GridPane.setColumnIndex((Node)child, (Integer)colIndex);
            GridPane.setRowIndex((Node)child, (Integer)rowIndex);
            if (colIndex == 0 && nChildren - childCount < colsCount) {
                nColSpan = Math.max(1, colsCount / (nChildren - childCount));
            }
            if (nChildren - childCount == 1 && colIndex < colsCount) {
                nColSpan = colsCount - colIndex;
            }
            GridPane.setColumnSpan((Node)child, (Integer)nColSpan);
            if ((colIndex += nColSpan) >= colsCount) {
                colIndex = 0;
                ++rowIndex;
            }
            ++childCount;
        }
    }

    public static enum Layout {
        HBOX("HBox", "fas-arrows-alt-h:20"),
        VBOX("VBox", "fas-arrows-alt-v:20"),
        GRID("Grid", "fas-th:20"),
        MAXIMISE("Maximise", "fas-window-maximize:20");

        private final String name;
        private final String iconCode;

        private Layout(String name, String iconCode) {
            this.name = name;
            this.iconCode = iconCode;
        }

        public Node getIcon() {
            return new FontIcon(this.iconCode);
        }

        public String getName() {
            return this.name;
        }
    }
}

