/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import de.gsi.chart.utils.NumberFormatter;
import java.text.DecimalFormat;
import javafx.util.StringConverter;

public class DecimalStringConverter
extends StringConverter<Number>
implements NumberFormatter {
    private int precision = 6;
    private final DecimalFormat format = new DecimalFormat();

    public DecimalStringConverter() {
        this.buildFormat(this.precision);
    }

    public DecimalStringConverter(int precision) {
        this.precision = precision;
        this.buildFormat(precision);
    }

    private void buildFormat(int precision) {
        if (precision == 0) {
            this.format.applyPattern("#0");
        } else {
            StringBuilder sb = new StringBuilder(32);
            sb.append("0.");
            sb.append("0".repeat(Math.max(0, precision)));
            this.format.applyPattern(sb.toString());
        }
    }

    public Number fromString(String string) {
        return Double.parseDouble(string);
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public boolean isExponentialForm() {
        return false;
    }

    @Override
    public NumberFormatter setExponentialForm(boolean state) {
        return this;
    }

    @Override
    public NumberFormatter setPrecision(int precision) {
        this.precision = precision;
        this.buildFormat(precision);
        return this;
    }

    @Override
    public String toString(double val) {
        return this.toString((Number)val);
    }

    public String toString(Number object) {
        return this.format.format(object);
    }
}

