/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import de.gsi.chart.axes.spi.AbstractAxis;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;

public class MasterSlaveAxisSynchronizer {
    private final AbstractAxis master;
    private final ArrayList<AbstractAxis> slaves = new ArrayList();

    public MasterSlaveAxisSynchronizer(AbstractAxis master) {
        this.master = master;
        master.maxProperty().addListener((p, o, n) -> this.upperBoundChanged(n.doubleValue()));
        master.minProperty().addListener((p, o, n) -> this.lowerBoundChanged(n.doubleValue()));
    }

    public void add(AbstractAxis axis) {
        this.slaves.add(axis);
        axis.setAutoRanging(false);
        axis.tickUnitProperty().bind((ObservableValue)this.master.tickUnitProperty());
    }

    private void lowerBoundChanged(double value) {
        if (Double.isNaN(value)) {
            return;
        }
        for (AbstractAxis slave : this.slaves) {
            slave.setMin(value);
        }
    }

    public void remove(AbstractAxis axis) {
        this.slaves.remove(axis);
        axis.tickUnitProperty().unbind();
        axis.setAutoRanging(true);
    }

    private void upperBoundChanged(double value) {
        if (Double.isNaN(value)) {
            return;
        }
        for (AbstractAxis slave : this.slaves) {
            slave.setMax(value);
        }
    }
}

