/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import javafx.geometry.Bounds;
import javafx.geometry.Point2D;

public final class MouseUtils {
    private MouseUtils() {
    }

    public static double mouseOutsideBoundaryBoxDistance(Bounds screenBounds, Point2D mouseLoc) {
        if (screenBounds.contains(mouseLoc)) {
            return 0.0;
        }
        double x = mouseLoc.getX();
        double y = mouseLoc.getY();
        double minX = x < screenBounds.getMinX() ? screenBounds.getMinX() - x : (x > screenBounds.getMaxX() ? x - screenBounds.getMaxX() : 0.0);
        double minY = y < screenBounds.getMinY() ? screenBounds.getMinY() - y : (y > screenBounds.getMaxY() ? y - screenBounds.getMaxY() : 0.0);
        return Math.max(minX, minY);
    }

    public static double mouseInsideBoundaryBoxDistance(Bounds screenBounds, Point2D mouseLoc) {
        if (!screenBounds.contains(mouseLoc)) {
            return 0.0;
        }
        double x = mouseLoc.getX();
        double y = mouseLoc.getY();
        double minX = x > screenBounds.getMinX() && x < screenBounds.getMaxX() ? Math.min(x - screenBounds.getMinX(), screenBounds.getMaxX() - x) : 0.0;
        double minY = y > screenBounds.getMinY() && y < screenBounds.getMaxY() ? Math.min(y - screenBounds.getMinY(), screenBounds.getMaxY() - y) : 0.0;
        return Math.min(minX, minY);
    }
}

