/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import com.ibm.icu.text.DecimalFormat;
import de.gsi.chart.utils.NumberFormatter;
import javafx.util.StringConverter;

public class NumberFormatterImpl
extends StringConverter<Number>
implements NumberFormatter {
    public static final char DEFAULT_DECIMAL_SEPARATOR = ' ';
    protected DecimalFormat formatter = new DecimalFormat();

    public NumberFormatterImpl() {
        this.formatter.setGroupingSize(0);
    }

    public NumberFormatterImpl(int precision, boolean exponentialForm) {
        this();
        this.setPrecision(precision);
        this.setExponentialForm(exponentialForm);
    }

    public Number fromString(String string) {
        return Double.parseDouble(string);
    }

    public DecimalFormat getFormatter() {
        return this.formatter;
    }

    @Override
    public int getPrecision() {
        return this.formatter.getMinimumSignificantDigits();
    }

    @Override
    public boolean isExponentialForm() {
        return this.formatter.isScientificNotation();
    }

    @Override
    public NumberFormatter setExponentialForm(boolean state) {
        this.formatter.setScientificNotation(state);
        return this;
    }

    @Override
    public NumberFormatter setPrecision(int precision) {
        this.formatter.setSignificantDigitsUsed(true);
        this.formatter.setMinimumSignificantDigits(precision);
        this.formatter.setMinimumFractionDigits(2);
        this.formatter.setMaximumFractionDigits(2);
        return this;
    }

    @Override
    public String toString(double val) {
        return this.formatter.format(val);
    }

    public String toString(Number object) {
        return this.toString(object.doubleValue());
    }
}

